/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.genetics.AbstractListChromosome;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.CrossoverPolicy;
import org.apache.commons.math3.genetics.GeneticAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnePointCrossover<T>
implements CrossoverPolicy {
    @Override
    public ChromosomePair crossover(Chromosome chromosome, Chromosome chromosome2) {
        if (!(chromosome instanceof AbstractListChromosome) || !(chromosome2 instanceof AbstractListChromosome)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INVALID_FIXED_LENGTH_CHROMOSOME, new Object[0]);
        }
        return this.crossover((AbstractListChromosome)chromosome, (AbstractListChromosome)chromosome2);
    }

    private ChromosomePair crossover(AbstractListChromosome<T> abstractListChromosome, AbstractListChromosome<T> abstractListChromosome2) {
        int n;
        int n2 = abstractListChromosome.getLength();
        if (n2 != abstractListChromosome2.getLength()) {
            throw new DimensionMismatchException(abstractListChromosome2.getLength(), n2);
        }
        List<T> list = abstractListChromosome.getRepresentation();
        List<T> list2 = abstractListChromosome2.getRepresentation();
        ArrayList<T> arrayList = new ArrayList<T>(n2);
        ArrayList<T> arrayList2 = new ArrayList<T>(n2);
        int n3 = 1 + GeneticAlgorithm.getRandomGenerator().nextInt(n2 - 2);
        for (n = 0; n < n3; ++n) {
            arrayList.add(list.get(n));
            arrayList2.add(list2.get(n));
        }
        for (n = n3; n < n2; ++n) {
            arrayList.add(list2.get(n));
            arrayList2.add(list.get(n));
        }
        return new ChromosomePair(abstractListChromosome.newFixedLengthChromosome(arrayList), abstractListChromosome2.newFixedLengthChromosome(arrayList2));
    }
}

