/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.commons.math3.genetics.MutationPolicy;
import org.apache.commons.math3.genetics.RandomKey;

public class RandomKeyMutation
implements MutationPolicy {
    public Chromosome mutate(Chromosome chromosome) {
        if (!(chromosome instanceof RandomKey)) {
            throw new MathIllegalArgumentException(LocalizedFormats.RANDOMKEY_MUTATION_WRONG_CLASS, chromosome.getClass().getSimpleName());
        }
        RandomKey randomKey = (RandomKey)chromosome;
        List list = randomKey.getRepresentation();
        int n = GeneticAlgorithm.getRandomGenerator().nextInt(list.size());
        ArrayList arrayList = new ArrayList(list);
        arrayList.set(n, GeneticAlgorithm.getRandomGenerator().nextDouble());
        return randomKey.newFixedLengthChromosome(arrayList);
    }
}

