/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.commons.math3.genetics.ListPopulation;
import org.apache.commons.math3.genetics.Population;
import org.apache.commons.math3.genetics.SelectionPolicy;

public class TournamentSelection
implements SelectionPolicy {
    private int arity;

    public TournamentSelection(int n) {
        this.arity = n;
    }

    public ChromosomePair select(Population population) {
        return new ChromosomePair(this.tournament((ListPopulation)population), this.tournament((ListPopulation)population));
    }

    private Chromosome tournament(ListPopulation listPopulation) {
        if (listPopulation.getPopulationSize() < this.arity) {
            throw new MathIllegalArgumentException(LocalizedFormats.TOO_LARGE_TOURNAMENT_ARITY, this.arity, listPopulation.getPopulationSize());
        }
        ListPopulation listPopulation2 = new ListPopulation(this.arity){

            public Population nextGeneration() {
                return null;
            }
        };
        ArrayList<Chromosome> arrayList = new ArrayList<Chromosome>(listPopulation.getChromosomes());
        for (int i = 0; i < this.arity; ++i) {
            int n = GeneticAlgorithm.getRandomGenerator().nextInt(arrayList.size());
            listPopulation2.addChromosome((Chromosome)arrayList.get(n));
            arrayList.remove(n);
        }
        return listPopulation2.getFittestChromosome();
    }

    public int getArity() {
        return this.arity;
    }

    public void setArity(int n) {
        this.arity = n;
    }
}

