/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.util.CompositeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VectorFormat<S extends Space> {
    public static final String DEFAULT_PREFIX = "{";
    public static final String DEFAULT_SUFFIX = "}";
    public static final String DEFAULT_SEPARATOR = "; ";
    private final String prefix;
    private final String suffix;
    private final String separator;
    private final String trimmedPrefix;
    private final String trimmedSuffix;
    private final String trimmedSeparator;
    private final NumberFormat format;

    protected VectorFormat() {
        this(DEFAULT_PREFIX, DEFAULT_SUFFIX, DEFAULT_SEPARATOR, CompositeFormat.getDefaultNumberFormat());
    }

    protected VectorFormat(NumberFormat numberFormat) {
        this(DEFAULT_PREFIX, DEFAULT_SUFFIX, DEFAULT_SEPARATOR, numberFormat);
    }

    protected VectorFormat(String string, String string2, String string3) {
        this(string, string2, string3, CompositeFormat.getDefaultNumberFormat());
    }

    protected VectorFormat(String string, String string2, String string3, NumberFormat numberFormat) {
        this.prefix = string;
        this.suffix = string2;
        this.separator = string3;
        this.trimmedPrefix = string.trim();
        this.trimmedSuffix = string2.trim();
        this.trimmedSeparator = string3.trim();
        this.format = numberFormat;
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getSeparator() {
        return this.separator;
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public String format(Vector<S> vector) {
        return this.format(vector, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(Vector<S> var1, StringBuffer var2, FieldPosition var3);

    protected StringBuffer format(StringBuffer stringBuffer, FieldPosition fieldPosition, double ... dArray) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        stringBuffer.append(this.prefix);
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(this.separator);
            }
            CompositeFormat.formatDouble(dArray[i], this.format, stringBuffer, fieldPosition);
        }
        stringBuffer.append(this.suffix);
        return stringBuffer;
    }

    public abstract Vector<S> parse(String var1);

    public abstract Vector<S> parse(String var1, ParsePosition var2);

    protected double[] parseCoordinates(int n, String string, ParsePosition parsePosition) {
        int n2 = parsePosition.getIndex();
        double[] dArray = new double[n];
        CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
        if (!CompositeFormat.parseFixedstring(string, this.trimmedPrefix, parsePosition)) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
            if (i > 0 && !CompositeFormat.parseFixedstring(string, this.trimmedSeparator, parsePosition)) {
                return null;
            }
            CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
            Number number = CompositeFormat.parseNumber(string, this.format, parsePosition);
            if (number == null) {
                parsePosition.setIndex(n2);
                return null;
            }
            dArray[i] = number.doubleValue();
        }
        CompositeFormat.parseAndIgnoreWhitespace(string, parsePosition);
        if (!CompositeFormat.parseFixedstring(string, this.trimmedSuffix, parsePosition)) {
            return null;
        }
        return dArray;
    }
}

