/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.oned;

import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.partitioning.Region;

public class Interval {
    private final double lower;
    private final double upper;

    public Interval(double d, double d2) {
        if (d2 < d) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)d2, d, true);
        }
        this.lower = d;
        this.upper = d2;
    }

    public double getInf() {
        return this.lower;
    }

    @Deprecated
    public double getLower() {
        return this.getInf();
    }

    public double getSup() {
        return this.upper;
    }

    @Deprecated
    public double getUpper() {
        return this.getSup();
    }

    public double getSize() {
        return this.upper - this.lower;
    }

    @Deprecated
    public double getLength() {
        return this.getSize();
    }

    public double getBarycenter() {
        return 0.5 * (this.lower + this.upper);
    }

    @Deprecated
    public double getMidPoint() {
        return this.getBarycenter();
    }

    public Region.Location checkPoint(double d, double d2) {
        if (d < this.lower - d2 || d > this.upper + d2) {
            return Region.Location.OUTSIDE;
        }
        if (d > this.lower + d2 && d < this.upper - d2) {
            return Region.Location.INSIDE;
        }
        return Region.Location.BOUNDARY;
    }
}

