/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.io.Serializable;
import java.text.NumberFormat;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3DFormat;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldVector3D<T extends RealFieldElement<T>>
implements Serializable {
    private static final long serialVersionUID = 20130224L;
    private final T x;
    private final T y;
    private final T z;

    public FieldVector3D(T t, T t2, T t3) {
        this.x = t;
        this.y = t2;
        this.z = t3;
    }

    public FieldVector3D(T[] TArray) {
        if (TArray.length != 3) {
            throw new DimensionMismatchException(TArray.length, 3);
        }
        this.x = TArray[0];
        this.y = TArray[1];
        this.z = TArray[2];
    }

    public FieldVector3D(T t, T t2) {
        RealFieldElement realFieldElement = (RealFieldElement)t2.cos();
        this.x = ((RealFieldElement)t.cos()).multiply(realFieldElement);
        this.y = ((RealFieldElement)t.sin()).multiply(realFieldElement);
        this.z = (RealFieldElement)t2.sin();
    }

    public FieldVector3D(T t, FieldVector3D<T> fieldVector3D) {
        this.x = (RealFieldElement)t.multiply(fieldVector3D.x);
        this.y = (RealFieldElement)t.multiply(fieldVector3D.y);
        this.z = (RealFieldElement)t.multiply(fieldVector3D.z);
    }

    public FieldVector3D(T t, Vector3D vector3D) {
        this.x = (RealFieldElement)t.multiply(vector3D.getX());
        this.y = (RealFieldElement)t.multiply(vector3D.getY());
        this.z = (RealFieldElement)t.multiply(vector3D.getZ());
    }

    public FieldVector3D(double d, FieldVector3D<T> fieldVector3D) {
        this.x = (RealFieldElement)fieldVector3D.x.multiply(d);
        this.y = (RealFieldElement)fieldVector3D.y.multiply(d);
        this.z = (RealFieldElement)fieldVector3D.z.multiply(d);
    }

    public FieldVector3D(T t, FieldVector3D<T> fieldVector3D, T t2, FieldVector3D<T> fieldVector3D2) {
        T t3 = t;
        this.x = (RealFieldElement)t3.linearCombination(t, fieldVector3D.getX(), t2, fieldVector3D2.getX());
        this.y = (RealFieldElement)t3.linearCombination(t, fieldVector3D.getY(), t2, fieldVector3D2.getY());
        this.z = (RealFieldElement)t3.linearCombination(t, fieldVector3D.getZ(), t2, fieldVector3D2.getZ());
    }

    public FieldVector3D(T t, Vector3D vector3D, T t2, Vector3D vector3D2) {
        T t3 = t;
        this.x = (RealFieldElement)t3.linearCombination(vector3D.getX(), t, vector3D2.getX(), t2);
        this.y = (RealFieldElement)t3.linearCombination(vector3D.getY(), t, vector3D2.getY(), t2);
        this.z = (RealFieldElement)t3.linearCombination(vector3D.getZ(), t, vector3D2.getZ(), t2);
    }

    public FieldVector3D(double d, FieldVector3D<T> fieldVector3D, double d2, FieldVector3D<T> fieldVector3D2) {
        T t = fieldVector3D.getX();
        this.x = (RealFieldElement)t.linearCombination(d, fieldVector3D.getX(), d2, fieldVector3D2.getX());
        this.y = (RealFieldElement)t.linearCombination(d, fieldVector3D.getY(), d2, fieldVector3D2.getY());
        this.z = (RealFieldElement)t.linearCombination(d, fieldVector3D.getZ(), d2, fieldVector3D2.getZ());
    }

    public FieldVector3D(T t, FieldVector3D<T> fieldVector3D, T t2, FieldVector3D<T> fieldVector3D2, T t3, FieldVector3D<T> fieldVector3D3) {
        T t4 = t;
        this.x = (RealFieldElement)t4.linearCombination(t, fieldVector3D.getX(), t2, fieldVector3D2.getX(), t3, fieldVector3D3.getX());
        this.y = (RealFieldElement)t4.linearCombination(t, fieldVector3D.getY(), t2, fieldVector3D2.getY(), t3, fieldVector3D3.getY());
        this.z = (RealFieldElement)t4.linearCombination(t, fieldVector3D.getZ(), t2, fieldVector3D2.getZ(), t3, fieldVector3D3.getZ());
    }

    public FieldVector3D(T t, Vector3D vector3D, T t2, Vector3D vector3D2, T t3, Vector3D vector3D3) {
        T t4 = t;
        this.x = (RealFieldElement)t4.linearCombination(vector3D.getX(), t, vector3D2.getX(), t2, vector3D3.getX(), t3);
        this.y = (RealFieldElement)t4.linearCombination(vector3D.getY(), t, vector3D2.getY(), t2, vector3D3.getY(), t3);
        this.z = (RealFieldElement)t4.linearCombination(vector3D.getZ(), t, vector3D2.getZ(), t2, vector3D3.getZ(), t3);
    }

    public FieldVector3D(double d, FieldVector3D<T> fieldVector3D, double d2, FieldVector3D<T> fieldVector3D2, double d3, FieldVector3D<T> fieldVector3D3) {
        T t = fieldVector3D.getX();
        this.x = (RealFieldElement)t.linearCombination(d, fieldVector3D.getX(), d2, fieldVector3D2.getX(), d3, fieldVector3D3.getX());
        this.y = (RealFieldElement)t.linearCombination(d, fieldVector3D.getY(), d2, fieldVector3D2.getY(), d3, fieldVector3D3.getY());
        this.z = (RealFieldElement)t.linearCombination(d, fieldVector3D.getZ(), d2, fieldVector3D2.getZ(), d3, fieldVector3D3.getZ());
    }

    public FieldVector3D(T t, FieldVector3D<T> fieldVector3D, T t2, FieldVector3D<T> fieldVector3D2, T t3, FieldVector3D<T> fieldVector3D3, T t4, FieldVector3D<T> fieldVector3D4) {
        T t5 = t;
        this.x = (RealFieldElement)t5.linearCombination(t, fieldVector3D.getX(), t2, fieldVector3D2.getX(), t3, fieldVector3D3.getX(), t4, fieldVector3D4.getX());
        this.y = (RealFieldElement)t5.linearCombination(t, fieldVector3D.getY(), t2, fieldVector3D2.getY(), t3, fieldVector3D3.getY(), t4, fieldVector3D4.getY());
        this.z = (RealFieldElement)t5.linearCombination(t, fieldVector3D.getZ(), t2, fieldVector3D2.getZ(), t3, fieldVector3D3.getZ(), t4, fieldVector3D4.getZ());
    }

    public FieldVector3D(T t, Vector3D vector3D, T t2, Vector3D vector3D2, T t3, Vector3D vector3D3, T t4, Vector3D vector3D4) {
        T t5 = t;
        this.x = (RealFieldElement)t5.linearCombination(vector3D.getX(), t, vector3D2.getX(), t2, vector3D3.getX(), t3, vector3D4.getX(), t4);
        this.y = (RealFieldElement)t5.linearCombination(vector3D.getY(), t, vector3D2.getY(), t2, vector3D3.getY(), t3, vector3D4.getY(), t4);
        this.z = (RealFieldElement)t5.linearCombination(vector3D.getZ(), t, vector3D2.getZ(), t2, vector3D3.getZ(), t3, vector3D4.getZ(), t4);
    }

    public FieldVector3D(double d, FieldVector3D<T> fieldVector3D, double d2, FieldVector3D<T> fieldVector3D2, double d3, FieldVector3D<T> fieldVector3D3, double d4, FieldVector3D<T> fieldVector3D4) {
        T t = fieldVector3D.getX();
        this.x = (RealFieldElement)t.linearCombination(d, fieldVector3D.getX(), d2, fieldVector3D2.getX(), d3, fieldVector3D3.getX(), d4, fieldVector3D4.getX());
        this.y = (RealFieldElement)t.linearCombination(d, fieldVector3D.getY(), d2, fieldVector3D2.getY(), d3, fieldVector3D3.getY(), d4, fieldVector3D4.getY());
        this.z = (RealFieldElement)t.linearCombination(d, fieldVector3D.getZ(), d2, fieldVector3D2.getZ(), d3, fieldVector3D3.getZ(), d4, fieldVector3D4.getZ());
    }

    public T getX() {
        return this.x;
    }

    public T getY() {
        return this.y;
    }

    public T getZ() {
        return this.z;
    }

    public T[] toArray() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.x.getField(), 3);
        realFieldElementArray[0] = this.x;
        realFieldElementArray[1] = this.y;
        realFieldElementArray[2] = this.z;
        return realFieldElementArray;
    }

    public Vector3D toVector3D() {
        return new Vector3D(this.x.getReal(), this.y.getReal(), this.z.getReal());
    }

    public T getNorm1() {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.x.abs()).add(this.y.abs())).add(this.z.abs()));
    }

    public T getNorm() {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.x.multiply(this.x)).add(this.y.multiply(this.y))).add(this.z.multiply(this.z))).sqrt());
    }

    public T getNormSq() {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.x.multiply(this.x)).add(this.y.multiply(this.y))).add(this.z.multiply(this.z)));
    }

    public T getNormInf() {
        RealFieldElement realFieldElement = (RealFieldElement)this.x.abs();
        RealFieldElement realFieldElement2 = (RealFieldElement)this.y.abs();
        RealFieldElement realFieldElement3 = (RealFieldElement)this.z.abs();
        if (realFieldElement.getReal() <= realFieldElement2.getReal()) {
            if (realFieldElement2.getReal() <= realFieldElement3.getReal()) {
                return (T)realFieldElement3;
            }
            return (T)realFieldElement2;
        }
        if (realFieldElement.getReal() <= realFieldElement3.getReal()) {
            return (T)realFieldElement3;
        }
        return (T)realFieldElement;
    }

    public T getAlpha() {
        return (T)((RealFieldElement)this.y.atan2(this.x));
    }

    public T getDelta() {
        return (T)((RealFieldElement)((RealFieldElement)this.z.divide(this.getNorm())).asin());
    }

    public FieldVector3D<T> add(FieldVector3D<T> fieldVector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.add(fieldVector3D.x), (RealFieldElement)this.y.add(fieldVector3D.y), (RealFieldElement)this.z.add(fieldVector3D.z));
    }

    public FieldVector3D<T> add(Vector3D vector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.add(vector3D.getX()), (RealFieldElement)this.y.add(vector3D.getY()), (RealFieldElement)this.z.add(vector3D.getZ()));
    }

    public FieldVector3D<T> add(T t, FieldVector3D<T> fieldVector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.getField().getOne(), (FieldVector3D<RealFieldElement>)this, (RealFieldElement)t, (FieldVector3D<RealFieldElement>)fieldVector3D);
    }

    public FieldVector3D<T> add(T t, Vector3D vector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.add(t.multiply(vector3D.getX())), (RealFieldElement)this.y.add(t.multiply(vector3D.getY())), (RealFieldElement)this.z.add(t.multiply(vector3D.getZ())));
    }

    public FieldVector3D<T> add(double d, FieldVector3D<T> fieldVector3D) {
        return new FieldVector3D<T>(1.0, this, d, fieldVector3D);
    }

    public FieldVector3D<T> add(double d, Vector3D vector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.add(d * vector3D.getX()), (RealFieldElement)this.y.add(d * vector3D.getY()), (RealFieldElement)this.z.add(d * vector3D.getZ()));
    }

    public FieldVector3D<T> subtract(FieldVector3D<T> fieldVector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.subtract(fieldVector3D.x), (RealFieldElement)this.y.subtract(fieldVector3D.y), (RealFieldElement)this.z.subtract(fieldVector3D.z));
    }

    public FieldVector3D<T> subtract(Vector3D vector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.subtract(vector3D.getX()), (RealFieldElement)this.y.subtract(vector3D.getY()), (RealFieldElement)this.z.subtract(vector3D.getZ()));
    }

    public FieldVector3D<T> subtract(T t, FieldVector3D<T> fieldVector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.getField().getOne(), this, (RealFieldElement)t.negate(), fieldVector3D);
    }

    public FieldVector3D<T> subtract(T t, Vector3D vector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.subtract(t.multiply(vector3D.getX())), (RealFieldElement)this.y.subtract(t.multiply(vector3D.getY())), (RealFieldElement)this.z.subtract(t.multiply(vector3D.getZ())));
    }

    public FieldVector3D<T> subtract(double d, FieldVector3D<T> fieldVector3D) {
        return new FieldVector3D<T>(1.0, this, -d, fieldVector3D);
    }

    public FieldVector3D<T> subtract(double d, Vector3D vector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.subtract(d * vector3D.getX()), (RealFieldElement)this.y.subtract(d * vector3D.getY()), (RealFieldElement)this.z.subtract(d * vector3D.getZ()));
    }

    public FieldVector3D<T> normalize() {
        T t = this.getNorm();
        if (t.getReal() == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, new Object[0]);
        }
        return this.scalarMultiply((RealFieldElement)t.reciprocal());
    }

    public FieldVector3D<T> orthogonal() {
        double d = 0.6 * this.getNorm().getReal();
        if (d == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        if (FastMath.abs(this.x.getReal()) <= d) {
            RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.y.multiply(this.y)).add(this.z.multiply(this.z))).sqrt()).reciprocal();
            return new FieldVector3D<RealFieldElement>((RealFieldElement)realFieldElement.getField().getZero(), (RealFieldElement)realFieldElement.multiply(this.z), (RealFieldElement)((RealFieldElement)realFieldElement.multiply(this.y)).negate());
        }
        if (FastMath.abs(this.y.getReal()) <= d) {
            RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.x.multiply(this.x)).add(this.z.multiply(this.z))).sqrt()).reciprocal();
            return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)realFieldElement.multiply(this.z)).negate(), (RealFieldElement)realFieldElement.getField().getZero(), (RealFieldElement)realFieldElement.multiply(this.x));
        }
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.x.multiply(this.x)).add(this.y.multiply(this.y))).sqrt()).reciprocal();
        return new FieldVector3D<RealFieldElement>((RealFieldElement)realFieldElement.multiply(this.y), (RealFieldElement)((RealFieldElement)realFieldElement.multiply(this.x)).negate(), (RealFieldElement)realFieldElement.getField().getZero());
    }

    public static <T extends RealFieldElement<T>> T angle(FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2) {
        RealFieldElement realFieldElement = (RealFieldElement)fieldVector3D.getNorm().multiply(fieldVector3D2.getNorm());
        if (realFieldElement.getReal() == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        RealFieldElement realFieldElement2 = FieldVector3D.dotProduct(fieldVector3D, fieldVector3D2);
        double d = realFieldElement.getReal() * 0.9999;
        if (realFieldElement2.getReal() < -d || realFieldElement2.getReal() > d) {
            FieldVector3D<T> fieldVector3D3 = FieldVector3D.crossProduct(fieldVector3D, fieldVector3D2);
            if (realFieldElement2.getReal() >= 0.0) {
                return (T)((RealFieldElement)fieldVector3D3.getNorm().divide((RealFieldElement)realFieldElement).asin());
            }
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D3.getNorm().divide((RealFieldElement)realFieldElement).asin()).subtract(Math.PI)).negate());
        }
        return (T)((RealFieldElement)realFieldElement2.divide((RealFieldElement)realFieldElement).acos());
    }

    public static <T extends RealFieldElement<T>> T angle(FieldVector3D<T> fieldVector3D, Vector3D vector3D) {
        RealFieldElement realFieldElement = (RealFieldElement)fieldVector3D.getNorm().multiply(vector3D.getNorm());
        if (realFieldElement.getReal() == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        RealFieldElement realFieldElement2 = FieldVector3D.dotProduct(fieldVector3D, vector3D);
        double d = realFieldElement.getReal() * 0.9999;
        if (realFieldElement2.getReal() < -d || realFieldElement2.getReal() > d) {
            FieldVector3D<T> fieldVector3D2 = FieldVector3D.crossProduct(fieldVector3D, vector3D);
            if (realFieldElement2.getReal() >= 0.0) {
                return (T)((RealFieldElement)fieldVector3D2.getNorm().divide((RealFieldElement)realFieldElement).asin());
            }
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D2.getNorm().divide((RealFieldElement)realFieldElement).asin()).subtract(Math.PI)).negate());
        }
        return (T)((RealFieldElement)realFieldElement2.divide((RealFieldElement)realFieldElement).acos());
    }

    public static <T extends RealFieldElement<T>> T angle(Vector3D vector3D, FieldVector3D<T> fieldVector3D) {
        return FieldVector3D.angle(fieldVector3D, vector3D);
    }

    public FieldVector3D<T> negate() {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.negate(), (RealFieldElement)this.y.negate(), (RealFieldElement)this.z.negate());
    }

    public FieldVector3D<T> scalarMultiply(T t) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.multiply(t), (RealFieldElement)this.y.multiply(t), (RealFieldElement)this.z.multiply(t));
    }

    public FieldVector3D<T> scalarMultiply(double d) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.multiply(d), (RealFieldElement)this.y.multiply(d), (RealFieldElement)this.z.multiply(d));
    }

    public boolean isNaN() {
        return Double.isNaN(this.x.getReal()) || Double.isNaN(this.y.getReal()) || Double.isNaN(this.z.getReal());
    }

    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.x.getReal()) || Double.isInfinite(this.y.getReal()) || Double.isInfinite(this.z.getReal()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FieldVector3D) {
            FieldVector3D fieldVector3D = (FieldVector3D)object;
            if (fieldVector3D.isNaN()) {
                return this.isNaN();
            }
            return this.x.equals(fieldVector3D.x) && this.y.equals(fieldVector3D.y) && this.z.equals(fieldVector3D.z);
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 409;
        }
        return 311 * (107 * this.x.hashCode() + 83 * this.y.hashCode() + this.z.hashCode());
    }

    public T dotProduct(FieldVector3D<T> fieldVector3D) {
        return (T)((RealFieldElement)this.x.linearCombination(this.x, fieldVector3D.x, this.y, fieldVector3D.y, this.z, fieldVector3D.z));
    }

    public T dotProduct(Vector3D vector3D) {
        return (T)((RealFieldElement)this.x.linearCombination(vector3D.getX(), this.x, vector3D.getY(), this.y, vector3D.getZ(), this.z));
    }

    public FieldVector3D<T> crossProduct(FieldVector3D<T> fieldVector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.linearCombination(this.y, fieldVector3D.z, this.z.negate(), fieldVector3D.y), (RealFieldElement)this.y.linearCombination(this.z, fieldVector3D.x, this.x.negate(), fieldVector3D.z), (RealFieldElement)this.z.linearCombination(this.x, fieldVector3D.y, this.y.negate(), fieldVector3D.x));
    }

    public FieldVector3D<T> crossProduct(Vector3D vector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)this.x.linearCombination(vector3D.getZ(), this.y, -vector3D.getY(), this.z), (RealFieldElement)this.y.linearCombination(vector3D.getX(), this.z, -vector3D.getZ(), this.x), (RealFieldElement)this.z.linearCombination(vector3D.getY(), this.x, -vector3D.getX(), this.y));
    }

    public T distance1(FieldVector3D<T> fieldVector3D) {
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)fieldVector3D.x.subtract(this.x)).abs();
        RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)fieldVector3D.y.subtract(this.y)).abs();
        RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)fieldVector3D.z.subtract(this.z)).abs();
        return (T)realFieldElement.add(realFieldElement2).add(realFieldElement3);
    }

    public T distance1(Vector3D vector3D) {
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)this.x.subtract(vector3D.getX())).abs();
        RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)this.y.subtract(vector3D.getY())).abs();
        RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)this.z.subtract(vector3D.getZ())).abs();
        return (T)realFieldElement.add(realFieldElement2).add(realFieldElement3);
    }

    public T distance(FieldVector3D<T> fieldVector3D) {
        RealFieldElement realFieldElement = (RealFieldElement)fieldVector3D.x.subtract(this.x);
        RealFieldElement realFieldElement2 = (RealFieldElement)fieldVector3D.y.subtract(this.y);
        RealFieldElement realFieldElement3 = (RealFieldElement)fieldVector3D.z.subtract(this.z);
        return (T)((RealFieldElement)realFieldElement.multiply(realFieldElement).add(realFieldElement2.multiply(realFieldElement2)).add(realFieldElement3.multiply(realFieldElement3)).sqrt());
    }

    public T distance(Vector3D vector3D) {
        RealFieldElement realFieldElement = (RealFieldElement)this.x.subtract(vector3D.getX());
        RealFieldElement realFieldElement2 = (RealFieldElement)this.y.subtract(vector3D.getY());
        RealFieldElement realFieldElement3 = (RealFieldElement)this.z.subtract(vector3D.getZ());
        return (T)((RealFieldElement)realFieldElement.multiply(realFieldElement).add(realFieldElement2.multiply(realFieldElement2)).add(realFieldElement3.multiply(realFieldElement3)).sqrt());
    }

    public T distanceInf(FieldVector3D<T> fieldVector3D) {
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)fieldVector3D.x.subtract(this.x)).abs();
        RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)fieldVector3D.y.subtract(this.y)).abs();
        RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)fieldVector3D.z.subtract(this.z)).abs();
        if (realFieldElement.getReal() <= realFieldElement2.getReal()) {
            if (realFieldElement2.getReal() <= realFieldElement3.getReal()) {
                return (T)realFieldElement3;
            }
            return (T)realFieldElement2;
        }
        if (realFieldElement.getReal() <= realFieldElement3.getReal()) {
            return (T)realFieldElement3;
        }
        return (T)realFieldElement;
    }

    public T distanceInf(Vector3D vector3D) {
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)this.x.subtract(vector3D.getX())).abs();
        RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)this.y.subtract(vector3D.getY())).abs();
        RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)this.z.subtract(vector3D.getZ())).abs();
        if (realFieldElement.getReal() <= realFieldElement2.getReal()) {
            if (realFieldElement2.getReal() <= realFieldElement3.getReal()) {
                return (T)realFieldElement3;
            }
            return (T)realFieldElement2;
        }
        if (realFieldElement.getReal() <= realFieldElement3.getReal()) {
            return (T)realFieldElement3;
        }
        return (T)realFieldElement;
    }

    public T distanceSq(FieldVector3D<T> fieldVector3D) {
        RealFieldElement realFieldElement = (RealFieldElement)fieldVector3D.x.subtract(this.x);
        RealFieldElement realFieldElement2 = (RealFieldElement)fieldVector3D.y.subtract(this.y);
        RealFieldElement realFieldElement3 = (RealFieldElement)fieldVector3D.z.subtract(this.z);
        return (T)realFieldElement.multiply(realFieldElement).add(realFieldElement2.multiply(realFieldElement2)).add(realFieldElement3.multiply(realFieldElement3));
    }

    public T distanceSq(Vector3D vector3D) {
        RealFieldElement realFieldElement = (RealFieldElement)this.x.subtract(vector3D.getX());
        RealFieldElement realFieldElement2 = (RealFieldElement)this.y.subtract(vector3D.getY());
        RealFieldElement realFieldElement3 = (RealFieldElement)this.z.subtract(vector3D.getZ());
        return (T)realFieldElement.multiply(realFieldElement).add(realFieldElement2.multiply(realFieldElement2)).add(realFieldElement3.multiply(realFieldElement3));
    }

    public static <T extends RealFieldElement<T>> T dotProduct(FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2) {
        return fieldVector3D.dotProduct(fieldVector3D2);
    }

    public static <T extends RealFieldElement<T>> T dotProduct(FieldVector3D<T> fieldVector3D, Vector3D vector3D) {
        return fieldVector3D.dotProduct(vector3D);
    }

    public static <T extends RealFieldElement<T>> T dotProduct(Vector3D vector3D, FieldVector3D<T> fieldVector3D) {
        return fieldVector3D.dotProduct(vector3D);
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> crossProduct(FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2) {
        return fieldVector3D.crossProduct(fieldVector3D2);
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> crossProduct(FieldVector3D<T> fieldVector3D, Vector3D vector3D) {
        return fieldVector3D.crossProduct(vector3D);
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> crossProduct(Vector3D vector3D, FieldVector3D<T> fieldVector3D) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)fieldVector3D.x.linearCombination(vector3D.getY(), fieldVector3D.z, -vector3D.getZ(), fieldVector3D.y), (RealFieldElement)fieldVector3D.y.linearCombination(vector3D.getZ(), fieldVector3D.x, -vector3D.getX(), fieldVector3D.z), (RealFieldElement)fieldVector3D.z.linearCombination(vector3D.getX(), fieldVector3D.y, -vector3D.getY(), fieldVector3D.x));
    }

    public static <T extends RealFieldElement<T>> T distance1(FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2) {
        return fieldVector3D.distance1(fieldVector3D2);
    }

    public static <T extends RealFieldElement<T>> T distance1(FieldVector3D<T> fieldVector3D, Vector3D vector3D) {
        return fieldVector3D.distance1(vector3D);
    }

    public static <T extends RealFieldElement<T>> T distance1(Vector3D vector3D, FieldVector3D<T> fieldVector3D) {
        return fieldVector3D.distance1(vector3D);
    }

    public static <T extends RealFieldElement<T>> T distance(FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2) {
        return fieldVector3D.distance(fieldVector3D2);
    }

    public static <T extends RealFieldElement<T>> T distance(FieldVector3D<T> fieldVector3D, Vector3D vector3D) {
        return fieldVector3D.distance(vector3D);
    }

    public static <T extends RealFieldElement<T>> T distance(Vector3D vector3D, FieldVector3D<T> fieldVector3D) {
        return fieldVector3D.distance(vector3D);
    }

    public static <T extends RealFieldElement<T>> T distanceInf(FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2) {
        return fieldVector3D.distanceInf(fieldVector3D2);
    }

    public static <T extends RealFieldElement<T>> T distanceInf(FieldVector3D<T> fieldVector3D, Vector3D vector3D) {
        return fieldVector3D.distanceInf(vector3D);
    }

    public static <T extends RealFieldElement<T>> T distanceInf(Vector3D vector3D, FieldVector3D<T> fieldVector3D) {
        return fieldVector3D.distanceInf(vector3D);
    }

    public static <T extends RealFieldElement<T>> T distanceSq(FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2) {
        return fieldVector3D.distanceSq(fieldVector3D2);
    }

    public static <T extends RealFieldElement<T>> T distanceSq(FieldVector3D<T> fieldVector3D, Vector3D vector3D) {
        return fieldVector3D.distanceSq(vector3D);
    }

    public static <T extends RealFieldElement<T>> T distanceSq(Vector3D vector3D, FieldVector3D<T> fieldVector3D) {
        return fieldVector3D.distanceSq(vector3D);
    }

    public String toString() {
        return Vector3DFormat.getInstance().format(this.toVector3D());
    }

    public String toString(NumberFormat numberFormat) {
        return new Vector3DFormat(numberFormat).format(this.toVector3D());
    }
}

