/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.SubPlane;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math3.geometry.euclidean.twod.SubLine;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.AbstractRegion;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.RegionFactory;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.geometry.partitioning.Transform;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyhedronsSet
extends AbstractRegion<Euclidean3D, Euclidean2D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;

    public PolyhedronsSet(double d) {
        super(d);
    }

    public PolyhedronsSet(BSPTree<Euclidean3D> bSPTree, double d) {
        super(bSPTree, d);
    }

    public PolyhedronsSet(Collection<SubHyperplane<Euclidean3D>> collection, double d) {
        super(collection, d);
    }

    public PolyhedronsSet(List<Vector3D> list, List<int[]> list2, double d) {
        super(PolyhedronsSet.buildBoundary(list, list2, d), d);
    }

    public PolyhedronsSet(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        super(PolyhedronsSet.buildBoundary(d, d2, d3, d4, d5, d6, d7), d7);
    }

    @Deprecated
    public PolyhedronsSet() {
        this(1.0E-10);
    }

    @Deprecated
    public PolyhedronsSet(BSPTree<Euclidean3D> bSPTree) {
        this(bSPTree, 1.0E-10);
    }

    @Deprecated
    public PolyhedronsSet(Collection<SubHyperplane<Euclidean3D>> collection) {
        this(collection, 1.0E-10);
    }

    @Deprecated
    public PolyhedronsSet(double d, double d2, double d3, double d4, double d5, double d6) {
        this(d, d2, d3, d4, d5, d6, 1.0E-10);
    }

    private static BSPTree<Euclidean3D> buildBoundary(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d >= d2 - d7 || d3 >= d4 - d7 || d5 >= d6 - d7) {
            return new BSPTree<Euclidean3D>(Boolean.FALSE);
        }
        Plane plane = new Plane(new Vector3D(d, 0.0, 0.0), Vector3D.MINUS_I, d7);
        Plane plane2 = new Plane(new Vector3D(d2, 0.0, 0.0), Vector3D.PLUS_I, d7);
        Plane plane3 = new Plane(new Vector3D(0.0, d3, 0.0), Vector3D.MINUS_J, d7);
        Plane plane4 = new Plane(new Vector3D(0.0, d4, 0.0), Vector3D.PLUS_J, d7);
        Plane plane5 = new Plane(new Vector3D(0.0, 0.0, d5), Vector3D.MINUS_K, d7);
        Plane plane6 = new Plane(new Vector3D(0.0, 0.0, d6), Vector3D.PLUS_K, d7);
        Region region = new RegionFactory().buildConvex(plane, plane2, plane3, plane4, plane5, plane6);
        return region.getTree(false);
    }

    private static List<SubHyperplane<Euclidean3D>> buildBoundary(List<Vector3D> list, List<int[]> list2, double d) {
        Object object;
        int n;
        int n2;
        Object object2;
        for (int i = 0; i < list.size() - 1; ++i) {
            object2 = list.get(i);
            for (n2 = i + 1; n2 < list.size(); ++n2) {
                if (!(Vector3D.distance((Vector3D)object2, list.get(n2)) <= d)) continue;
                throw new MathIllegalArgumentException(LocalizedFormats.CLOSE_VERTICES, ((Vector3D)object2).getX(), ((Vector3D)object2).getY(), ((Vector3D)object2).getZ());
            }
        }
        int[][] nArray = PolyhedronsSet.findReferences(list, list2);
        object2 = PolyhedronsSet.successors(list, list2, nArray);
        for (n2 = 0; n2 < list.size(); ++n2) {
            for (Iterator<int[]> iterator : object2[n2]) {
                if (iterator < 0) continue;
                n = 0;
                for (Object object3 : object2[iterator]) {
                    n = n != 0 || object3 == n2 ? 1 : 0;
                }
                if (n != 0) continue;
                object = list.get(n2);
                Vector3D vector3D = list.get((int)iterator);
                throw new MathIllegalArgumentException(LocalizedFormats.EDGE_CONNECTED_TO_ONE_FACET, ((Vector3D)object).getX(), ((Vector3D)object).getY(), ((Vector3D)object).getZ(), vector3D.getX(), vector3D.getY(), vector3D.getZ());
            }
        }
        ArrayList<SubHyperplane<Euclidean3D>> arrayList = new ArrayList<SubHyperplane<Euclidean3D>>();
        for (int[] nArray2 : list2) {
            Plane plane = new Plane(list.get(nArray2[0]), list.get(nArray2[1]), list.get(nArray2[2]), d);
            Vector2D[] vector2DArray = new Vector2D[nArray2.length];
            for (n = 0; n < nArray2.length; ++n) {
                object = list.get(nArray2[n]);
                if (!plane.contains((Vector3D)object)) {
                    throw new MathIllegalArgumentException(LocalizedFormats.OUT_OF_PLANE, ((Vector3D)object).getX(), ((Vector3D)object).getY(), ((Vector3D)object).getZ());
                }
                vector2DArray[n] = plane.toSubSpace((Vector<Euclidean3D>)object);
            }
            arrayList.add(new SubPlane(plane, new PolygonsSet(d, vector2DArray)));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private static int[][] findReferences(List<Vector3D> list, List<int[]> list2) {
        void var5_8;
        int[] nArray = new int[list.size()];
        int n = 0;
        Object object = list2.iterator();
        while (object.hasNext()) {
            int[] object2 = object.next();
            if (object2.length < 3) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.WRONG_NUMBER_OF_POINTS, (Number)3, object2.length, true);
            }
            int[] nArray2 = object2;
            int n2 = nArray2.length;
            for (int n6 = 0; n6 < n2; ++n6) {
                int n3;
                int n4 = n3 = nArray2[n6];
                int n5 = nArray[n4] + 1;
                nArray[n4] = n5;
                n = FastMath.max(n, n5);
            }
        }
        for (Object object3 : object = (Object)new int[list.size()][n]) {
            Arrays.fill((int[])object3, -1);
        }
        boolean bl = false;
        while (var5_8 < list2.size()) {
            for (int n3 : list2.get((int)var5_8)) {
                for (int i = 0; i < n && object[n3][i] >= 0; ++i) {
                }
                object[n3][i] = var5_8;
            }
            ++var5_8;
        }
        return object;
    }

    private static int[][] successors(List<Vector3D> list, List<int[]> list2, int[][] nArray) {
        int[][] nArray2;
        int[][] nArray3 = nArray2 = new int[list.size()][nArray[0].length];
        int n = nArray3.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray4 = nArray3[i];
            Arrays.fill(nArray4, -1);
        }
        for (int i = 0; i < list.size(); ++i) {
            for (n = 0; n < nArray2[i].length && nArray[i][n] >= 0; ++n) {
                int n2;
                int[] nArray5 = list2.get(nArray[i][n]);
                for (n2 = 0; n2 < nArray5.length && nArray5[n2] != i; ++n2) {
                }
                nArray2[i][n] = nArray5[(n2 + 1) % nArray5.length];
                for (int j = 0; j < n; ++j) {
                    if (nArray2[i][j] != nArray2[i][n]) continue;
                    Vector3D vector3D = list.get(i);
                    Vector3D vector3D2 = list.get(nArray2[i][n]);
                    throw new MathIllegalArgumentException(LocalizedFormats.FACET_ORIENTATION_MISMATCH, vector3D.getX(), vector3D.getY(), vector3D.getZ(), vector3D2.getX(), vector3D2.getY(), vector3D2.getZ());
                }
            }
        }
        return nArray2;
    }

    public PolyhedronsSet buildNew(BSPTree<Euclidean3D> bSPTree) {
        return new PolyhedronsSet(bSPTree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        this.getTree(true).visit(new FacetsContributionVisitor());
        if (this.getSize() < 0.0) {
            this.setSize(Double.POSITIVE_INFINITY);
            this.setBarycenter(Vector3D.NaN);
        } else {
            this.setSize(this.getSize() / 3.0);
            this.setBarycenter(new Vector3D(1.0 / (4.0 * this.getSize()), (Vector3D)this.getBarycenter()));
        }
    }

    public SubHyperplane<Euclidean3D> firstIntersection(Vector3D vector3D, Line line) {
        return this.recurseFirstIntersection(this.getTree(true), vector3D, line);
    }

    private SubHyperplane<Euclidean3D> recurseFirstIntersection(BSPTree<Euclidean3D> bSPTree, Vector3D vector3D, Line line) {
        SubHyperplane<Euclidean3D> subHyperplane;
        Vector3D vector3D2;
        SubHyperplane<Euclidean3D> subHyperplane2;
        BSPTree<Euclidean3D> bSPTree2;
        BSPTree<Euclidean3D> bSPTree3;
        boolean bl;
        SubHyperplane<Euclidean3D> subHyperplane3 = bSPTree.getCut();
        if (subHyperplane3 == null) {
            return null;
        }
        BSPTree<Euclidean3D> bSPTree4 = bSPTree.getMinus();
        BSPTree<Euclidean3D> bSPTree5 = bSPTree.getPlus();
        Plane plane = (Plane)subHyperplane3.getHyperplane();
        double d = plane.getOffset(vector3D);
        boolean bl2 = bl = FastMath.abs(d) < this.getTolerance();
        if (d < 0.0) {
            bSPTree3 = bSPTree4;
            bSPTree2 = bSPTree5;
        } else {
            bSPTree3 = bSPTree5;
            bSPTree2 = bSPTree4;
        }
        if (bl && (subHyperplane2 = this.boundaryFacet(vector3D, bSPTree)) != null) {
            return subHyperplane2;
        }
        subHyperplane2 = this.recurseFirstIntersection(bSPTree3, vector3D, line);
        if (subHyperplane2 != null) {
            return subHyperplane2;
        }
        if (!bl && (vector3D2 = plane.intersection(line)) != null && line.getAbscissa(vector3D2) > line.getAbscissa(vector3D) && (subHyperplane = this.boundaryFacet(vector3D2, bSPTree)) != null) {
            return subHyperplane;
        }
        return this.recurseFirstIntersection(bSPTree2, vector3D, line);
    }

    private SubHyperplane<Euclidean3D> boundaryFacet(Vector3D vector3D, BSPTree<Euclidean3D> bSPTree) {
        Point point = ((Plane)bSPTree.getCut().getHyperplane()).toSubSpace((Point)vector3D);
        BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
        if (boundaryAttribute.getPlusOutside() != null && ((SubPlane)boundaryAttribute.getPlusOutside()).getRemainingRegion().checkPoint(point) == Region.Location.INSIDE) {
            return boundaryAttribute.getPlusOutside();
        }
        if (boundaryAttribute.getPlusInside() != null && ((SubPlane)boundaryAttribute.getPlusInside()).getRemainingRegion().checkPoint(point) == Region.Location.INSIDE) {
            return boundaryAttribute.getPlusInside();
        }
        return null;
    }

    public PolyhedronsSet rotate(Vector3D vector3D, Rotation rotation) {
        return (PolyhedronsSet)this.applyTransform(new RotationTransform(vector3D, rotation));
    }

    public PolyhedronsSet translate(Vector3D vector3D) {
        return (PolyhedronsSet)this.applyTransform(new TranslationTransform(vector3D));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TranslationTransform
    implements Transform<Euclidean3D, Euclidean2D> {
        private Vector3D translation;
        private Plane cachedOriginal;
        private Transform<Euclidean2D, Euclidean1D> cachedTransform;

        TranslationTransform(Vector3D vector3D) {
            this.translation = vector3D;
        }

        public Vector3D apply(Point<Euclidean3D> point) {
            return new Vector3D(1.0, (Vector3D)point, 1.0, this.translation);
        }

        public Plane apply(Hyperplane<Euclidean3D> hyperplane) {
            return ((Plane)hyperplane).translate(this.translation);
        }

        @Override
        public SubHyperplane<Euclidean2D> apply(SubHyperplane<Euclidean2D> subHyperplane, Hyperplane<Euclidean3D> hyperplane, Hyperplane<Euclidean3D> hyperplane2) {
            if (hyperplane != this.cachedOriginal) {
                Plane plane = (Plane)hyperplane;
                Plane plane2 = (Plane)hyperplane2;
                Point point = plane2.toSubSpace(this.apply((Point)plane.getOrigin()));
                this.cachedOriginal = (Plane)hyperplane;
                this.cachedTransform = org.apache.commons.math3.geometry.euclidean.twod.Line.getTransform(1.0, 0.0, 0.0, 1.0, ((Vector2D)point).getX(), ((Vector2D)point).getY());
            }
            return ((SubLine)subHyperplane).applyTransform(this.cachedTransform);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RotationTransform
    implements Transform<Euclidean3D, Euclidean2D> {
        private Vector3D center;
        private Rotation rotation;
        private Plane cachedOriginal;
        private Transform<Euclidean2D, Euclidean1D> cachedTransform;

        RotationTransform(Vector3D vector3D, Rotation rotation) {
            this.center = vector3D;
            this.rotation = rotation;
        }

        public Vector3D apply(Point<Euclidean3D> point) {
            Vector vector = ((Vector3D)point).subtract((Vector)this.center);
            return new Vector3D(1.0, this.center, 1.0, this.rotation.applyTo((Vector3D)vector));
        }

        public Plane apply(Hyperplane<Euclidean3D> hyperplane) {
            return ((Plane)hyperplane).rotate(this.center, this.rotation);
        }

        @Override
        public SubHyperplane<Euclidean2D> apply(SubHyperplane<Euclidean2D> subHyperplane, Hyperplane<Euclidean3D> hyperplane, Hyperplane<Euclidean3D> hyperplane2) {
            if (hyperplane != this.cachedOriginal) {
                Plane plane = (Plane)hyperplane;
                Plane plane2 = (Plane)hyperplane2;
                Vector3D vector3D = plane.getOrigin();
                Point point = plane.toSpace((Point)new Vector2D(1.0, 0.0));
                Point point2 = plane.toSpace((Point)new Vector2D(0.0, 1.0));
                Point point3 = plane2.toSubSpace(this.apply((Point)vector3D));
                Point point4 = plane2.toSubSpace(this.apply(point));
                Point point5 = plane2.toSubSpace(this.apply(point2));
                this.cachedOriginal = (Plane)hyperplane;
                this.cachedTransform = org.apache.commons.math3.geometry.euclidean.twod.Line.getTransform(((Vector2D)point4).getX() - ((Vector2D)point3).getX(), ((Vector2D)point4).getY() - ((Vector2D)point3).getY(), ((Vector2D)point5).getX() - ((Vector2D)point3).getX(), ((Vector2D)point5).getY() - ((Vector2D)point3).getY(), ((Vector2D)point3).getX(), ((Vector2D)point3).getY());
            }
            return ((SubLine)subHyperplane).applyTransform(this.cachedTransform);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FacetsContributionVisitor
    implements BSPTreeVisitor<Euclidean3D> {
        FacetsContributionVisitor() {
            PolyhedronsSet.this.setSize(0.0);
            PolyhedronsSet.this.setBarycenter(new Vector3D(0.0, 0.0, 0.0));
        }

        @Override
        public BSPTreeVisitor.Order visitOrder(BSPTree<Euclidean3D> bSPTree) {
            return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
        }

        @Override
        public void visitInternalNode(BSPTree<Euclidean3D> bSPTree) {
            BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
            if (boundaryAttribute.getPlusOutside() != null) {
                this.addContribution(boundaryAttribute.getPlusOutside(), false);
            }
            if (boundaryAttribute.getPlusInside() != null) {
                this.addContribution(boundaryAttribute.getPlusInside(), true);
            }
        }

        @Override
        public void visitLeafNode(BSPTree<Euclidean3D> bSPTree) {
        }

        private void addContribution(SubHyperplane<Euclidean3D> subHyperplane, boolean bl) {
            Region region = ((SubPlane)subHyperplane).getRemainingRegion();
            double d = region.getSize();
            if (Double.isInfinite(d)) {
                PolyhedronsSet.this.setSize(Double.POSITIVE_INFINITY);
                PolyhedronsSet.this.setBarycenter(Vector3D.NaN);
            } else {
                Plane plane = (Plane)subHyperplane.getHyperplane();
                Point point = plane.toSpace(region.getBarycenter());
                double d2 = d * ((Vector3D)point).dotProduct(plane.getNormal());
                if (bl) {
                    d2 = -d2;
                }
                PolyhedronsSet.this.setSize(PolyhedronsSet.this.getSize() + d2);
                PolyhedronsSet.this.setBarycenter(new Vector3D(1.0, (Vector3D)PolyhedronsSet.this.getBarycenter(), d2, (Vector3D)point));
            }
        }
    }
}

