/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.enclosing.EnclosingBall;
import org.apache.commons.math3.geometry.enclosing.SupportBallGenerator;
import org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.twod.DiskGenerator;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SphereGenerator
implements SupportBallGenerator<Euclidean3D, Vector3D> {
    @Override
    public EnclosingBall<Euclidean3D, Vector3D> ballOnSupport(List<Vector3D> list) {
        if (list.size() < 1) {
            return new EnclosingBall((Point)Vector3D.ZERO, Double.NEGATIVE_INFINITY, (Point[])new Vector3D[0]);
        }
        Vector3D vector3D = list.get(0);
        if (list.size() < 2) {
            return new EnclosingBall((Point)vector3D, 0.0, (Point[])new Vector3D[]{vector3D});
        }
        Vector3D vector3D2 = list.get(1);
        if (list.size() < 3) {
            return new EnclosingBall((Point)new Vector3D(0.5, vector3D, 0.5, vector3D2), 0.5 * vector3D.distance(vector3D2), (Point[])new Vector3D[]{vector3D, vector3D2});
        }
        Vector3D vector3D3 = list.get(2);
        if (list.size() < 4) {
            Plane plane = new Plane(vector3D, vector3D2, vector3D3, 1.0E-10 * (vector3D.getNorm1() + vector3D2.getNorm1() + vector3D3.getNorm1()));
            EnclosingBall<Euclidean2D, Vector2D> enclosingBall = new DiskGenerator().ballOnSupport(Arrays.asList(plane.toSubSpace(vector3D), plane.toSubSpace(vector3D2), plane.toSubSpace(vector3D3)));
            return new EnclosingBall((Point)plane.toSpace(enclosingBall.getCenter()), enclosingBall.getRadius(), (Point[])new Vector3D[]{vector3D, vector3D2, vector3D3});
        }
        Vector3D vector3D4 = list.get(3);
        BigFraction[] bigFractionArray = new BigFraction[]{new BigFraction(vector3D.getX()), new BigFraction(vector3D2.getX()), new BigFraction(vector3D3.getX()), new BigFraction(vector3D4.getX())};
        BigFraction[] bigFractionArray2 = new BigFraction[]{new BigFraction(vector3D.getY()), new BigFraction(vector3D2.getY()), new BigFraction(vector3D3.getY()), new BigFraction(vector3D4.getY())};
        BigFraction[] bigFractionArray3 = new BigFraction[]{new BigFraction(vector3D.getZ()), new BigFraction(vector3D2.getZ()), new BigFraction(vector3D3.getZ()), new BigFraction(vector3D4.getZ())};
        BigFraction[] bigFractionArray4 = new BigFraction[]{bigFractionArray[0].multiply(bigFractionArray[0]).add(bigFractionArray2[0].multiply(bigFractionArray2[0])).add(bigFractionArray3[0].multiply(bigFractionArray3[0])), bigFractionArray[1].multiply(bigFractionArray[1]).add(bigFractionArray2[1].multiply(bigFractionArray2[1])).add(bigFractionArray3[1].multiply(bigFractionArray3[1])), bigFractionArray[2].multiply(bigFractionArray[2]).add(bigFractionArray2[2].multiply(bigFractionArray2[2])).add(bigFractionArray3[2].multiply(bigFractionArray3[2])), bigFractionArray[3].multiply(bigFractionArray[3]).add(bigFractionArray2[3].multiply(bigFractionArray2[3])).add(bigFractionArray3[3].multiply(bigFractionArray3[3]))};
        BigFraction bigFraction = this.minor(bigFractionArray, bigFractionArray2, bigFractionArray3).multiply(2);
        BigFraction bigFraction2 = this.minor(bigFractionArray4, bigFractionArray2, bigFractionArray3);
        BigFraction bigFraction3 = this.minor(bigFractionArray4, bigFractionArray, bigFractionArray3);
        BigFraction bigFraction4 = this.minor(bigFractionArray4, bigFractionArray, bigFractionArray2);
        BigFraction bigFraction5 = bigFraction2.divide(bigFraction);
        BigFraction bigFraction6 = bigFraction3.divide(bigFraction).negate();
        BigFraction bigFraction7 = bigFraction4.divide(bigFraction);
        BigFraction bigFraction8 = bigFractionArray[0].subtract(bigFraction5);
        BigFraction bigFraction9 = bigFractionArray2[0].subtract(bigFraction6);
        BigFraction bigFraction10 = bigFractionArray3[0].subtract(bigFraction7);
        BigFraction bigFraction11 = bigFraction8.multiply(bigFraction8).add(bigFraction9.multiply(bigFraction9)).add(bigFraction10.multiply(bigFraction10));
        return new EnclosingBall((Point)new Vector3D(bigFraction5.doubleValue(), bigFraction6.doubleValue(), bigFraction7.doubleValue()), FastMath.sqrt(bigFraction11.doubleValue()), (Point[])new Vector3D[]{vector3D, vector3D2, vector3D3, vector3D4});
    }

    private BigFraction minor(BigFraction[] bigFractionArray, BigFraction[] bigFractionArray2, BigFraction[] bigFractionArray3) {
        return bigFractionArray2[0].multiply(bigFractionArray3[1]).multiply(bigFractionArray[2].subtract(bigFractionArray[3])).add(bigFractionArray2[0].multiply(bigFractionArray3[2]).multiply(bigFractionArray[3].subtract(bigFractionArray[1]))).add(bigFractionArray2[0].multiply(bigFractionArray3[3]).multiply(bigFractionArray[1].subtract(bigFractionArray[2]))).add(bigFractionArray2[1].multiply(bigFractionArray3[0]).multiply(bigFractionArray[3].subtract(bigFractionArray[2]))).add(bigFractionArray2[1].multiply(bigFractionArray3[2]).multiply(bigFractionArray[0].subtract(bigFractionArray[3]))).add(bigFractionArray2[1].multiply(bigFractionArray3[3]).multiply(bigFractionArray[2].subtract(bigFractionArray[0]))).add(bigFractionArray2[2].multiply(bigFractionArray3[0]).multiply(bigFractionArray[1].subtract(bigFractionArray[3]))).add(bigFractionArray2[2].multiply(bigFractionArray3[1]).multiply(bigFractionArray[3].subtract(bigFractionArray[0]))).add(bigFractionArray2[2].multiply(bigFractionArray3[3]).multiply(bigFractionArray[0].subtract(bigFractionArray[1]))).add(bigFractionArray2[3].multiply(bigFractionArray3[0]).multiply(bigFractionArray[2].subtract(bigFractionArray[1]))).add(bigFractionArray2[3].multiply(bigFractionArray3[1]).multiply(bigFractionArray[0].subtract(bigFractionArray[2]))).add(bigFractionArray2[3].multiply(bigFractionArray3[2]).multiply(bigFractionArray[1].subtract(bigFractionArray[0])));
    }
}

