/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Segment;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.partitioning.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubLine {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private final Line line;
    private final IntervalsSet remainingRegion;

    public SubLine(Line line, IntervalsSet intervalsSet) {
        this.line = line;
        this.remainingRegion = intervalsSet;
    }

    public SubLine(Vector3D vector3D, Vector3D vector3D2, double d) {
        this(new Line(vector3D, vector3D2, d), SubLine.buildIntervalSet(vector3D, vector3D2, d));
    }

    public SubLine(Vector3D vector3D, Vector3D vector3D2) {
        this(vector3D, vector3D2, 1.0E-10);
    }

    public SubLine(Segment segment) {
        this(segment.getLine(), SubLine.buildIntervalSet(segment.getStart(), segment.getEnd(), segment.getLine().getTolerance()));
    }

    public List<Segment> getSegments() {
        List<Interval> list = this.remainingRegion.asList();
        ArrayList<Segment> arrayList = new ArrayList<Segment>(list.size());
        for (Interval interval : list) {
            Point point = this.line.toSpace((Point)new Vector1D(interval.getInf()));
            Point point2 = this.line.toSpace((Point)new Vector1D(interval.getSup()));
            arrayList.add(new Segment((Vector3D)point, (Vector3D)point2, this.line));
        }
        return arrayList;
    }

    public Vector3D intersection(SubLine subLine, boolean bl) {
        Vector3D vector3D = this.line.intersection(subLine.line);
        if (vector3D == null) {
            return null;
        }
        Region.Location location = this.remainingRegion.checkPoint(this.line.toSubSpace((Point)vector3D));
        Region.Location location2 = subLine.remainingRegion.checkPoint(subLine.line.toSubSpace((Point)vector3D));
        if (bl) {
            return location != Region.Location.OUTSIDE && location2 != Region.Location.OUTSIDE ? vector3D : null;
        }
        return location == Region.Location.INSIDE && location2 == Region.Location.INSIDE ? vector3D : null;
    }

    private static IntervalsSet buildIntervalSet(Vector3D vector3D, Vector3D vector3D2, double d) {
        Line line = new Line(vector3D, vector3D2, d);
        return new IntervalsSet(((Vector1D)line.toSubSpace((Point)vector3D)).getX(), ((Vector1D)line.toSubSpace((Point)vector3D2)).getX(), d);
    }
}

