/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math3.geometry.euclidean.twod.SubLine;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubPlane
extends AbstractSubHyperplane<Euclidean3D, Euclidean2D> {
    public SubPlane(Hyperplane<Euclidean3D> hyperplane, Region<Euclidean2D> region) {
        super(hyperplane, region);
    }

    @Override
    protected AbstractSubHyperplane<Euclidean3D, Euclidean2D> buildNew(Hyperplane<Euclidean3D> hyperplane, Region<Euclidean2D> region) {
        return new SubPlane(hyperplane, region);
    }

    @Override
    public SubHyperplane.SplitSubHyperplane<Euclidean3D> split(Hyperplane<Euclidean3D> hyperplane) {
        Object object;
        Plane plane = (Plane)hyperplane;
        Plane plane2 = (Plane)this.getHyperplane();
        Line line = plane.intersection(plane2);
        double d = plane2.getTolerance();
        if (line == null) {
            double d2 = plane.getOffset(plane2);
            if (d2 < -d) {
                return new SubHyperplane.SplitSubHyperplane<Euclidean3D>(null, this);
            }
            if (d2 > d) {
                return new SubHyperplane.SplitSubHyperplane<Euclidean3D>(this, null);
            }
            return new SubHyperplane.SplitSubHyperplane<Euclidean3D>(null, null);
        }
        Point point = plane2.toSubSpace(line.toSpace((Point)Vector1D.ZERO));
        Point point2 = plane2.toSubSpace(line.toSpace((Point)Vector1D.ONE));
        Vector3D vector3D = Vector3D.crossProduct(line.getDirection(), plane2.getNormal());
        if (vector3D.dotProduct(plane.getNormal()) < 0.0) {
            object = point;
            point = point2;
            point2 = object;
        }
        object = new org.apache.commons.math3.geometry.euclidean.twod.Line((Vector2D)point, (Vector2D)point2, d).wholeHyperplane();
        SubLine subLine = new org.apache.commons.math3.geometry.euclidean.twod.Line((Vector2D)point2, (Vector2D)point, d).wholeHyperplane();
        BSPTree bSPTree = this.getRemainingRegion().getTree(false).split(object);
        BSPTree<Euclidean2D> bSPTree2 = this.getRemainingRegion().isEmpty(bSPTree.getPlus()) ? new BSPTree<Euclidean2D>(Boolean.FALSE) : new BSPTree<Euclidean2D>(subLine, new BSPTree(Boolean.FALSE), bSPTree.getPlus(), null);
        BSPTree<Euclidean2D> bSPTree3 = this.getRemainingRegion().isEmpty(bSPTree.getMinus()) ? new BSPTree<Euclidean2D>(Boolean.FALSE) : new BSPTree(object, new BSPTree(Boolean.FALSE), bSPTree.getMinus(), null);
        return new SubHyperplane.SplitSubHyperplane<Euclidean3D>(new SubPlane(plane2.copySelf(), new PolygonsSet(bSPTree2, d)), new SubPlane(plane2.copySelf(), new PolygonsSet(bSPTree3, d)));
    }
}

