/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod;

import java.util.List;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.enclosing.EnclosingBall;
import org.apache.commons.math3.geometry.enclosing.SupportBallGenerator;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskGenerator
implements SupportBallGenerator<Euclidean2D, Vector2D> {
    @Override
    public EnclosingBall<Euclidean2D, Vector2D> ballOnSupport(List<Vector2D> list) {
        if (list.size() < 1) {
            return new EnclosingBall((Point)Vector2D.ZERO, Double.NEGATIVE_INFINITY, (Point[])new Vector2D[0]);
        }
        Vector2D vector2D = list.get(0);
        if (list.size() < 2) {
            return new EnclosingBall((Point)vector2D, 0.0, (Point[])new Vector2D[]{vector2D});
        }
        Vector2D vector2D2 = list.get(1);
        if (list.size() < 3) {
            return new EnclosingBall((Point)new Vector2D(0.5, vector2D, 0.5, vector2D2), 0.5 * vector2D.distance(vector2D2), (Point[])new Vector2D[]{vector2D, vector2D2});
        }
        Vector2D vector2D3 = list.get(2);
        BigFraction[] bigFractionArray = new BigFraction[]{new BigFraction(vector2D.getX()), new BigFraction(vector2D2.getX()), new BigFraction(vector2D3.getX())};
        BigFraction[] bigFractionArray2 = new BigFraction[]{new BigFraction(vector2D.getY()), new BigFraction(vector2D2.getY()), new BigFraction(vector2D3.getY())};
        BigFraction[] bigFractionArray3 = new BigFraction[]{bigFractionArray[0].multiply(bigFractionArray[0]).add(bigFractionArray2[0].multiply(bigFractionArray2[0])), bigFractionArray[1].multiply(bigFractionArray[1]).add(bigFractionArray2[1].multiply(bigFractionArray2[1])), bigFractionArray[2].multiply(bigFractionArray[2]).add(bigFractionArray2[2].multiply(bigFractionArray2[2]))};
        BigFraction bigFraction = this.minor(bigFractionArray, bigFractionArray2).multiply(2);
        BigFraction bigFraction2 = this.minor(bigFractionArray3, bigFractionArray2);
        BigFraction bigFraction3 = this.minor(bigFractionArray3, bigFractionArray);
        BigFraction bigFraction4 = bigFraction2.divide(bigFraction);
        BigFraction bigFraction5 = bigFraction3.divide(bigFraction).negate();
        BigFraction bigFraction6 = bigFractionArray[0].subtract(bigFraction4);
        BigFraction bigFraction7 = bigFractionArray2[0].subtract(bigFraction5);
        BigFraction bigFraction8 = bigFraction6.multiply(bigFraction6).add(bigFraction7.multiply(bigFraction7));
        return new EnclosingBall((Point)new Vector2D(bigFraction4.doubleValue(), bigFraction5.doubleValue()), FastMath.sqrt(bigFraction8.doubleValue()), (Point[])new Vector2D[]{vector2D, vector2D2, vector2D3});
    }

    private BigFraction minor(BigFraction[] bigFractionArray, BigFraction[] bigFractionArray2) {
        return bigFractionArray2[0].multiply(bigFractionArray[2].subtract(bigFractionArray[1])).add(bigFractionArray2[1].multiply(bigFractionArray[0].subtract(bigFractionArray[2]))).add(bigFractionArray2[2].multiply(bigFractionArray[1].subtract(bigFractionArray[0])));
    }
}

