/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod;

import java.awt.geom.AffineTransform;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import org.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import org.apache.commons.math3.geometry.euclidean.oned.OrientedPoint;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math3.geometry.euclidean.twod.SubLine;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.Embedding;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.geometry.partitioning.Transform;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line
implements Hyperplane<Euclidean2D>,
Embedding<Euclidean2D, Euclidean1D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private double angle;
    private double cos;
    private double sin;
    private double originOffset;
    private final double tolerance;
    private Line reverse;

    public Line(Vector2D vector2D, Vector2D vector2D2, double d) {
        this.reset(vector2D, vector2D2);
        this.tolerance = d;
    }

    public Line(Vector2D vector2D, double d, double d2) {
        this.reset(vector2D, d);
        this.tolerance = d2;
    }

    private Line(double d, double d2, double d3, double d4, double d5) {
        this.angle = d;
        this.cos = d2;
        this.sin = d3;
        this.originOffset = d4;
        this.tolerance = d5;
        this.reverse = null;
    }

    @Deprecated
    public Line(Vector2D vector2D, Vector2D vector2D2) {
        this(vector2D, vector2D2, 1.0E-10);
    }

    @Deprecated
    public Line(Vector2D vector2D, double d) {
        this(vector2D, d, 1.0E-10);
    }

    public Line(Line line) {
        this.angle = MathUtils.normalizeAngle(line.angle, Math.PI);
        this.cos = line.cos;
        this.sin = line.sin;
        this.originOffset = line.originOffset;
        this.tolerance = line.tolerance;
        this.reverse = null;
    }

    public Line copySelf() {
        return new Line(this);
    }

    public void reset(Vector2D vector2D, Vector2D vector2D2) {
        this.unlinkReverse();
        double d = vector2D2.getX() - vector2D.getX();
        double d2 = vector2D2.getY() - vector2D.getY();
        double d3 = FastMath.hypot(d, d2);
        if (d3 == 0.0) {
            this.angle = 0.0;
            this.cos = 1.0;
            this.sin = 0.0;
            this.originOffset = vector2D.getY();
        } else {
            this.angle = Math.PI + FastMath.atan2(-d2, -d);
            this.cos = d / d3;
            this.sin = d2 / d3;
            this.originOffset = MathArrays.linearCombination(vector2D2.getX(), vector2D.getY(), -vector2D.getX(), vector2D2.getY()) / d3;
        }
    }

    public void reset(Vector2D vector2D, double d) {
        this.unlinkReverse();
        this.angle = MathUtils.normalizeAngle(d, Math.PI);
        this.cos = FastMath.cos(this.angle);
        this.sin = FastMath.sin(this.angle);
        this.originOffset = MathArrays.linearCombination(this.cos, vector2D.getY(), -this.sin, vector2D.getX());
    }

    public void revertSelf() {
        this.unlinkReverse();
        this.angle = this.angle < Math.PI ? (this.angle += Math.PI) : (this.angle -= Math.PI);
        this.cos = -this.cos;
        this.sin = -this.sin;
        this.originOffset = -this.originOffset;
    }

    private void unlinkReverse() {
        if (this.reverse != null) {
            this.reverse.reverse = null;
        }
        this.reverse = null;
    }

    public Line getReverse() {
        if (this.reverse == null) {
            this.reverse = new Line(this.angle < Math.PI ? this.angle + Math.PI : this.angle - Math.PI, -this.cos, -this.sin, -this.originOffset, this.tolerance);
            this.reverse.reverse = this;
        }
        return this.reverse;
    }

    public Vector1D toSubSpace(Vector<Euclidean2D> vector) {
        return this.toSubSpace((Point)vector);
    }

    public Vector2D toSpace(Vector<Euclidean1D> vector) {
        return this.toSpace((Point)vector);
    }

    public Vector1D toSubSpace(Point<Euclidean2D> point) {
        Vector2D vector2D = (Vector2D)point;
        return new Vector1D(MathArrays.linearCombination(this.cos, vector2D.getX(), this.sin, vector2D.getY()));
    }

    public Vector2D toSpace(Point<Euclidean1D> point) {
        double d = ((Vector1D)point).getX();
        return new Vector2D(MathArrays.linearCombination(d, this.cos, -this.originOffset, this.sin), MathArrays.linearCombination(d, this.sin, this.originOffset, this.cos));
    }

    public Vector2D intersection(Line line) {
        double d = MathArrays.linearCombination(this.sin, line.cos, -line.sin, this.cos);
        if (FastMath.abs(d) < this.tolerance) {
            return null;
        }
        return new Vector2D(MathArrays.linearCombination(this.cos, line.originOffset, -line.cos, this.originOffset) / d, MathArrays.linearCombination(this.sin, line.originOffset, -line.sin, this.originOffset) / d);
    }

    @Override
    public Point<Euclidean2D> project(Point<Euclidean2D> point) {
        return this.toSpace((Vector<Euclidean1D>)this.toSubSpace((Point)point));
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public SubLine wholeHyperplane() {
        return new SubLine(this, new IntervalsSet(this.tolerance));
    }

    public PolygonsSet wholeSpace() {
        return new PolygonsSet(this.tolerance);
    }

    public double getOffset(Line line) {
        return this.originOffset + (MathArrays.linearCombination(this.cos, line.cos, this.sin, line.sin) > 0.0 ? -line.originOffset : line.originOffset);
    }

    @Override
    public double getOffset(Vector<Euclidean2D> vector) {
        return this.getOffset((Point<Euclidean2D>)vector);
    }

    @Override
    public double getOffset(Point<Euclidean2D> point) {
        Vector2D vector2D = (Vector2D)point;
        return MathArrays.linearCombination(this.sin, vector2D.getX(), -this.cos, vector2D.getY(), 1.0, this.originOffset);
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Euclidean2D> hyperplane) {
        Line line = (Line)hyperplane;
        return MathArrays.linearCombination(this.sin, line.sin, this.cos, line.cos) >= 0.0;
    }

    public Vector2D getPointAt(Vector1D vector1D, double d) {
        double d2 = vector1D.getX();
        double d3 = d - this.originOffset;
        return new Vector2D(MathArrays.linearCombination(d2, this.cos, d3, this.sin), MathArrays.linearCombination(d2, this.sin, -d3, this.cos));
    }

    public boolean contains(Vector2D vector2D) {
        return FastMath.abs(this.getOffset(vector2D)) < this.tolerance;
    }

    public double distance(Vector2D vector2D) {
        return FastMath.abs(this.getOffset(vector2D));
    }

    public boolean isParallelTo(Line line) {
        return FastMath.abs(MathArrays.linearCombination(this.sin, line.cos, -this.cos, line.sin)) < this.tolerance;
    }

    public void translateToPoint(Vector2D vector2D) {
        this.originOffset = MathArrays.linearCombination(this.cos, vector2D.getY(), -this.sin, vector2D.getX());
    }

    public double getAngle() {
        return MathUtils.normalizeAngle(this.angle, Math.PI);
    }

    public void setAngle(double d) {
        this.unlinkReverse();
        this.angle = MathUtils.normalizeAngle(d, Math.PI);
        this.cos = FastMath.cos(this.angle);
        this.sin = FastMath.sin(this.angle);
    }

    public double getOriginOffset() {
        return this.originOffset;
    }

    public void setOriginOffset(double d) {
        this.unlinkReverse();
        this.originOffset = d;
    }

    @Deprecated
    public static Transform<Euclidean2D, Euclidean1D> getTransform(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        return new LineTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    public static Transform<Euclidean2D, Euclidean1D> getTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        return new LineTransform(d, d2, d3, d4, d5, d6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LineTransform
    implements Transform<Euclidean2D, Euclidean1D> {
        private double cXX;
        private double cYX;
        private double cXY;
        private double cYY;
        private double cX1;
        private double cY1;
        private double c1Y;
        private double c1X;
        private double c11;

        LineTransform(double d, double d2, double d3, double d4, double d5, double d6) {
            this.cXX = d;
            this.cYX = d2;
            this.cXY = d3;
            this.cYY = d4;
            this.cX1 = d5;
            this.cY1 = d6;
            this.c1Y = MathArrays.linearCombination(d3, d6, -d4, d5);
            this.c1X = MathArrays.linearCombination(d, d6, -d2, d5);
            this.c11 = MathArrays.linearCombination(d, d4, -d2, d3);
            if (FastMath.abs(this.c11) < 1.0E-20) {
                throw new MathIllegalArgumentException(LocalizedFormats.NON_INVERTIBLE_TRANSFORM, new Object[0]);
            }
        }

        public Vector2D apply(Point<Euclidean2D> point) {
            Vector2D vector2D = (Vector2D)point;
            double d = vector2D.getX();
            double d2 = vector2D.getY();
            return new Vector2D(MathArrays.linearCombination(this.cXX, d, this.cXY, d2, this.cX1, 1.0), MathArrays.linearCombination(this.cYX, d, this.cYY, d2, this.cY1, 1.0));
        }

        public Line apply(Hyperplane<Euclidean2D> hyperplane) {
            Line line = (Line)hyperplane;
            double d = MathArrays.linearCombination(this.c1X, line.cos, this.c1Y, line.sin, this.c11, line.originOffset);
            double d2 = MathArrays.linearCombination(this.cXX, line.cos, this.cXY, line.sin);
            double d3 = MathArrays.linearCombination(this.cYX, line.cos, this.cYY, line.sin);
            double d4 = 1.0 / FastMath.sqrt(d3 * d3 + d2 * d2);
            return new Line(Math.PI + FastMath.atan2(-d3, -d2), d4 * d2, d4 * d3, d4 * d, line.tolerance);
        }

        @Override
        public SubHyperplane<Euclidean1D> apply(SubHyperplane<Euclidean1D> subHyperplane, Hyperplane<Euclidean2D> hyperplane, Hyperplane<Euclidean2D> hyperplane2) {
            OrientedPoint orientedPoint = (OrientedPoint)subHyperplane.getHyperplane();
            Line line = (Line)hyperplane;
            Line line2 = (Line)hyperplane2;
            Vector1D vector1D = line2.toSubSpace((Vector<Euclidean2D>)this.apply((Point)line.toSpace(orientedPoint.getLocation())));
            return new OrientedPoint(vector1D, orientedPoint.isDirect(), line.tolerance).wholeHyperplane();
        }
    }
}

