/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import org.apache.commons.math3.geometry.euclidean.oned.OrientedPoint;
import org.apache.commons.math3.geometry.euclidean.oned.SubOrientedPoint;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.Segment;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubLine
extends AbstractSubHyperplane<Euclidean2D, Euclidean1D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;

    public SubLine(Hyperplane<Euclidean2D> hyperplane, Region<Euclidean1D> region) {
        super(hyperplane, region);
    }

    public SubLine(Vector2D vector2D, Vector2D vector2D2, double d) {
        super(new Line(vector2D, vector2D2, d), SubLine.buildIntervalSet(vector2D, vector2D2, d));
    }

    @Deprecated
    public SubLine(Vector2D vector2D, Vector2D vector2D2) {
        this(vector2D, vector2D2, 1.0E-10);
    }

    public SubLine(Segment segment) {
        super(segment.getLine(), SubLine.buildIntervalSet(segment.getStart(), segment.getEnd(), segment.getLine().getTolerance()));
    }

    public List<Segment> getSegments() {
        Line line = (Line)this.getHyperplane();
        List<Interval> list = ((IntervalsSet)this.getRemainingRegion()).asList();
        ArrayList<Segment> arrayList = new ArrayList<Segment>(list.size());
        for (Interval interval : list) {
            Point point = line.toSpace((Point)new Vector1D(interval.getInf()));
            Point point2 = line.toSpace((Point)new Vector1D(interval.getSup()));
            arrayList.add(new Segment((Vector2D)point, (Vector2D)point2, line));
        }
        return arrayList;
    }

    public Vector2D intersection(SubLine subLine, boolean bl) {
        Line line;
        Line line2 = (Line)this.getHyperplane();
        Vector2D vector2D = line2.intersection(line = (Line)subLine.getHyperplane());
        if (vector2D == null) {
            return null;
        }
        Region.Location location = this.getRemainingRegion().checkPoint(line2.toSubSpace((Point)vector2D));
        Region.Location location2 = subLine.getRemainingRegion().checkPoint(line.toSubSpace((Point)vector2D));
        if (bl) {
            return location != Region.Location.OUTSIDE && location2 != Region.Location.OUTSIDE ? vector2D : null;
        }
        return location == Region.Location.INSIDE && location2 == Region.Location.INSIDE ? vector2D : null;
    }

    private static IntervalsSet buildIntervalSet(Vector2D vector2D, Vector2D vector2D2, double d) {
        Line line = new Line(vector2D, vector2D2, d);
        return new IntervalsSet(((Vector1D)line.toSubSpace((Point)vector2D)).getX(), ((Vector1D)line.toSubSpace((Point)vector2D2)).getX(), d);
    }

    @Override
    protected AbstractSubHyperplane<Euclidean2D, Euclidean1D> buildNew(Hyperplane<Euclidean2D> hyperplane, Region<Euclidean1D> region) {
        return new SubLine(hyperplane, region);
    }

    @Override
    public SubHyperplane.SplitSubHyperplane<Euclidean2D> split(Hyperplane<Euclidean2D> hyperplane) {
        Line line = (Line)this.getHyperplane();
        Line line2 = (Line)hyperplane;
        Vector2D vector2D = line.intersection(line2);
        double d = line.getTolerance();
        if (vector2D == null) {
            double d2 = line2.getOffset(line);
            if (d2 < -d) {
                return new SubHyperplane.SplitSubHyperplane<Euclidean2D>(null, this);
            }
            if (d2 > d) {
                return new SubHyperplane.SplitSubHyperplane<Euclidean2D>(this, null);
            }
            return new SubHyperplane.SplitSubHyperplane<Euclidean2D>(null, null);
        }
        boolean bl = FastMath.sin(line.getAngle() - line2.getAngle()) < 0.0;
        Point point = line.toSubSpace((Point)vector2D);
        SubOrientedPoint subOrientedPoint = new OrientedPoint((Vector1D)point, !bl, d).wholeHyperplane();
        SubOrientedPoint subOrientedPoint2 = new OrientedPoint((Vector1D)point, bl, d).wholeHyperplane();
        BSPTree<Euclidean1D> bSPTree = this.getRemainingRegion().getTree(false).split(subOrientedPoint2);
        BSPTree<Euclidean1D> bSPTree2 = this.getRemainingRegion().isEmpty(bSPTree.getPlus()) ? new BSPTree<Euclidean1D>(Boolean.FALSE) : new BSPTree<Euclidean1D>(subOrientedPoint, new BSPTree(Boolean.FALSE), bSPTree.getPlus(), null);
        BSPTree<Euclidean1D> bSPTree3 = this.getRemainingRegion().isEmpty(bSPTree.getMinus()) ? new BSPTree<Euclidean1D>(Boolean.FALSE) : new BSPTree<Euclidean1D>(subOrientedPoint2, new BSPTree(Boolean.FALSE), bSPTree.getMinus(), null);
        return new SubHyperplane.SplitSubHyperplane<Euclidean2D>(new SubLine(line.copySelf(), new IntervalsSet(bSPTree2, d)), new SubLine(line.copySelf(), new IntervalsSet(bSPTree3, d)));
    }
}

