/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.math3.exception.MathParseException;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.VectorFormat;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.util.CompositeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector2DFormat
extends VectorFormat<Euclidean2D> {
    public Vector2DFormat() {
        super("{", "}", "; ", CompositeFormat.getDefaultNumberFormat());
    }

    public Vector2DFormat(NumberFormat numberFormat) {
        super("{", "}", "; ", numberFormat);
    }

    public Vector2DFormat(String string, String string2, String string3) {
        super(string, string2, string3, CompositeFormat.getDefaultNumberFormat());
    }

    public Vector2DFormat(String string, String string2, String string3, NumberFormat numberFormat) {
        super(string, string2, string3, numberFormat);
    }

    public static Vector2DFormat getInstance() {
        return Vector2DFormat.getInstance(Locale.getDefault());
    }

    public static Vector2DFormat getInstance(Locale locale) {
        return new Vector2DFormat(CompositeFormat.getDefaultNumberFormat(locale));
    }

    @Override
    public StringBuffer format(Vector<Euclidean2D> vector, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Vector2D vector2D = (Vector2D)vector;
        return this.format(stringBuffer, fieldPosition, vector2D.getX(), vector2D.getY());
    }

    public Vector2D parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Vector2D vector2D = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathParseException(string, parsePosition.getErrorIndex(), Vector2D.class);
        }
        return vector2D;
    }

    public Vector2D parse(String string, ParsePosition parsePosition) {
        double[] dArray = this.parseCoordinates(2, string, parsePosition);
        if (dArray == null) {
            return null;
        }
        return new Vector2D(dArray[0], dArray[1]);
    }
}

