/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math3.geometry.partitioning.BoundaryBuilder;
import org.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import org.apache.commons.math3.geometry.partitioning.BoundaryProjector;
import org.apache.commons.math3.geometry.partitioning.BoundarySizeVisitor;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.InsideFinder;
import org.apache.commons.math3.geometry.partitioning.NodesSet;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.RegionFactory;
import org.apache.commons.math3.geometry.partitioning.Side;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.geometry.partitioning.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegion<S extends Space, T extends Space>
implements Region<S> {
    private BSPTree<S> tree;
    private final double tolerance;
    private double size;
    private Point<S> barycenter;

    protected AbstractRegion(double d) {
        this.tree = new BSPTree(Boolean.TRUE);
        this.tolerance = d;
    }

    protected AbstractRegion(BSPTree<S> bSPTree, double d) {
        this.tree = bSPTree;
        this.tolerance = d;
    }

    protected AbstractRegion(Collection<SubHyperplane<S>> collection, double d) {
        this.tolerance = d;
        if (collection.size() == 0) {
            this.tree = new BSPTree(Boolean.TRUE);
        } else {
            TreeSet<SubHyperplane<S>> treeSet = new TreeSet<SubHyperplane<S>>(new Comparator<SubHyperplane<S>>(){

                @Override
                public int compare(SubHyperplane<S> subHyperplane, SubHyperplane<S> subHyperplane2) {
                    double d = subHyperplane.getSize();
                    double d2 = subHyperplane2.getSize();
                    return d2 < d ? -1 : (subHyperplane == subHyperplane2 ? 0 : 1);
                }
            });
            treeSet.addAll(collection);
            this.tree = new BSPTree();
            this.insertCuts(this.tree, treeSet);
            this.tree.visit(new BSPTreeVisitor<S>(){

                @Override
                public BSPTreeVisitor.Order visitOrder(BSPTree<S> bSPTree) {
                    return BSPTreeVisitor.Order.PLUS_SUB_MINUS;
                }

                @Override
                public void visitInternalNode(BSPTree<S> bSPTree) {
                }

                @Override
                public void visitLeafNode(BSPTree<S> bSPTree) {
                    if (bSPTree.getParent() == null || bSPTree == bSPTree.getParent().getMinus()) {
                        bSPTree.setAttribute(Boolean.TRUE);
                    } else {
                        bSPTree.setAttribute(Boolean.FALSE);
                    }
                }
            });
        }
    }

    public AbstractRegion(Hyperplane<S>[] hyperplaneArray, double d) {
        this.tolerance = d;
        if (hyperplaneArray == null || hyperplaneArray.length == 0) {
            this.tree = new BSPTree(Boolean.FALSE);
        } else {
            this.tree = hyperplaneArray[0].wholeSpace().getTree(false);
            BSPTree<S> bSPTree = this.tree;
            bSPTree.setAttribute(Boolean.TRUE);
            for (Hyperplane<S> hyperplane : hyperplaneArray) {
                if (!bSPTree.insertCut(hyperplane)) continue;
                bSPTree.setAttribute(null);
                bSPTree.getPlus().setAttribute(Boolean.FALSE);
                bSPTree = bSPTree.getMinus();
                bSPTree.setAttribute(Boolean.TRUE);
            }
        }
    }

    public abstract AbstractRegion<S, T> buildNew(BSPTree<S> var1);

    public double getTolerance() {
        return this.tolerance;
    }

    private void insertCuts(BSPTree<S> bSPTree, Collection<SubHyperplane<S>> collection) {
        Iterator<SubHyperplane<S>> iterator = collection.iterator();
        Hyperplane<S> hyperplane = null;
        while (hyperplane == null && iterator.hasNext()) {
            hyperplane = iterator.next().getHyperplane();
            if (bSPTree.insertCut(hyperplane.copySelf())) continue;
            hyperplane = null;
        }
        if (!iterator.hasNext()) {
            return;
        }
        ArrayList<SubHyperplane<S>> arrayList = new ArrayList<SubHyperplane<S>>();
        ArrayList<SubHyperplane<S>> arrayList2 = new ArrayList<SubHyperplane<S>>();
        while (iterator.hasNext()) {
            SubHyperplane<S> subHyperplane = iterator.next();
            SubHyperplane.SplitSubHyperplane<S> splitSubHyperplane = subHyperplane.split(hyperplane);
            switch (splitSubHyperplane.getSide()) {
                case PLUS: {
                    arrayList.add(subHyperplane);
                    break;
                }
                case MINUS: {
                    arrayList2.add(subHyperplane);
                    break;
                }
                case BOTH: {
                    arrayList.add(splitSubHyperplane.getPlus());
                    arrayList2.add(splitSubHyperplane.getMinus());
                    break;
                }
            }
        }
        this.insertCuts(bSPTree.getPlus(), arrayList);
        this.insertCuts(bSPTree.getMinus(), arrayList2);
    }

    public AbstractRegion<S, T> copySelf() {
        return this.buildNew((BSPTree)this.tree.copySelf());
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(this.tree);
    }

    @Override
    public boolean isEmpty(BSPTree<S> bSPTree) {
        if (bSPTree.getCut() == null) {
            return (Boolean)bSPTree.getAttribute() == false;
        }
        return this.isEmpty(bSPTree.getMinus()) && this.isEmpty(bSPTree.getPlus());
    }

    @Override
    public boolean isFull() {
        return this.isFull(this.tree);
    }

    @Override
    public boolean isFull(BSPTree<S> bSPTree) {
        if (bSPTree.getCut() == null) {
            return (Boolean)bSPTree.getAttribute();
        }
        return this.isFull(bSPTree.getMinus()) && this.isFull(bSPTree.getPlus());
    }

    @Override
    public boolean contains(Region<S> region) {
        return new RegionFactory<S>().difference(region, this).isEmpty();
    }

    @Override
    public BoundaryProjection<S> projectToBoundary(Point<S> point) {
        BoundaryProjector boundaryProjector = new BoundaryProjector(point);
        this.getTree(true).visit(boundaryProjector);
        return boundaryProjector.getProjection();
    }

    @Override
    public Region.Location checkPoint(Vector<S> vector) {
        return this.checkPoint((Point<S>)vector);
    }

    @Override
    public Region.Location checkPoint(Point<S> point) {
        return this.checkPoint(this.tree, point);
    }

    protected Region.Location checkPoint(BSPTree<S> bSPTree, Vector<S> vector) {
        return this.checkPoint(bSPTree, (Point<S>)vector);
    }

    protected Region.Location checkPoint(BSPTree<S> bSPTree, Point<S> point) {
        Region.Location location;
        BSPTree<S> bSPTree2 = bSPTree.getCell(point, this.tolerance);
        if (bSPTree2.getCut() == null) {
            return (Boolean)bSPTree2.getAttribute() != false ? Region.Location.INSIDE : Region.Location.OUTSIDE;
        }
        Region.Location location2 = this.checkPoint(bSPTree2.getMinus(), point);
        return location2 == (location = this.checkPoint(bSPTree2.getPlus(), point)) ? location2 : Region.Location.BOUNDARY;
    }

    @Override
    public BSPTree<S> getTree(boolean bl) {
        if (bl && this.tree.getCut() != null && this.tree.getAttribute() == null) {
            this.tree.visit(new BoundaryBuilder());
        }
        return this.tree;
    }

    @Override
    public double getBoundarySize() {
        BoundarySizeVisitor boundarySizeVisitor = new BoundarySizeVisitor();
        this.getTree(true).visit(boundarySizeVisitor);
        return boundarySizeVisitor.getSize();
    }

    @Override
    public double getSize() {
        if (this.barycenter == null) {
            this.computeGeometricalProperties();
        }
        return this.size;
    }

    protected void setSize(double d) {
        this.size = d;
    }

    @Override
    public Point<S> getBarycenter() {
        if (this.barycenter == null) {
            this.computeGeometricalProperties();
        }
        return this.barycenter;
    }

    protected void setBarycenter(Vector<S> vector) {
        this.setBarycenter((Point<S>)vector);
    }

    protected void setBarycenter(Point<S> point) {
        this.barycenter = point;
    }

    protected abstract void computeGeometricalProperties();

    @Override
    @Deprecated
    public Side side(Hyperplane<S> hyperplane) {
        InsideFinder<S> insideFinder = new InsideFinder<S>(this);
        insideFinder.recurseSides(this.tree, hyperplane.wholeHyperplane());
        return insideFinder.plusFound() ? (insideFinder.minusFound() ? Side.BOTH : Side.PLUS) : (insideFinder.minusFound() ? Side.MINUS : Side.HYPER);
    }

    @Override
    public SubHyperplane<S> intersection(SubHyperplane<S> subHyperplane) {
        return this.recurseIntersection(this.tree, subHyperplane);
    }

    private SubHyperplane<S> recurseIntersection(BSPTree<S> bSPTree, SubHyperplane<S> subHyperplane) {
        if (bSPTree.getCut() == null) {
            return (Boolean)bSPTree.getAttribute() != false ? subHyperplane.copySelf() : null;
        }
        Hyperplane<S> hyperplane = bSPTree.getCut().getHyperplane();
        SubHyperplane.SplitSubHyperplane<S> splitSubHyperplane = subHyperplane.split(hyperplane);
        if (splitSubHyperplane.getPlus() != null) {
            if (splitSubHyperplane.getMinus() != null) {
                SubHyperplane<S> subHyperplane2 = this.recurseIntersection(bSPTree.getPlus(), splitSubHyperplane.getPlus());
                SubHyperplane<S> subHyperplane3 = this.recurseIntersection(bSPTree.getMinus(), splitSubHyperplane.getMinus());
                if (subHyperplane2 == null) {
                    return subHyperplane3;
                }
                if (subHyperplane3 == null) {
                    return subHyperplane2;
                }
                return subHyperplane2.reunite(subHyperplane3);
            }
            return this.recurseIntersection(bSPTree.getPlus(), subHyperplane);
        }
        if (splitSubHyperplane.getMinus() != null) {
            return this.recurseIntersection(bSPTree.getMinus(), subHyperplane);
        }
        return this.recurseIntersection(bSPTree.getPlus(), this.recurseIntersection(bSPTree.getMinus(), subHyperplane));
    }

    public AbstractRegion<S, T> applyTransform(Transform<S, T> transform) {
        HashMap<BSPTree<S>, BSPTree<S>> hashMap = new HashMap<BSPTree<S>, BSPTree<S>>();
        BSPTree<S> bSPTree = this.recurseTransform(this.getTree(false), transform, hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            BoundaryAttribute boundaryAttribute;
            if (((BSPTree)entry.getKey()).getCut() == null || (boundaryAttribute = (BoundaryAttribute)((BSPTree)entry.getKey()).getAttribute()) == null) continue;
            BoundaryAttribute boundaryAttribute2 = (BoundaryAttribute)((BSPTree)entry.getValue()).getAttribute();
            for (BSPTree bSPTree2 : boundaryAttribute.getSplitters()) {
                boundaryAttribute2.getSplitters().add((BSPTree)hashMap.get(bSPTree2));
            }
        }
        return this.buildNew((BSPTree)bSPTree);
    }

    private BSPTree<S> recurseTransform(BSPTree<S> bSPTree, Transform<S, T> transform, Map<BSPTree<S>, BSPTree<S>> map) {
        BSPTree bSPTree2;
        if (bSPTree.getCut() == null) {
            bSPTree2 = new BSPTree(bSPTree.getAttribute());
        } else {
            SubHyperplane<S> subHyperplane = bSPTree.getCut();
            AbstractSubHyperplane<S, T> abstractSubHyperplane = ((AbstractSubHyperplane)subHyperplane).applyTransform(transform);
            BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
            if (boundaryAttribute != null) {
                AbstractSubHyperplane<S, T> abstractSubHyperplane2 = boundaryAttribute.getPlusOutside() == null ? null : ((AbstractSubHyperplane)boundaryAttribute.getPlusOutside()).applyTransform(transform);
                AbstractSubHyperplane<S, T> abstractSubHyperplane3 = boundaryAttribute.getPlusInside() == null ? null : ((AbstractSubHyperplane)boundaryAttribute.getPlusInside()).applyTransform(transform);
                boundaryAttribute = new BoundaryAttribute(abstractSubHyperplane2, abstractSubHyperplane3, new NodesSet());
            }
            bSPTree2 = new BSPTree<S>(abstractSubHyperplane, this.recurseTransform(bSPTree.getPlus(), transform, map), this.recurseTransform(bSPTree.getMinus(), transform, map), boundaryAttribute);
        }
        map.put(bSPTree, bSPTree2);
        return bSPTree2;
    }
}

