/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.NodesSet;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.RegionFactory;
import org.apache.commons.math3.geometry.partitioning.Side;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.geometry.partitioning.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSubHyperplane<S extends Space, T extends Space>
implements SubHyperplane<S> {
    private final Hyperplane<S> hyperplane;
    private final Region<T> remainingRegion;

    protected AbstractSubHyperplane(Hyperplane<S> hyperplane, Region<T> region) {
        this.hyperplane = hyperplane;
        this.remainingRegion = region;
    }

    protected abstract AbstractSubHyperplane<S, T> buildNew(Hyperplane<S> var1, Region<T> var2);

    public AbstractSubHyperplane<S, T> copySelf() {
        return this.buildNew(this.hyperplane.copySelf(), this.remainingRegion);
    }

    @Override
    public Hyperplane<S> getHyperplane() {
        return this.hyperplane;
    }

    public Region<T> getRemainingRegion() {
        return this.remainingRegion;
    }

    @Override
    public double getSize() {
        return this.remainingRegion.getSize();
    }

    public AbstractSubHyperplane<S, T> reunite(SubHyperplane<S> subHyperplane) {
        AbstractSubHyperplane abstractSubHyperplane = (AbstractSubHyperplane)subHyperplane;
        return this.buildNew(this.hyperplane, new RegionFactory<T>().union(this.remainingRegion, abstractSubHyperplane.remainingRegion));
    }

    public AbstractSubHyperplane<S, T> applyTransform(Transform<S, T> transform) {
        Hyperplane<S> hyperplane = transform.apply(this.hyperplane);
        HashMap<BSPTree<T>, BSPTree<T>> hashMap = new HashMap<BSPTree<T>, BSPTree<T>>();
        BSPTree<T> bSPTree = this.recurseTransform(this.remainingRegion.getTree(false), hyperplane, transform, hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            BoundaryAttribute boundaryAttribute;
            if (((BSPTree)entry.getKey()).getCut() == null || (boundaryAttribute = (BoundaryAttribute)((BSPTree)entry.getKey()).getAttribute()) == null) continue;
            BoundaryAttribute boundaryAttribute2 = (BoundaryAttribute)((BSPTree)entry.getValue()).getAttribute();
            for (BSPTree bSPTree2 : boundaryAttribute.getSplitters()) {
                boundaryAttribute2.getSplitters().add((BSPTree)hashMap.get(bSPTree2));
            }
        }
        return this.buildNew(hyperplane, this.remainingRegion.buildNew(bSPTree));
    }

    private BSPTree<T> recurseTransform(BSPTree<T> bSPTree, Hyperplane<S> hyperplane, Transform<S, T> transform, Map<BSPTree<T>, BSPTree<T>> map) {
        BSPTree<Object> bSPTree2;
        if (bSPTree.getCut() == null) {
            bSPTree2 = new BSPTree(bSPTree.getAttribute());
        } else {
            BoundaryAttribute<T> boundaryAttribute = (BoundaryAttribute<T>)bSPTree.getAttribute();
            if (boundaryAttribute != null) {
                SubHyperplane<T> subHyperplane = boundaryAttribute.getPlusOutside() == null ? null : transform.apply(boundaryAttribute.getPlusOutside(), this.hyperplane, hyperplane);
                SubHyperplane<T> subHyperplane2 = boundaryAttribute.getPlusInside() == null ? null : transform.apply(boundaryAttribute.getPlusInside(), this.hyperplane, hyperplane);
                boundaryAttribute = new BoundaryAttribute<T>(subHyperplane, subHyperplane2, new NodesSet());
            }
            bSPTree2 = new BSPTree<T>(transform.apply(bSPTree.getCut(), this.hyperplane, hyperplane), this.recurseTransform(bSPTree.getPlus(), hyperplane, transform, map), this.recurseTransform(bSPTree.getMinus(), hyperplane, transform, map), boundaryAttribute);
        }
        map.put(bSPTree, bSPTree2);
        return bSPTree2;
    }

    @Override
    @Deprecated
    public Side side(Hyperplane<S> hyperplane) {
        return this.split(hyperplane).getSide();
    }

    @Override
    public abstract SubHyperplane.SplitSubHyperplane<S> split(Hyperplane<S> var1);

    @Override
    public boolean isEmpty() {
        return this.remainingRegion.isEmpty();
    }
}

