/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Side;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSPTree<S extends Space> {
    private SubHyperplane<S> cut;
    private BSPTree<S> plus;
    private BSPTree<S> minus;
    private BSPTree<S> parent;
    private Object attribute;

    public BSPTree() {
        this.cut = null;
        this.plus = null;
        this.minus = null;
        this.parent = null;
        this.attribute = null;
    }

    public BSPTree(Object object) {
        this.cut = null;
        this.plus = null;
        this.minus = null;
        this.parent = null;
        this.attribute = object;
    }

    public BSPTree(SubHyperplane<S> subHyperplane, BSPTree<S> bSPTree, BSPTree<S> bSPTree2, Object object) {
        this.cut = subHyperplane;
        this.plus = bSPTree;
        this.minus = bSPTree2;
        this.parent = null;
        this.attribute = object;
        bSPTree.parent = this;
        bSPTree2.parent = this;
    }

    public boolean insertCut(Hyperplane<S> hyperplane) {
        SubHyperplane<S> subHyperplane;
        if (this.cut != null) {
            this.plus.parent = null;
            this.minus.parent = null;
        }
        if ((subHyperplane = this.fitToCell(hyperplane.wholeHyperplane())) == null || subHyperplane.isEmpty()) {
            this.cut = null;
            this.plus = null;
            this.minus = null;
            return false;
        }
        this.cut = subHyperplane;
        this.plus = new BSPTree<S>();
        this.plus.parent = this;
        this.minus = new BSPTree<S>();
        this.minus.parent = this;
        return true;
    }

    public BSPTree<S> copySelf() {
        if (this.cut == null) {
            return new BSPTree<S>(this.attribute);
        }
        return new BSPTree<S>(this.cut.copySelf(), this.plus.copySelf(), this.minus.copySelf(), this.attribute);
    }

    public SubHyperplane<S> getCut() {
        return this.cut;
    }

    public BSPTree<S> getPlus() {
        return this.plus;
    }

    public BSPTree<S> getMinus() {
        return this.minus;
    }

    public BSPTree<S> getParent() {
        return this.parent;
    }

    public void setAttribute(Object object) {
        this.attribute = object;
    }

    public Object getAttribute() {
        return this.attribute;
    }

    public void visit(BSPTreeVisitor<S> bSPTreeVisitor) {
        if (this.cut == null) {
            bSPTreeVisitor.visitLeafNode(this);
        } else {
            switch (bSPTreeVisitor.visitOrder(this)) {
                case PLUS_MINUS_SUB: {
                    this.plus.visit(bSPTreeVisitor);
                    this.minus.visit(bSPTreeVisitor);
                    bSPTreeVisitor.visitInternalNode(this);
                    break;
                }
                case PLUS_SUB_MINUS: {
                    this.plus.visit(bSPTreeVisitor);
                    bSPTreeVisitor.visitInternalNode(this);
                    this.minus.visit(bSPTreeVisitor);
                    break;
                }
                case MINUS_PLUS_SUB: {
                    this.minus.visit(bSPTreeVisitor);
                    this.plus.visit(bSPTreeVisitor);
                    bSPTreeVisitor.visitInternalNode(this);
                    break;
                }
                case MINUS_SUB_PLUS: {
                    this.minus.visit(bSPTreeVisitor);
                    bSPTreeVisitor.visitInternalNode(this);
                    this.plus.visit(bSPTreeVisitor);
                    break;
                }
                case SUB_PLUS_MINUS: {
                    bSPTreeVisitor.visitInternalNode(this);
                    this.plus.visit(bSPTreeVisitor);
                    this.minus.visit(bSPTreeVisitor);
                    break;
                }
                case SUB_MINUS_PLUS: {
                    bSPTreeVisitor.visitInternalNode(this);
                    this.minus.visit(bSPTreeVisitor);
                    this.plus.visit(bSPTreeVisitor);
                    break;
                }
                default: {
                    throw new MathInternalError();
                }
            }
        }
    }

    private SubHyperplane<S> fitToCell(SubHyperplane<S> subHyperplane) {
        SubHyperplane<S> subHyperplane2 = subHyperplane;
        BSPTree<S> bSPTree = this;
        while (bSPTree.parent != null && subHyperplane2 != null) {
            subHyperplane2 = bSPTree == bSPTree.parent.plus ? subHyperplane2.split(bSPTree.parent.cut.getHyperplane()).getPlus() : subHyperplane2.split(bSPTree.parent.cut.getHyperplane()).getMinus();
            bSPTree = bSPTree.parent;
        }
        return subHyperplane2;
    }

    @Deprecated
    public BSPTree<S> getCell(Vector<S> vector) {
        return this.getCell(vector, 1.0E-10);
    }

    public BSPTree<S> getCell(Point<S> point, double d) {
        if (this.cut == null) {
            return this;
        }
        double d2 = this.cut.getHyperplane().getOffset(point);
        if (FastMath.abs(d2) < d) {
            return this;
        }
        if (d2 <= 0.0) {
            return this.minus.getCell(point, d);
        }
        return this.plus.getCell(point, d);
    }

    public List<BSPTree<S>> getCloseCuts(Point<S> point, double d) {
        ArrayList<BSPTree<S>> arrayList = new ArrayList<BSPTree<S>>();
        this.recurseCloseCuts(point, d, arrayList);
        return arrayList;
    }

    private void recurseCloseCuts(Point<S> point, double d, List<BSPTree<S>> list) {
        if (this.cut != null) {
            double d2 = this.cut.getHyperplane().getOffset(point);
            if (d2 < -d) {
                super.recurseCloseCuts(point, d, list);
            } else if (d2 > d) {
                super.recurseCloseCuts(point, d, list);
            } else {
                list.add(this);
                super.recurseCloseCuts(point, d, list);
                super.recurseCloseCuts(point, d, list);
            }
        }
    }

    private void condense() {
        if (this.cut != null && this.plus.cut == null && this.minus.cut == null && (this.plus.attribute == null && this.minus.attribute == null || this.plus.attribute != null && this.plus.attribute.equals(this.minus.attribute))) {
            this.attribute = this.plus.attribute == null ? this.minus.attribute : this.plus.attribute;
            this.cut = null;
            this.plus = null;
            this.minus = null;
        }
    }

    public BSPTree<S> merge(BSPTree<S> bSPTree, LeafMerger<S> leafMerger) {
        return this.merge(bSPTree, leafMerger, null, false);
    }

    private BSPTree<S> merge(BSPTree<S> bSPTree, LeafMerger<S> leafMerger, BSPTree<S> bSPTree2, boolean bl) {
        if (this.cut == null) {
            return leafMerger.merge(this, bSPTree, bSPTree2, bl, true);
        }
        if (bSPTree.cut == null) {
            return leafMerger.merge(bSPTree, this, bSPTree2, bl, false);
        }
        BSPTree<S> bSPTree3 = bSPTree.split(this.cut);
        if (bSPTree2 != null) {
            bSPTree3.parent = bSPTree2;
            if (bl) {
                bSPTree2.plus = bSPTree3;
            } else {
                bSPTree2.minus = bSPTree3;
            }
        }
        super.merge(bSPTree3.plus, leafMerger, bSPTree3, true);
        super.merge(bSPTree3.minus, leafMerger, bSPTree3, false);
        super.condense();
        if (bSPTree3.cut != null) {
            bSPTree3.cut = super.fitToCell(bSPTree3.cut.getHyperplane().wholeHyperplane());
        }
        return bSPTree3;
    }

    public BSPTree<S> split(SubHyperplane<S> subHyperplane) {
        if (this.cut == null) {
            return new BSPTree<S>(subHyperplane, this.copySelf(), new BSPTree<S>(this.attribute), null);
        }
        Hyperplane<S> hyperplane = this.cut.getHyperplane();
        Hyperplane<S> hyperplane2 = subHyperplane.getHyperplane();
        SubHyperplane.SplitSubHyperplane<S> splitSubHyperplane = subHyperplane.split(hyperplane);
        switch (splitSubHyperplane.getSide()) {
            case PLUS: {
                BSPTree<S> bSPTree = this.plus.split(subHyperplane);
                if (this.cut.split(hyperplane2).getSide() == Side.PLUS) {
                    bSPTree.plus = new BSPTree<S>(this.cut.copySelf(), bSPTree.plus, this.minus.copySelf(), this.attribute);
                    super.condense();
                    bSPTree.plus.parent = bSPTree;
                } else {
                    bSPTree.minus = new BSPTree<S>(this.cut.copySelf(), bSPTree.minus, this.minus.copySelf(), this.attribute);
                    super.condense();
                    bSPTree.minus.parent = bSPTree;
                }
                return bSPTree;
            }
            case MINUS: {
                BSPTree<S> bSPTree = this.minus.split(subHyperplane);
                if (this.cut.split(hyperplane2).getSide() == Side.PLUS) {
                    bSPTree.plus = new BSPTree<S>(this.cut.copySelf(), this.plus.copySelf(), bSPTree.plus, this.attribute);
                    super.condense();
                    bSPTree.plus.parent = bSPTree;
                } else {
                    bSPTree.minus = new BSPTree<S>(this.cut.copySelf(), this.plus.copySelf(), bSPTree.minus, this.attribute);
                    super.condense();
                    bSPTree.minus.parent = bSPTree;
                }
                return bSPTree;
            }
            case BOTH: {
                SubHyperplane.SplitSubHyperplane<S> splitSubHyperplane2 = this.cut.split(hyperplane2);
                BSPTree<S> bSPTree = new BSPTree<S>(subHyperplane, this.plus.split(splitSubHyperplane.getPlus()), this.minus.split(splitSubHyperplane.getMinus()), null);
                bSPTree.plus.cut = splitSubHyperplane2.getPlus();
                bSPTree.minus.cut = splitSubHyperplane2.getMinus();
                BSPTree<S> bSPTree2 = bSPTree.plus.minus;
                bSPTree.plus.minus = bSPTree.minus.plus;
                bSPTree.plus.minus.parent = bSPTree.plus;
                bSPTree.minus.plus = bSPTree2;
                bSPTree.minus.plus.parent = bSPTree.minus;
                super.condense();
                super.condense();
                return bSPTree;
            }
        }
        return hyperplane.sameOrientationAs(hyperplane2) ? new BSPTree<S>(subHyperplane, this.plus.copySelf(), this.minus.copySelf(), this.attribute) : new BSPTree<S>(subHyperplane, this.minus.copySelf(), this.plus.copySelf(), this.attribute);
    }

    @Deprecated
    public void insertInTree(BSPTree<S> bSPTree, boolean bl) {
        this.insertInTree(bSPTree, bl, new VanishingCutHandler<S>(){

            @Override
            public BSPTree<S> fixNode(BSPTree<S> bSPTree) {
                throw new MathIllegalStateException(LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
            }
        });
    }

    public void insertInTree(BSPTree<S> bSPTree, boolean bl, VanishingCutHandler<S> vanishingCutHandler) {
        this.parent = bSPTree;
        if (bSPTree != null) {
            if (bl) {
                bSPTree.plus = this;
            } else {
                bSPTree.minus = this;
            }
        }
        if (this.cut != null) {
            BSPTree<S> bSPTree2 = this;
            while (bSPTree2.parent != null) {
                Hyperplane<S> hyperplane = bSPTree2.parent.cut.getHyperplane();
                if (bSPTree2 == bSPTree2.parent.plus) {
                    this.cut = this.cut.split(hyperplane).getPlus();
                    super.chopOffMinus(hyperplane, vanishingCutHandler);
                    super.chopOffMinus(hyperplane, vanishingCutHandler);
                } else {
                    this.cut = this.cut.split(hyperplane).getMinus();
                    super.chopOffPlus(hyperplane, vanishingCutHandler);
                    super.chopOffPlus(hyperplane, vanishingCutHandler);
                }
                if (this.cut == null) {
                    BSPTree<S> bSPTree3 = vanishingCutHandler.fixNode(this);
                    this.cut = bSPTree3.cut;
                    this.plus = bSPTree3.plus;
                    this.minus = bSPTree3.minus;
                    this.attribute = bSPTree3.attribute;
                    if (this.cut == null) break;
                }
                bSPTree2 = bSPTree2.parent;
            }
            this.condense();
        }
    }

    public BSPTree<S> pruneAroundConvexCell(Object object, Object object2, Object object3) {
        BSPTree<S> bSPTree = new BSPTree<S>(object);
        BSPTree<S> bSPTree2 = this;
        while (bSPTree2.parent != null) {
            SubHyperplane<S> subHyperplane = bSPTree2.parent.cut.copySelf();
            BSPTree<S> bSPTree3 = new BSPTree<S>(object2);
            bSPTree = bSPTree2 == bSPTree2.parent.plus ? new BSPTree<S>(subHyperplane, bSPTree, bSPTree3, object3) : new BSPTree<S>(subHyperplane, bSPTree3, bSPTree, object3);
            bSPTree2 = bSPTree2.parent;
        }
        return bSPTree;
    }

    private void chopOffMinus(Hyperplane<S> hyperplane, VanishingCutHandler<S> vanishingCutHandler) {
        if (this.cut != null) {
            this.cut = this.cut.split(hyperplane).getPlus();
            super.chopOffMinus(hyperplane, vanishingCutHandler);
            super.chopOffMinus(hyperplane, vanishingCutHandler);
            if (this.cut == null) {
                BSPTree<S> bSPTree = vanishingCutHandler.fixNode(this);
                this.cut = bSPTree.cut;
                this.plus = bSPTree.plus;
                this.minus = bSPTree.minus;
                this.attribute = bSPTree.attribute;
            }
        }
    }

    private void chopOffPlus(Hyperplane<S> hyperplane, VanishingCutHandler<S> vanishingCutHandler) {
        if (this.cut != null) {
            this.cut = this.cut.split(hyperplane).getMinus();
            super.chopOffPlus(hyperplane, vanishingCutHandler);
            super.chopOffPlus(hyperplane, vanishingCutHandler);
            if (this.cut == null) {
                BSPTree<S> bSPTree = vanishingCutHandler.fixNode(this);
                this.cut = bSPTree.cut;
                this.plus = bSPTree.plus;
                this.minus = bSPTree.minus;
                this.attribute = bSPTree.attribute;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface VanishingCutHandler<S extends Space> {
        public BSPTree<S> fixNode(BSPTree<S> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LeafMerger<S extends Space> {
        public BSPTree<S> merge(BSPTree<S> var1, BSPTree<S> var2, BSPTree<S> var3, boolean var4, boolean var5);
    }
}

