/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning;

import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.Side;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InsideFinder<S extends Space> {
    private final Region<S> region;
    private boolean plusFound;
    private boolean minusFound;

    InsideFinder(Region<S> region) {
        this.region = region;
        this.plusFound = false;
        this.minusFound = false;
    }

    public void recurseSides(BSPTree<S> bSPTree, SubHyperplane<S> subHyperplane) {
        if (bSPTree.getCut() == null) {
            if (((Boolean)bSPTree.getAttribute()).booleanValue()) {
                this.plusFound = true;
                this.minusFound = true;
            }
            return;
        }
        Hyperplane<S> hyperplane = bSPTree.getCut().getHyperplane();
        SubHyperplane.SplitSubHyperplane<S> splitSubHyperplane = subHyperplane.split(hyperplane);
        switch (splitSubHyperplane.getSide()) {
            case PLUS: {
                if (bSPTree.getCut().split(subHyperplane.getHyperplane()).getSide() == Side.PLUS) {
                    if (!this.region.isEmpty(bSPTree.getMinus())) {
                        this.plusFound = true;
                    }
                } else if (!this.region.isEmpty(bSPTree.getMinus())) {
                    this.minusFound = true;
                }
                if (this.plusFound && this.minusFound) break;
                this.recurseSides(bSPTree.getPlus(), subHyperplane);
                break;
            }
            case MINUS: {
                if (bSPTree.getCut().split(subHyperplane.getHyperplane()).getSide() == Side.PLUS) {
                    if (!this.region.isEmpty(bSPTree.getPlus())) {
                        this.plusFound = true;
                    }
                } else if (!this.region.isEmpty(bSPTree.getPlus())) {
                    this.minusFound = true;
                }
                if (this.plusFound && this.minusFound) break;
                this.recurseSides(bSPTree.getMinus(), subHyperplane);
                break;
            }
            case BOTH: {
                this.recurseSides(bSPTree.getPlus(), splitSubHyperplane.getPlus());
                if (this.plusFound && this.minusFound) break;
                this.recurseSides(bSPTree.getMinus(), splitSubHyperplane.getMinus());
                break;
            }
            default: {
                if (bSPTree.getCut().getHyperplane().sameOrientationAs(subHyperplane.getHyperplane())) {
                    if (bSPTree.getPlus().getCut() != null || ((Boolean)bSPTree.getPlus().getAttribute()).booleanValue()) {
                        this.plusFound = true;
                    }
                    if (bSPTree.getMinus().getCut() == null && !((Boolean)bSPTree.getMinus().getAttribute()).booleanValue()) break;
                    this.minusFound = true;
                    break;
                }
                if (bSPTree.getPlus().getCut() != null || ((Boolean)bSPTree.getPlus().getAttribute()).booleanValue()) {
                    this.minusFound = true;
                }
                if (bSPTree.getMinus().getCut() == null && !((Boolean)bSPTree.getMinus().getAttribute()).booleanValue()) break;
                this.plusFound = true;
            }
        }
    }

    public boolean plusFound() {
        return this.plusFound;
    }

    public boolean minusFound() {
        return this.minusFound;
    }
}

