/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.NodesSet;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionFactory<S extends Space> {
    private final NodesCleaner nodeCleaner = new NodesCleaner();

    public Region<S> buildConvex(Hyperplane<S> ... hyperplaneArray) {
        if (hyperplaneArray == null || hyperplaneArray.length == 0) {
            return null;
        }
        Region<S> region = hyperplaneArray[0].wholeSpace();
        BSPTree<S> bSPTree = region.getTree(false);
        bSPTree.setAttribute(Boolean.TRUE);
        for (Hyperplane<S> hyperplane : hyperplaneArray) {
            if (bSPTree.insertCut(hyperplane)) {
                bSPTree.setAttribute(null);
                bSPTree.getPlus().setAttribute(Boolean.FALSE);
                bSPTree = bSPTree.getMinus();
                bSPTree.setAttribute(Boolean.TRUE);
                continue;
            }
            SubHyperplane<S> subHyperplane = hyperplane.wholeHyperplane();
            BSPTree<S> bSPTree2 = bSPTree;
            while (bSPTree2.getParent() != null && subHyperplane != null) {
                Hyperplane<S> hyperplane2 = bSPTree2.getParent().getCut().getHyperplane();
                SubHyperplane.SplitSubHyperplane<S> splitSubHyperplane = subHyperplane.split(hyperplane2);
                switch (splitSubHyperplane.getSide()) {
                    case HYPER: {
                        if (hyperplane.sameOrientationAs(hyperplane2)) break;
                        return this.getComplement(hyperplaneArray[0].wholeSpace());
                    }
                    case PLUS: {
                        throw new MathIllegalArgumentException(LocalizedFormats.NOT_CONVEX_HYPERPLANES, new Object[0]);
                    }
                    default: {
                        subHyperplane = splitSubHyperplane.getMinus();
                    }
                }
                bSPTree2 = bSPTree2.getParent();
            }
        }
        return region;
    }

    public Region<S> union(Region<S> region, Region<S> region2) {
        BSPTree<S> bSPTree = region.getTree(false).merge(region2.getTree(false), new UnionMerger());
        bSPTree.visit(this.nodeCleaner);
        return region.buildNew(bSPTree);
    }

    public Region<S> intersection(Region<S> region, Region<S> region2) {
        BSPTree<S> bSPTree = region.getTree(false).merge(region2.getTree(false), new IntersectionMerger());
        bSPTree.visit(this.nodeCleaner);
        return region.buildNew(bSPTree);
    }

    public Region<S> xor(Region<S> region, Region<S> region2) {
        BSPTree<S> bSPTree = region.getTree(false).merge(region2.getTree(false), new XorMerger());
        bSPTree.visit(this.nodeCleaner);
        return region.buildNew(bSPTree);
    }

    public Region<S> difference(Region<S> region, Region<S> region2) {
        BSPTree<S> bSPTree = region.getTree(false).merge(region2.getTree(false), new DifferenceMerger(region, region2));
        bSPTree.visit(this.nodeCleaner);
        return region.buildNew(bSPTree);
    }

    public Region<S> getComplement(Region<S> region) {
        return region.buildNew(this.recurseComplement(region.getTree(false)));
    }

    private BSPTree<S> recurseComplement(BSPTree<S> bSPTree) {
        HashMap<BSPTree<S>, BSPTree<S>> hashMap = new HashMap<BSPTree<S>, BSPTree<S>>();
        BSPTree<S> bSPTree2 = this.recurseComplement(bSPTree, hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            BoundaryAttribute boundaryAttribute;
            if (((BSPTree)entry.getKey()).getCut() == null || (boundaryAttribute = (BoundaryAttribute)((BSPTree)entry.getKey()).getAttribute()) == null) continue;
            BoundaryAttribute boundaryAttribute2 = (BoundaryAttribute)((BSPTree)entry.getValue()).getAttribute();
            for (BSPTree bSPTree3 : boundaryAttribute.getSplitters()) {
                boundaryAttribute2.getSplitters().add((BSPTree)hashMap.get(bSPTree3));
            }
        }
        return bSPTree2;
    }

    private BSPTree<S> recurseComplement(BSPTree<S> bSPTree, Map<BSPTree<S>, BSPTree<S>> map) {
        BSPTree bSPTree2;
        if (bSPTree.getCut() == null) {
            bSPTree2 = new BSPTree((Boolean)bSPTree.getAttribute() != false ? Boolean.FALSE : Boolean.TRUE);
        } else {
            BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
            if (boundaryAttribute != null) {
                SubHyperplane subHyperplane = boundaryAttribute.getPlusInside() == null ? null : boundaryAttribute.getPlusInside().copySelf();
                SubHyperplane subHyperplane2 = boundaryAttribute.getPlusOutside() == null ? null : boundaryAttribute.getPlusOutside().copySelf();
                boundaryAttribute = new BoundaryAttribute(subHyperplane, subHyperplane2, new NodesSet());
            }
            bSPTree2 = new BSPTree<S>(bSPTree.getCut().copySelf(), this.recurseComplement(bSPTree.getPlus(), map), this.recurseComplement(bSPTree.getMinus(), map), boundaryAttribute);
        }
        map.put(bSPTree, bSPTree2);
        return bSPTree2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VanishingToLeaf
    implements BSPTree.VanishingCutHandler<S> {
        private final boolean inside;

        VanishingToLeaf(boolean bl) {
            this.inside = bl;
        }

        @Override
        public BSPTree<S> fixNode(BSPTree<S> bSPTree) {
            if (bSPTree.getPlus().getAttribute().equals(bSPTree.getMinus().getAttribute())) {
                return new BSPTree(bSPTree.getPlus().getAttribute());
            }
            return new BSPTree(this.inside);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodesCleaner
    implements BSPTreeVisitor<S> {
        private NodesCleaner() {
        }

        @Override
        public BSPTreeVisitor.Order visitOrder(BSPTree<S> bSPTree) {
            return BSPTreeVisitor.Order.PLUS_SUB_MINUS;
        }

        @Override
        public void visitInternalNode(BSPTree<S> bSPTree) {
            bSPTree.setAttribute(null);
        }

        @Override
        public void visitLeafNode(BSPTree<S> bSPTree) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DifferenceMerger
    implements BSPTree.LeafMerger<S>,
    BSPTree.VanishingCutHandler<S> {
        private final Region<S> region1;
        private final Region<S> region2;

        DifferenceMerger(Region<S> region, Region<S> region2) {
            this.region1 = region.copySelf();
            this.region2 = region2.copySelf();
        }

        @Override
        public BSPTree<S> merge(BSPTree<S> bSPTree, BSPTree<S> bSPTree2, BSPTree<S> bSPTree3, boolean bl, boolean bl2) {
            if (((Boolean)bSPTree.getAttribute()).booleanValue()) {
                BSPTree bSPTree4 = RegionFactory.this.recurseComplement(bl2 ? bSPTree2 : bSPTree);
                bSPTree4.insertInTree(bSPTree3, bl, this);
                return bSPTree4;
            }
            BSPTree bSPTree5 = bl2 ? bSPTree : bSPTree2;
            bSPTree5.insertInTree(bSPTree3, bl, this);
            return bSPTree5;
        }

        @Override
        public BSPTree<S> fixNode(BSPTree<S> bSPTree) {
            BSPTree bSPTree2 = bSPTree.pruneAroundConvexCell(Boolean.TRUE, Boolean.FALSE, null);
            Region region = this.region1.buildNew(bSPTree2);
            Point point = region.getBarycenter();
            return new BSPTree(this.region1.checkPoint(point) == Region.Location.INSIDE && this.region2.checkPoint(point) == Region.Location.OUTSIDE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XorMerger
    implements BSPTree.LeafMerger<S> {
        private XorMerger() {
        }

        @Override
        public BSPTree<S> merge(BSPTree<S> bSPTree, BSPTree<S> bSPTree2, BSPTree<S> bSPTree3, boolean bl, boolean bl2) {
            BSPTree bSPTree4 = bSPTree2;
            if (((Boolean)bSPTree.getAttribute()).booleanValue()) {
                bSPTree4 = RegionFactory.this.recurseComplement(bSPTree4);
            }
            bSPTree4.insertInTree(bSPTree3, bl, new VanishingToLeaf(true));
            return bSPTree4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntersectionMerger
    implements BSPTree.LeafMerger<S> {
        private IntersectionMerger() {
        }

        @Override
        public BSPTree<S> merge(BSPTree<S> bSPTree, BSPTree<S> bSPTree2, BSPTree<S> bSPTree3, boolean bl, boolean bl2) {
            if (((Boolean)bSPTree.getAttribute()).booleanValue()) {
                bSPTree2.insertInTree(bSPTree3, bl, new VanishingToLeaf(true));
                return bSPTree2;
            }
            bSPTree.insertInTree(bSPTree3, bl, new VanishingToLeaf(false));
            return bSPTree;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnionMerger
    implements BSPTree.LeafMerger<S> {
        private UnionMerger() {
        }

        @Override
        public BSPTree<S> merge(BSPTree<S> bSPTree, BSPTree<S> bSPTree2, BSPTree<S> bSPTree3, boolean bl, boolean bl2) {
            if (((Boolean)bSPTree.getAttribute()).booleanValue()) {
                bSPTree.insertInTree(bSPTree3, bl, new VanishingToLeaf(true));
                return bSPTree;
            }
            bSPTree2.insertInTree(bSPTree3, bl, new VanishingToLeaf(false));
            return bSPTree2;
        }
    }
}

