/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning.utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AVLTree<T extends Comparable<T>> {
    private Node top = null;

    public void insert(T t) {
        if (t != null) {
            if (this.top == null) {
                this.top = new Node(this, t, null);
            } else {
                this.top.insert(t);
            }
        }
    }

    public boolean delete(T t) {
        if (t != null) {
            for (Node node = this.getNotSmaller(t); node != null; node = node.getNext()) {
                if (node.element == t) {
                    node.delete();
                    return true;
                }
                if (node.element.compareTo(t) <= 0) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.top == null;
    }

    public int size() {
        return this.top == null ? 0 : this.top.size();
    }

    public Node getSmallest() {
        return this.top == null ? null : this.top.getSmallest();
    }

    public Node getLargest() {
        return this.top == null ? null : this.top.getLargest();
    }

    public Node getNotSmaller(T t) {
        Node node = null;
        Node node2 = this.top;
        while (node2 != null) {
            if (node2.element.compareTo(t) < 0) {
                if (node2.right == null) {
                    return node;
                }
                node2 = node2.right;
                continue;
            }
            node = node2;
            if (node2.left == null) {
                return node;
            }
            node2 = node2.left;
        }
        return null;
    }

    public Node getNotLarger(T t) {
        Node node = null;
        Node node2 = this.top;
        while (node2 != null) {
            if (node2.element.compareTo(t) > 0) {
                if (node2.left == null) {
                    return node;
                }
                node2 = node2.left;
                continue;
            }
            node = node2;
            if (node2.right == null) {
                return node;
            }
            node2 = node2.right;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node {
        private T element;
        private Node left;
        private Node right;
        private Node parent;
        private Skew skew;
        final /* synthetic */ AVLTree this$0;

        Node(T t, Node node) {
            this.this$0 = var1_1;
            this.element = t;
            this.left = null;
            this.right = null;
            this.parent = node;
            this.skew = Skew.BALANCED;
        }

        public T getElement() {
            return this.element;
        }

        int size() {
            return 1 + (this.left == null ? 0 : this.left.size()) + (this.right == null ? 0 : this.right.size());
        }

        Node getSmallest() {
            Node node = this;
            while (node.left != null) {
                node = node.left;
            }
            return node;
        }

        Node getLargest() {
            Node node = this;
            while (node.right != null) {
                node = node.right;
            }
            return node;
        }

        public Node getPrevious() {
            Node node;
            if (this.left != null && (node = this.left.getLargest()) != null) {
                return node;
            }
            node = this;
            while (node.parent != null) {
                if (node != node.parent.left) {
                    return node.parent;
                }
                node = node.parent;
            }
            return null;
        }

        public Node getNext() {
            Node node;
            if (this.right != null && (node = this.right.getSmallest()) != null) {
                return node;
            }
            node = this;
            while (node.parent != null) {
                if (node != node.parent.right) {
                    return node.parent;
                }
                node = node.parent;
            }
            return null;
        }

        boolean insert(T t) {
            if (t.compareTo(this.element) < 0) {
                if (this.left == null) {
                    this.left = new Node(this.this$0, t, this);
                    return this.rebalanceLeftGrown();
                }
                return this.left.insert(t) ? this.rebalanceLeftGrown() : false;
            }
            if (this.right == null) {
                this.right = new Node(this.this$0, t, this);
                return this.rebalanceRightGrown();
            }
            return this.right.insert(t) ? this.rebalanceRightGrown() : false;
        }

        public void delete() {
            if (this.parent == null && this.left == null && this.right == null) {
                this.element = null;
                this.this$0.top = null;
            } else {
                Node node;
                boolean bl;
                Node node2;
                if (this.left == null && this.right == null) {
                    node2 = this;
                    this.element = null;
                    bl = node2 == node2.parent.left;
                    node = null;
                } else {
                    node2 = this.left != null ? this.left.getLargest() : this.right.getSmallest();
                    this.element = node2.element;
                    bl = node2 == node2.parent.left;
                    node = node2.left != null ? node2.left : node2.right;
                }
                node2 = node2.parent;
                if (bl) {
                    node2.left = node;
                } else {
                    node2.right = node;
                }
                if (node != null) {
                    node.parent = node2;
                }
                while (bl ? node2.rebalanceLeftShrunk() : node2.rebalanceRightShrunk()) {
                    if (node2.parent == null) {
                        return;
                    }
                    bl = node2 == node2.parent.left;
                    node2 = node2.parent;
                }
            }
        }

        private boolean rebalanceLeftGrown() {
            switch (this.skew) {
                case LEFT_HIGH: {
                    if (this.left.skew == Skew.LEFT_HIGH) {
                        this.rotateCW();
                        this.skew = Skew.BALANCED;
                        this.right.skew = Skew.BALANCED;
                    } else {
                        Skew skew = this.left.right.skew;
                        this.left.rotateCCW();
                        this.rotateCW();
                        switch (skew) {
                            case LEFT_HIGH: {
                                this.left.skew = Skew.BALANCED;
                                this.right.skew = Skew.RIGHT_HIGH;
                                break;
                            }
                            case RIGHT_HIGH: {
                                this.left.skew = Skew.LEFT_HIGH;
                                this.right.skew = Skew.BALANCED;
                                break;
                            }
                            default: {
                                this.left.skew = Skew.BALANCED;
                                this.right.skew = Skew.BALANCED;
                            }
                        }
                        this.skew = Skew.BALANCED;
                    }
                    return false;
                }
                case RIGHT_HIGH: {
                    this.skew = Skew.BALANCED;
                    return false;
                }
            }
            this.skew = Skew.LEFT_HIGH;
            return true;
        }

        private boolean rebalanceRightGrown() {
            switch (this.skew) {
                case LEFT_HIGH: {
                    this.skew = Skew.BALANCED;
                    return false;
                }
                case RIGHT_HIGH: {
                    if (this.right.skew == Skew.RIGHT_HIGH) {
                        this.rotateCCW();
                        this.skew = Skew.BALANCED;
                        this.left.skew = Skew.BALANCED;
                    } else {
                        Skew skew = this.right.left.skew;
                        this.right.rotateCW();
                        this.rotateCCW();
                        switch (skew) {
                            case LEFT_HIGH: {
                                this.left.skew = Skew.BALANCED;
                                this.right.skew = Skew.RIGHT_HIGH;
                                break;
                            }
                            case RIGHT_HIGH: {
                                this.left.skew = Skew.LEFT_HIGH;
                                this.right.skew = Skew.BALANCED;
                                break;
                            }
                            default: {
                                this.left.skew = Skew.BALANCED;
                                this.right.skew = Skew.BALANCED;
                            }
                        }
                        this.skew = Skew.BALANCED;
                    }
                    return false;
                }
            }
            this.skew = Skew.RIGHT_HIGH;
            return true;
        }

        private boolean rebalanceLeftShrunk() {
            switch (this.skew) {
                case LEFT_HIGH: {
                    this.skew = Skew.BALANCED;
                    return true;
                }
                case RIGHT_HIGH: {
                    if (this.right.skew == Skew.RIGHT_HIGH) {
                        this.rotateCCW();
                        this.skew = Skew.BALANCED;
                        this.left.skew = Skew.BALANCED;
                        return true;
                    }
                    if (this.right.skew == Skew.BALANCED) {
                        this.rotateCCW();
                        this.skew = Skew.LEFT_HIGH;
                        this.left.skew = Skew.RIGHT_HIGH;
                        return false;
                    }
                    Skew skew = this.right.left.skew;
                    this.right.rotateCW();
                    this.rotateCCW();
                    switch (skew) {
                        case LEFT_HIGH: {
                            this.left.skew = Skew.BALANCED;
                            this.right.skew = Skew.RIGHT_HIGH;
                            break;
                        }
                        case RIGHT_HIGH: {
                            this.left.skew = Skew.LEFT_HIGH;
                            this.right.skew = Skew.BALANCED;
                            break;
                        }
                        default: {
                            this.left.skew = Skew.BALANCED;
                            this.right.skew = Skew.BALANCED;
                        }
                    }
                    this.skew = Skew.BALANCED;
                    return true;
                }
            }
            this.skew = Skew.RIGHT_HIGH;
            return false;
        }

        private boolean rebalanceRightShrunk() {
            switch (this.skew) {
                case RIGHT_HIGH: {
                    this.skew = Skew.BALANCED;
                    return true;
                }
                case LEFT_HIGH: {
                    if (this.left.skew == Skew.LEFT_HIGH) {
                        this.rotateCW();
                        this.skew = Skew.BALANCED;
                        this.right.skew = Skew.BALANCED;
                        return true;
                    }
                    if (this.left.skew == Skew.BALANCED) {
                        this.rotateCW();
                        this.skew = Skew.RIGHT_HIGH;
                        this.right.skew = Skew.LEFT_HIGH;
                        return false;
                    }
                    Skew skew = this.left.right.skew;
                    this.left.rotateCCW();
                    this.rotateCW();
                    switch (skew) {
                        case LEFT_HIGH: {
                            this.left.skew = Skew.BALANCED;
                            this.right.skew = Skew.RIGHT_HIGH;
                            break;
                        }
                        case RIGHT_HIGH: {
                            this.left.skew = Skew.LEFT_HIGH;
                            this.right.skew = Skew.BALANCED;
                            break;
                        }
                        default: {
                            this.left.skew = Skew.BALANCED;
                            this.right.skew = Skew.BALANCED;
                        }
                    }
                    this.skew = Skew.BALANCED;
                    return true;
                }
            }
            this.skew = Skew.LEFT_HIGH;
            return false;
        }

        private void rotateCW() {
            Object t = this.element;
            this.element = this.left.element;
            this.left.element = t;
            Node node = this.left;
            this.left = node.left;
            node.left = node.right;
            node.right = this.right;
            this.right = node;
            if (this.left != null) {
                this.left.parent = this;
            }
            if (this.right.right != null) {
                this.right.right.parent = this.right;
            }
        }

        private void rotateCCW() {
            Object t = this.element;
            this.element = this.right.element;
            this.right.element = t;
            Node node = this.right;
            this.right = node.right;
            node.right = node.left;
            node.left = this.left;
            this.left = node;
            if (this.right != null) {
                this.right.parent = this;
            }
            if (this.left.left != null) {
                this.left.left.parent = this.left;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Skew {
        LEFT_HIGH,
        RIGHT_HIGH,
        BALANCED;

    }
}

