/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.spherical.oned;

import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

public class Arc {
    private final double lower;
    private final double upper;
    private final double middle;
    private final double tolerance;

    public Arc(double d, double d2, double d3) {
        this.tolerance = d3;
        if (Precision.equals(d, d2, 0) || d2 - d >= Math.PI * 2) {
            this.lower = 0.0;
            this.upper = Math.PI * 2;
            this.middle = Math.PI;
        } else if (d <= d2) {
            this.lower = MathUtils.normalizeAngle(d, Math.PI);
            this.upper = this.lower + (d2 - d);
            this.middle = 0.5 * (this.lower + this.upper);
        } else {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)d, d2, true);
        }
    }

    public double getInf() {
        return this.lower;
    }

    public double getSup() {
        return this.upper;
    }

    public double getSize() {
        return this.upper - this.lower;
    }

    public double getBarycenter() {
        return this.middle;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public Region.Location checkPoint(double d) {
        double d2 = MathUtils.normalizeAngle(d, this.middle);
        if (d2 < this.lower - this.tolerance || d2 > this.upper + this.tolerance) {
            return Region.Location.OUTSIDE;
        }
        if (d2 > this.lower + this.tolerance && d2 < this.upper - this.tolerance) {
            return Region.Location.INSIDE;
        }
        return this.getSize() >= Math.PI * 2 - this.tolerance ? Region.Location.INSIDE : Region.Location.BOUNDARY;
    }
}

