/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.spherical.oned;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.partitioning.AbstractRegion;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import org.apache.commons.math3.geometry.partitioning.Side;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.geometry.spherical.oned.Arc;
import org.apache.commons.math3.geometry.spherical.oned.LimitAngle;
import org.apache.commons.math3.geometry.spherical.oned.S1Point;
import org.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import org.apache.commons.math3.geometry.spherical.oned.SubLimitAngle;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcsSet
extends AbstractRegion<Sphere1D, Sphere1D>
implements Iterable<double[]> {
    public ArcsSet(double d) {
        super(d);
    }

    public ArcsSet(double d, double d2, double d3) {
        super(ArcsSet.buildTree(d, d2, d3), d3);
    }

    public ArcsSet(BSPTree<Sphere1D> bSPTree, double d) {
        super(bSPTree, d);
        this.check2PiConsistency();
    }

    public ArcsSet(Collection<SubHyperplane<Sphere1D>> collection, double d) {
        super(collection, d);
        this.check2PiConsistency();
    }

    private static BSPTree<Sphere1D> buildTree(double d, double d2, double d3) {
        if (Precision.equals(d, d2, 0) || d2 - d >= Math.PI * 2) {
            return new BSPTree<Sphere1D>(Boolean.TRUE);
        }
        if (d > d2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)d, d2, true);
        }
        double d4 = MathUtils.normalizeAngle(d, Math.PI);
        double d5 = d4 + (d2 - d);
        SubLimitAngle subLimitAngle = new LimitAngle(new S1Point(d4), false, d3).wholeHyperplane();
        if (d5 <= Math.PI * 2) {
            SubLimitAngle subLimitAngle2 = new LimitAngle(new S1Point(d5), true, d3).wholeHyperplane();
            return new BSPTree<Sphere1D>(subLimitAngle, new BSPTree(Boolean.FALSE), new BSPTree<Sphere1D>(subLimitAngle2, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null), null);
        }
        SubLimitAngle subLimitAngle3 = new LimitAngle(new S1Point(d5 - Math.PI * 2), true, d3).wholeHyperplane();
        return new BSPTree<Sphere1D>(subLimitAngle, new BSPTree<Sphere1D>(subLimitAngle3, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null), new BSPTree(Boolean.TRUE), null);
    }

    private void check2PiConsistency() {
        BSPTree<Sphere1D> bSPTree = this.getTree(false);
        if (bSPTree.getCut() == null) {
            return;
        }
        Boolean bl = (Boolean)this.getFirstLeaf(bSPTree).getAttribute();
        Boolean bl2 = (Boolean)this.getLastLeaf(bSPTree).getAttribute();
        if (bl ^ bl2) {
            throw new InconsistentStateAt2PiWrapping();
        }
    }

    private BSPTree<Sphere1D> getFirstLeaf(BSPTree<Sphere1D> bSPTree) {
        if (bSPTree.getCut() == null) {
            return bSPTree;
        }
        BSPTree<Sphere1D> bSPTree2 = null;
        BSPTree<Sphere1D> bSPTree3 = bSPTree;
        while (bSPTree3 != null) {
            bSPTree2 = bSPTree3;
            bSPTree3 = this.previousInternalNode(bSPTree3);
        }
        return this.leafBefore(bSPTree2);
    }

    private BSPTree<Sphere1D> getLastLeaf(BSPTree<Sphere1D> bSPTree) {
        if (bSPTree.getCut() == null) {
            return bSPTree;
        }
        BSPTree<Sphere1D> bSPTree2 = null;
        BSPTree<Sphere1D> bSPTree3 = bSPTree;
        while (bSPTree3 != null) {
            bSPTree2 = bSPTree3;
            bSPTree3 = this.nextInternalNode(bSPTree3);
        }
        return this.leafAfter(bSPTree2);
    }

    private BSPTree<Sphere1D> getFirstArcStart() {
        BSPTree<Sphere1D> bSPTree = this.getTree(false);
        if (bSPTree.getCut() == null) {
            return null;
        }
        bSPTree = this.getFirstLeaf(bSPTree).getParent();
        while (bSPTree != null && !this.isArcStart(bSPTree)) {
            bSPTree = this.nextInternalNode(bSPTree);
        }
        return bSPTree;
    }

    private boolean isArcStart(BSPTree<Sphere1D> bSPTree) {
        if (((Boolean)this.leafBefore(bSPTree).getAttribute()).booleanValue()) {
            return false;
        }
        return (Boolean)this.leafAfter(bSPTree).getAttribute() != false;
    }

    private boolean isArcEnd(BSPTree<Sphere1D> bSPTree) {
        if (!((Boolean)this.leafBefore(bSPTree).getAttribute()).booleanValue()) {
            return false;
        }
        return (Boolean)this.leafAfter(bSPTree).getAttribute() == false;
    }

    private BSPTree<Sphere1D> nextInternalNode(BSPTree<Sphere1D> bSPTree) {
        if (this.childAfter(bSPTree).getCut() != null) {
            return this.leafAfter(bSPTree).getParent();
        }
        while (this.isAfterParent(bSPTree)) {
            bSPTree = bSPTree.getParent();
        }
        return bSPTree.getParent();
    }

    private BSPTree<Sphere1D> previousInternalNode(BSPTree<Sphere1D> bSPTree) {
        if (this.childBefore(bSPTree).getCut() != null) {
            return this.leafBefore(bSPTree).getParent();
        }
        while (this.isBeforeParent(bSPTree)) {
            bSPTree = bSPTree.getParent();
        }
        return bSPTree.getParent();
    }

    private BSPTree<Sphere1D> leafBefore(BSPTree<Sphere1D> bSPTree) {
        bSPTree = this.childBefore(bSPTree);
        while (bSPTree.getCut() != null) {
            bSPTree = this.childAfter(bSPTree);
        }
        return bSPTree;
    }

    private BSPTree<Sphere1D> leafAfter(BSPTree<Sphere1D> bSPTree) {
        bSPTree = this.childAfter(bSPTree);
        while (bSPTree.getCut() != null) {
            bSPTree = this.childBefore(bSPTree);
        }
        return bSPTree;
    }

    private boolean isBeforeParent(BSPTree<Sphere1D> bSPTree) {
        BSPTree<Sphere1D> bSPTree2 = bSPTree.getParent();
        if (bSPTree2 == null) {
            return false;
        }
        return bSPTree == this.childBefore(bSPTree2);
    }

    private boolean isAfterParent(BSPTree<Sphere1D> bSPTree) {
        BSPTree<Sphere1D> bSPTree2 = bSPTree.getParent();
        if (bSPTree2 == null) {
            return false;
        }
        return bSPTree == this.childAfter(bSPTree2);
    }

    private BSPTree<Sphere1D> childBefore(BSPTree<Sphere1D> bSPTree) {
        if (this.isDirect(bSPTree)) {
            return bSPTree.getMinus();
        }
        return bSPTree.getPlus();
    }

    private BSPTree<Sphere1D> childAfter(BSPTree<Sphere1D> bSPTree) {
        if (this.isDirect(bSPTree)) {
            return bSPTree.getPlus();
        }
        return bSPTree.getMinus();
    }

    private boolean isDirect(BSPTree<Sphere1D> bSPTree) {
        return ((LimitAngle)bSPTree.getCut().getHyperplane()).isDirect();
    }

    private double getAngle(BSPTree<Sphere1D> bSPTree) {
        return ((LimitAngle)bSPTree.getCut().getHyperplane()).getLocation().getAlpha();
    }

    public ArcsSet buildNew(BSPTree<Sphere1D> bSPTree) {
        return new ArcsSet(bSPTree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        if (this.getTree(false).getCut() == null) {
            this.setBarycenter(S1Point.NaN);
            this.setSize((Boolean)this.getTree(false).getAttribute() != false ? Math.PI * 2 : 0.0);
        } else {
            double d = 0.0;
            double d2 = 0.0;
            for (double[] dArray : this) {
                double d3 = dArray[1] - dArray[0];
                d += d3;
                d2 += d3 * (dArray[0] + dArray[1]);
            }
            this.setSize(d);
            if (Precision.equals(d, Math.PI * 2, 0)) {
                this.setBarycenter(S1Point.NaN);
            } else if (d >= Precision.SAFE_MIN) {
                this.setBarycenter(new S1Point(d2 / (2.0 * d)));
            } else {
                LimitAngle limitAngle = (LimitAngle)this.getTree(false).getCut().getHyperplane();
                this.setBarycenter(limitAngle.getLocation());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BoundaryProjection<Sphere1D> projectToBoundary(Point<Sphere1D> point) {
        double d = ((S1Point)point).getAlpha();
        boolean bl = false;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        for (double[] dArray : this) {
            block13: {
                if (Double.isNaN(d2)) {
                    d2 = dArray[0];
                }
                if (!bl) {
                    if (d < dArray[0]) {
                        if (Double.isNaN(d3)) {
                            bl = true;
                            break block13;
                        } else {
                            double d4 = d - d3;
                            double d5 = dArray[0] - d;
                            if (d4 < d5) {
                                return new BoundaryProjection<Sphere1D>(point, new S1Point(d3), d4);
                            }
                            return new BoundaryProjection<Sphere1D>(point, new S1Point(dArray[0]), d5);
                        }
                    }
                    if (d <= dArray[1]) {
                        double d6 = dArray[0] - d;
                        double d7 = d - dArray[1];
                        if (d6 < d7) {
                            return new BoundaryProjection<Sphere1D>(point, new S1Point(dArray[1]), d7);
                        }
                        return new BoundaryProjection<Sphere1D>(point, new S1Point(dArray[0]), d6);
                    }
                }
            }
            d3 = dArray[1];
        }
        if (Double.isNaN(d3)) {
            return new BoundaryProjection<Sphere1D>(point, null, Math.PI * 2);
        }
        if (bl) {
            double d8 = d - (d3 - Math.PI * 2);
            double d9 = d2 - d;
            if (d8 < d9) {
                return new BoundaryProjection<Sphere1D>(point, new S1Point(d3), d8);
            }
            return new BoundaryProjection<Sphere1D>(point, new S1Point(d2), d9);
        }
        double d10 = d - d3;
        double d11 = d2 + Math.PI * 2 - d;
        if (d10 < d11) {
            return new BoundaryProjection<Sphere1D>(point, new S1Point(d3), d10);
        }
        return new BoundaryProjection<Sphere1D>(point, new S1Point(d2), d11);
    }

    public List<Arc> asList() {
        ArrayList<Arc> arrayList = new ArrayList<Arc>();
        for (double[] dArray : this) {
            arrayList.add(new Arc(dArray[0], dArray[1], this.getTolerance()));
        }
        return arrayList;
    }

    @Override
    public Iterator<double[]> iterator() {
        return new SubArcsIterator();
    }

    @Deprecated
    public Side side(Arc arc) {
        return this.split(arc).getSide();
    }

    public Split split(Arc arc) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        double d = Math.PI + arc.getInf();
        double d2 = arc.getSup() - arc.getInf();
        for (double[] dArray : this) {
            double d3;
            double d4;
            double d5 = MathUtils.normalizeAngle(dArray[0], d) - arc.getInf();
            double d6 = dArray[0] - d5;
            double d7 = dArray[1] - d6;
            if (d5 < d2) {
                arrayList.add(dArray[0]);
                if (d7 > d2) {
                    d4 = d2 + d6;
                    arrayList.add(d4);
                    arrayList2.add(d4);
                    if (d7 > Math.PI * 2) {
                        d3 = Math.PI * 2 + d6;
                        arrayList2.add(d3);
                        arrayList.add(d3);
                        arrayList.add(dArray[1]);
                        continue;
                    }
                    arrayList2.add(dArray[1]);
                    continue;
                }
                arrayList.add(dArray[1]);
                continue;
            }
            arrayList2.add(dArray[0]);
            if (d7 > Math.PI * 2) {
                d4 = Math.PI * 2 + d6;
                arrayList2.add(d4);
                arrayList.add(d4);
                if (d7 > Math.PI * 2 + d2) {
                    d3 = Math.PI * 2 + d2 + d6;
                    arrayList.add(d3);
                    arrayList2.add(d3);
                    arrayList2.add(dArray[1]);
                    continue;
                }
                arrayList.add(dArray[1]);
                continue;
            }
            arrayList2.add(dArray[1]);
        }
        return new Split(this.createSplitPart(arrayList2), this.createSplitPart(arrayList));
    }

    private void addArcLimit(BSPTree<Sphere1D> bSPTree, double d, boolean bl) {
        LimitAngle limitAngle = new LimitAngle(new S1Point(d), !bl, this.getTolerance());
        BSPTree<Sphere1D> bSPTree2 = bSPTree.getCell(limitAngle.getLocation(), this.getTolerance());
        if (bSPTree2.getCut() != null) {
            throw new MathInternalError();
        }
        bSPTree2.insertCut(limitAngle);
        bSPTree2.setAttribute(null);
        bSPTree2.getPlus().setAttribute(Boolean.FALSE);
        bSPTree2.getMinus().setAttribute(Boolean.TRUE);
    }

    private ArcsSet createSplitPart(List<Double> list) {
        int n;
        if (list.isEmpty()) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            n = (i + 1) % list.size();
            double d = list.get(i);
            double d2 = MathUtils.normalizeAngle(list.get(n), d);
            if (!(FastMath.abs(d2 - d) <= this.getTolerance())) continue;
            if (n > 0) {
                list.remove(n);
                list.remove(i);
                --i;
                continue;
            }
            double d3 = list.remove(list.size() - 1);
            double d4 = list.remove(0);
            if (list.isEmpty()) {
                if (d3 - d4 > Math.PI) {
                    return new ArcsSet(new BSPTree<Sphere1D>(Boolean.TRUE), this.getTolerance());
                }
                return null;
            }
            list.add(list.remove(0) + Math.PI * 2);
        }
        BSPTree<Sphere1D> bSPTree = new BSPTree<Sphere1D>(Boolean.FALSE);
        for (n = 0; n < list.size() - 1; n += 2) {
            this.addArcLimit(bSPTree, list.get(n), true);
            this.addArcLimit(bSPTree, list.get(n + 1), false);
        }
        if (bSPTree.getCut() == null) {
            return null;
        }
        return new ArcsSet(bSPTree, this.getTolerance());
    }

    public static class InconsistentStateAt2PiWrapping
    extends MathIllegalArgumentException {
        private static final long serialVersionUID = 20140107L;

        public InconsistentStateAt2PiWrapping() {
            super(LocalizedFormats.INCONSISTENT_STATE_AT_2_PI_WRAPPING, new Object[0]);
        }
    }

    public static class Split {
        private final ArcsSet plus;
        private final ArcsSet minus;

        private Split(ArcsSet arcsSet, ArcsSet arcsSet2) {
            this.plus = arcsSet;
            this.minus = arcsSet2;
        }

        public ArcsSet getPlus() {
            return this.plus;
        }

        public ArcsSet getMinus() {
            return this.minus;
        }

        public Side getSide() {
            if (this.plus != null) {
                if (this.minus != null) {
                    return Side.BOTH;
                }
                return Side.PLUS;
            }
            if (this.minus != null) {
                return Side.MINUS;
            }
            return Side.HYPER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubArcsIterator
    implements Iterator<double[]> {
        private final BSPTree<Sphere1D> firstStart;
        private BSPTree<Sphere1D> current;
        private double[] pending;

        SubArcsIterator() {
            this.firstStart = ArcsSet.this.getFirstArcStart();
            this.current = this.firstStart;
            if (this.firstStart == null) {
                this.pending = (double[])(((Boolean)ArcsSet.this.getFirstLeaf(ArcsSet.this.getTree(false)).getAttribute()).booleanValue() ? new double[]{0.0, Math.PI * 2} : null);
            } else {
                this.selectPending();
            }
        }

        private void selectPending() {
            BSPTree bSPTree = this.current;
            while (bSPTree != null && !ArcsSet.this.isArcStart(bSPTree)) {
                bSPTree = ArcsSet.this.nextInternalNode(bSPTree);
            }
            if (bSPTree == null) {
                this.current = null;
                this.pending = null;
                return;
            }
            BSPTree bSPTree2 = bSPTree;
            while (bSPTree2 != null && !ArcsSet.this.isArcEnd(bSPTree2)) {
                bSPTree2 = ArcsSet.this.nextInternalNode(bSPTree2);
            }
            if (bSPTree2 != null) {
                this.pending = new double[]{ArcsSet.this.getAngle(bSPTree), ArcsSet.this.getAngle(bSPTree2)};
                this.current = bSPTree2;
            } else {
                bSPTree2 = this.firstStart;
                while (bSPTree2 != null && !ArcsSet.this.isArcEnd(bSPTree2)) {
                    bSPTree2 = ArcsSet.this.previousInternalNode(bSPTree2);
                }
                if (bSPTree2 == null) {
                    throw new MathInternalError();
                }
                this.pending = new double[]{ArcsSet.this.getAngle(bSPTree), ArcsSet.this.getAngle(bSPTree2) + Math.PI * 2};
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pending != null;
        }

        @Override
        public double[] next() {
            if (this.pending == null) {
                throw new NoSuchElementException();
            }
            double[] dArray = this.pending;
            this.selectPending();
            return dArray;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

