/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.spherical.twod;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math3.geometry.spherical.oned.Arc;
import org.apache.commons.math3.geometry.spherical.oned.ArcsSet;
import org.apache.commons.math3.geometry.spherical.oned.S1Point;
import org.apache.commons.math3.geometry.spherical.twod.Circle;
import org.apache.commons.math3.geometry.spherical.twod.Edge;
import org.apache.commons.math3.geometry.spherical.twod.S2Point;
import org.apache.commons.math3.geometry.spherical.twod.Sphere2D;
import org.apache.commons.math3.geometry.spherical.twod.SubCircle;
import org.apache.commons.math3.geometry.spherical.twod.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EdgesBuilder
implements BSPTreeVisitor<Sphere2D> {
    private final BSPTree<Sphere2D> root;
    private final double tolerance;
    private final Map<Edge, BSPTree<Sphere2D>> edgeToNode;
    private final Map<BSPTree<Sphere2D>, List<Edge>> nodeToEdgesList;

    EdgesBuilder(BSPTree<Sphere2D> bSPTree, double d) {
        this.root = bSPTree;
        this.tolerance = d;
        this.edgeToNode = new IdentityHashMap<Edge, BSPTree<Sphere2D>>();
        this.nodeToEdgesList = new IdentityHashMap<BSPTree<Sphere2D>, List<Edge>>();
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<Sphere2D> bSPTree) {
        return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
    }

    @Override
    public void visitInternalNode(BSPTree<Sphere2D> bSPTree) {
        this.nodeToEdgesList.put(bSPTree, new ArrayList());
        BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
        if (boundaryAttribute.getPlusOutside() != null) {
            this.addContribution((SubCircle)boundaryAttribute.getPlusOutside(), false, bSPTree);
        }
        if (boundaryAttribute.getPlusInside() != null) {
            this.addContribution((SubCircle)boundaryAttribute.getPlusInside(), true, bSPTree);
        }
    }

    @Override
    public void visitLeafNode(BSPTree<Sphere2D> bSPTree) {
    }

    private void addContribution(SubCircle subCircle, boolean bl, BSPTree<Sphere2D> bSPTree) {
        Circle circle = (Circle)subCircle.getHyperplane();
        List<Arc> list = ((ArcsSet)subCircle.getRemainingRegion()).asList();
        for (Arc arc : list) {
            Vertex vertex = new Vertex((S2Point)circle.toSpace((Point)new S1Point(arc.getInf())));
            Vertex vertex2 = new Vertex((S2Point)circle.toSpace((Point)new S1Point(arc.getSup())));
            vertex.bindWith(circle);
            vertex2.bindWith(circle);
            Edge edge = bl ? new Edge(vertex2, vertex, arc.getSize(), circle.getReverse()) : new Edge(vertex, vertex2, arc.getSize(), circle);
            this.edgeToNode.put(edge, bSPTree);
            this.nodeToEdgesList.get(bSPTree).add(edge);
        }
    }

    private Edge getFollowingEdge(Edge edge) {
        S2Point s2Point = edge.getEnd().getLocation();
        List<BSPTree<Sphere2D>> list = this.root.getCloseCuts(s2Point, this.tolerance);
        double d = this.tolerance;
        Edge edge2 = null;
        for (BSPTree<Sphere2D> bSPTree : list) {
            for (Edge edge3 : this.nodeToEdgesList.get(bSPTree)) {
                if (edge3 == edge || edge3.getStart().getIncoming() != null) continue;
                Vector3D vector3D = edge3.getStart().getLocation().getVector();
                double d2 = Vector3D.angle(s2Point.getVector(), vector3D);
                if (!(d2 <= d)) continue;
                d = d2;
                edge2 = edge3;
            }
        }
        if (edge2 == null) {
            Vector3D vector3D = edge.getStart().getLocation().getVector();
            if (Vector3D.angle(s2Point.getVector(), vector3D) <= this.tolerance) {
                return edge;
            }
            throw new MathIllegalStateException(LocalizedFormats.OUTLINE_BOUNDARY_LOOP_OPEN, new Object[0]);
        }
        return edge2;
    }

    public List<Edge> getEdges() {
        for (Edge edge : this.edgeToNode.keySet()) {
            edge.setNextEdge(this.getFollowingEdge(edge));
        }
        return new ArrayList<Edge>(this.edgeToNode.keySet());
    }
}

