/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.spherical.twod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.enclosing.EnclosingBall;
import org.apache.commons.math3.geometry.enclosing.WelzlEncloser;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.SphereGenerator;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.partitioning.AbstractRegion;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import org.apache.commons.math3.geometry.partitioning.RegionFactory;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import org.apache.commons.math3.geometry.spherical.twod.Circle;
import org.apache.commons.math3.geometry.spherical.twod.Edge;
import org.apache.commons.math3.geometry.spherical.twod.EdgesBuilder;
import org.apache.commons.math3.geometry.spherical.twod.PropertiesComputer;
import org.apache.commons.math3.geometry.spherical.twod.S2Point;
import org.apache.commons.math3.geometry.spherical.twod.Sphere2D;
import org.apache.commons.math3.geometry.spherical.twod.Vertex;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SphericalPolygonsSet
extends AbstractRegion<Sphere2D, Sphere1D> {
    private List<Vertex> loops;

    public SphericalPolygonsSet(double d) {
        super(d);
    }

    public SphericalPolygonsSet(Vector3D vector3D, double d) {
        super(new BSPTree<Sphere2D>(new Circle(vector3D, d).wholeHyperplane(), new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null), d);
    }

    public SphericalPolygonsSet(Vector3D vector3D, Vector3D vector3D2, double d, int n, double d2) {
        this(d2, SphericalPolygonsSet.createRegularPolygonVertices(vector3D, vector3D2, d, n));
    }

    public SphericalPolygonsSet(BSPTree<Sphere2D> bSPTree, double d) {
        super(bSPTree, d);
    }

    public SphericalPolygonsSet(Collection<SubHyperplane<Sphere2D>> collection, double d) {
        super(collection, d);
    }

    public SphericalPolygonsSet(double d, S2Point ... s2PointArray) {
        super(SphericalPolygonsSet.verticesToTree(d, s2PointArray), d);
    }

    private static S2Point[] createRegularPolygonVertices(Vector3D vector3D, Vector3D vector3D2, double d, int n) {
        S2Point[] s2PointArray = new S2Point[n];
        Rotation rotation = new Rotation(Vector3D.crossProduct(vector3D, vector3D2), d, RotationConvention.VECTOR_OPERATOR);
        s2PointArray[0] = new S2Point(rotation.applyTo(vector3D));
        Rotation rotation2 = new Rotation(vector3D, Math.PI * 2 / (double)n, RotationConvention.VECTOR_OPERATOR);
        for (int i = 1; i < n; ++i) {
            s2PointArray[i] = new S2Point(rotation2.applyTo(s2PointArray[i - 1].getVector()));
        }
        return s2PointArray;
    }

    private static BSPTree<Sphere2D> verticesToTree(double d, S2Point ... s2PointArray) {
        int n = s2PointArray.length;
        if (n == 0) {
            return new BSPTree<Sphere2D>(Boolean.TRUE);
        }
        Vertex[] vertexArray = new Vertex[n];
        for (int i = 0; i < n; ++i) {
            vertexArray[i] = new Vertex(s2PointArray[i]);
        }
        ArrayList<Edge> arrayList = new ArrayList<Edge>(n);
        Vertex vertex = vertexArray[n - 1];
        for (int i = 0; i < n; ++i) {
            Vertex vertex2 = vertex;
            Circle circle = vertex2.sharedCircleWith(vertex = vertexArray[i]);
            if (circle == null) {
                circle = new Circle(vertex2.getLocation(), vertex.getLocation(), d);
            }
            arrayList.add(new Edge(vertex2, vertex, Vector3D.angle(vertex2.getLocation().getVector(), vertex.getLocation().getVector()), circle));
            for (Vertex vertex3 : vertexArray) {
                if (vertex3 == vertex2 || vertex3 == vertex || !(FastMath.abs(circle.getOffset(vertex3.getLocation())) <= d)) continue;
                vertex3.bindWith(circle);
            }
        }
        BSPTree<Sphere2D> bSPTree = new BSPTree<Sphere2D>();
        SphericalPolygonsSet.insertEdges(d, bSPTree, arrayList);
        return bSPTree;
    }

    private static void insertEdges(double d, BSPTree<Sphere2D> bSPTree, List<Edge> list) {
        int n = 0;
        Edge edge = null;
        while (edge == null && n < list.size()) {
            if (bSPTree.insertCut((edge = list.get(n++)).getCircle())) continue;
            edge = null;
        }
        if (edge == null) {
            BSPTree<Sphere2D> bSPTree2 = bSPTree.getParent();
            if (bSPTree2 == null || bSPTree == bSPTree2.getMinus()) {
                bSPTree.setAttribute(Boolean.TRUE);
            } else {
                bSPTree.setAttribute(Boolean.FALSE);
            }
            return;
        }
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
        for (Edge edge2 : list) {
            if (edge2 == edge) continue;
            edge2.split(edge.getCircle(), arrayList, arrayList2);
        }
        if (!arrayList.isEmpty()) {
            SphericalPolygonsSet.insertEdges(d, bSPTree.getPlus(), arrayList);
        } else {
            bSPTree.getPlus().setAttribute(Boolean.FALSE);
        }
        if (!arrayList2.isEmpty()) {
            SphericalPolygonsSet.insertEdges(d, bSPTree.getMinus(), arrayList2);
        } else {
            bSPTree.getMinus().setAttribute(Boolean.TRUE);
        }
    }

    public SphericalPolygonsSet buildNew(BSPTree<Sphere2D> bSPTree) {
        return new SphericalPolygonsSet(bSPTree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        BSPTree<Sphere2D> bSPTree = this.getTree(true);
        if (bSPTree.getCut() == null) {
            if (bSPTree.getCut() == null && ((Boolean)bSPTree.getAttribute()).booleanValue()) {
                this.setSize(Math.PI * 4);
                this.setBarycenter(new S2Point(0.0, 0.0));
            } else {
                this.setSize(0.0);
                this.setBarycenter(S2Point.NaN);
            }
        } else {
            PropertiesComputer propertiesComputer = new PropertiesComputer(this.getTolerance());
            bSPTree.visit(propertiesComputer);
            this.setSize(propertiesComputer.getArea());
            this.setBarycenter(propertiesComputer.getBarycenter());
        }
    }

    public List<Vertex> getBoundaryLoops() {
        if (this.loops == null) {
            if (this.getTree(false).getCut() == null) {
                this.loops = Collections.emptyList();
            } else {
                BSPTree<Sphere2D> bSPTree = this.getTree(true);
                EdgesBuilder edgesBuilder = new EdgesBuilder(bSPTree, this.getTolerance());
                bSPTree.visit(edgesBuilder);
                List<Edge> list = edgesBuilder.getEdges();
                this.loops = new ArrayList<Vertex>();
                while (!list.isEmpty()) {
                    Edge edge = list.get(0);
                    Vertex vertex = edge.getStart();
                    this.loops.add(vertex);
                    block1: do {
                        Iterator<Edge> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            if (iterator.next() != edge) continue;
                            iterator.remove();
                            continue block1;
                        }
                    } while ((edge = edge.getEnd().getOutgoing()).getStart() != vertex);
                }
            }
        }
        return Collections.unmodifiableList(this.loops);
    }

    public EnclosingBall<Sphere2D, S2Point> getEnclosingCap() {
        Object object;
        if (this.isEmpty()) {
            return new EnclosingBall((Point)S2Point.PLUS_K, Double.NEGATIVE_INFINITY, (Point[])new S2Point[0]);
        }
        if (this.isFull()) {
            return new EnclosingBall((Point)S2Point.PLUS_K, Double.POSITIVE_INFINITY, (Point[])new S2Point[0]);
        }
        BSPTree bSPTree = this.getTree(false);
        if (this.isEmpty(bSPTree.getMinus()) && this.isFull(bSPTree.getPlus())) {
            Circle circle = (Circle)bSPTree.getCut().getHyperplane();
            return new EnclosingBall((Point)new S2Point(circle.getPole()).negate(), 1.5707963267948966, (Point[])new S2Point[0]);
        }
        if (this.isFull(bSPTree.getMinus()) && this.isEmpty(bSPTree.getPlus())) {
            Circle circle = (Circle)bSPTree.getCut().getHyperplane();
            return new EnclosingBall((Point)new S2Point(circle.getPole()), 1.5707963267948966, (Point[])new S2Point[0]);
        }
        List<Vector3D> list = this.getInsidePoints();
        List<Vertex> list2 = this.getBoundaryLoops();
        for (Vector3D[] object22 : list2) {
            object = object22;
            for (int enclosingBall = 0; enclosingBall == 0 || object != object22; ++enclosingBall) {
                list.add(object.getLocation().getVector());
                object = object.getOutgoing().getEnd();
            }
        }
        SphereGenerator sphereGenerator = new SphereGenerator();
        WelzlEncloser welzlEncloser = new WelzlEncloser(this.getTolerance(), sphereGenerator);
        EnclosingBall enclosingBall = welzlEncloser.enclose(list);
        object = (Vector3D[])enclosingBall.getSupport();
        double d = enclosingBall.getRadius();
        double d2 = enclosingBall.getCenter().getNorm();
        if (d2 < this.getTolerance()) {
            EnclosingBall pointArray = new EnclosingBall((Point)S2Point.PLUS_K, Double.POSITIVE_INFINITY, (Point[])new S2Point[0]);
            for (Vector3D vector3D : this.getOutsidePoints()) {
                S2Point s2Point = new S2Point(vector3D);
                BoundaryProjection<Sphere2D> boundaryProjection = this.projectToBoundary(s2Point);
                if (!(Math.PI - boundaryProjection.getOffset() < pointArray.getRadius())) continue;
                pointArray = new EnclosingBall((Point)s2Point.negate(), Math.PI - boundaryProjection.getOffset(), (Point[])new S2Point[]{(S2Point)boundaryProjection.getProjected()});
            }
            return pointArray;
        }
        Point[] pointArray = new S2Point[((Vector3D[])object).length];
        for (int enclosingBall3 = 0; enclosingBall3 < ((Vector3D[])object).length; ++enclosingBall3) {
            pointArray[enclosingBall3] = new S2Point(object[enclosingBall3]);
        }
        EnclosingBall enclosingBall2 = new EnclosingBall((Point)new S2Point(enclosingBall.getCenter()), FastMath.acos((1.0 + d2 * d2 - d * d) / (2.0 * d2)), pointArray);
        return enclosingBall2;
    }

    private List<Vector3D> getInsidePoints() {
        PropertiesComputer propertiesComputer = new PropertiesComputer(this.getTolerance());
        this.getTree(true).visit(propertiesComputer);
        return propertiesComputer.getConvexCellsInsidePoints();
    }

    private List<Vector3D> getOutsidePoints() {
        SphericalPolygonsSet sphericalPolygonsSet = (SphericalPolygonsSet)new RegionFactory<Sphere2D>().getComplement(this);
        PropertiesComputer propertiesComputer = new PropertiesComputer(this.getTolerance());
        sphericalPolygonsSet.getTree(true).visit(propertiesComputer);
        return propertiesComputer.getConvexCellsInsidePoints();
    }
}

