/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.spherical.twod;

import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.geometry.spherical.oned.Arc;
import org.apache.commons.math3.geometry.spherical.oned.ArcsSet;
import org.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import org.apache.commons.math3.geometry.spherical.twod.Circle;
import org.apache.commons.math3.geometry.spherical.twod.Sphere2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubCircle
extends AbstractSubHyperplane<Sphere2D, Sphere1D> {
    public SubCircle(Hyperplane<Sphere2D> hyperplane, Region<Sphere1D> region) {
        super(hyperplane, region);
    }

    @Override
    protected AbstractSubHyperplane<Sphere2D, Sphere1D> buildNew(Hyperplane<Sphere2D> hyperplane, Region<Sphere1D> region) {
        return new SubCircle(hyperplane, region);
    }

    @Override
    public SubHyperplane.SplitSubHyperplane<Sphere2D> split(Hyperplane<Sphere2D> hyperplane) {
        Circle circle = (Circle)this.getHyperplane();
        Circle circle2 = (Circle)hyperplane;
        double d = Vector3D.angle(circle.getPole(), circle2.getPole());
        if (d < circle.getTolerance() || d > Math.PI - circle.getTolerance()) {
            return new SubHyperplane.SplitSubHyperplane<Sphere2D>(null, null);
        }
        Arc arc = circle.getInsideArc(circle2);
        ArcsSet.Split split = ((ArcsSet)this.getRemainingRegion()).split(arc);
        ArcsSet arcsSet = split.getPlus();
        ArcsSet arcsSet2 = split.getMinus();
        return new SubHyperplane.SplitSubHyperplane<Sphere2D>(arcsSet == null ? null : new SubCircle(circle.copySelf(), arcsSet), arcsSet2 == null ? null : new SubCircle(circle.copySelf(), arcsSet2));
    }
}

