/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.spherical.twod;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.geometry.spherical.twod.Circle;
import org.apache.commons.math3.geometry.spherical.twod.Edge;
import org.apache.commons.math3.geometry.spherical.twod.S2Point;

public class Vertex {
    private final S2Point location;
    private Edge incoming;
    private Edge outgoing;
    private final List<Circle> circles;

    Vertex(S2Point s2Point) {
        this.location = s2Point;
        this.incoming = null;
        this.outgoing = null;
        this.circles = new ArrayList<Circle>();
    }

    public S2Point getLocation() {
        return this.location;
    }

    void bindWith(Circle circle) {
        this.circles.add(circle);
    }

    Circle sharedCircleWith(Vertex vertex) {
        for (Circle circle : this.circles) {
            for (Circle circle2 : vertex.circles) {
                if (circle != circle2) continue;
                return circle;
            }
        }
        return null;
    }

    void setIncoming(Edge edge) {
        this.incoming = edge;
        this.bindWith(edge.getCircle());
    }

    public Edge getIncoming() {
        return this.incoming;
    }

    void setOutgoing(Edge edge) {
        this.outgoing = edge;
        this.bindWith(edge.getCircle());
    }

    public Edge getOutgoing() {
        return this.outgoing;
    }
}

