/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealMatrixFormat;
import org.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public abstract class AbstractRealMatrix
extends RealLinearOperator
implements RealMatrix {
    private static final RealMatrixFormat DEFAULT_FORMAT = RealMatrixFormat.getInstance(Locale.US);

    protected AbstractRealMatrix() {
    }

    protected AbstractRealMatrix(int n, int n2) {
        if (n < 1) {
            throw new NotStrictlyPositiveException(n);
        }
        if (n2 < 1) {
            throw new NotStrictlyPositiveException(n2);
        }
    }

    public RealMatrix add(RealMatrix realMatrix) {
        MatrixUtils.checkAdditionCompatible(this, realMatrix);
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        RealMatrix realMatrix2 = this.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                realMatrix2.setEntry(i, j, this.getEntry(i, j) + realMatrix.getEntry(i, j));
            }
        }
        return realMatrix2;
    }

    public RealMatrix subtract(RealMatrix realMatrix) {
        MatrixUtils.checkSubtractionCompatible(this, realMatrix);
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        RealMatrix realMatrix2 = this.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                realMatrix2.setEntry(i, j, this.getEntry(i, j) - realMatrix.getEntry(i, j));
            }
        }
        return realMatrix2;
    }

    public RealMatrix scalarAdd(double d) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        RealMatrix realMatrix = this.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                realMatrix.setEntry(i, j, this.getEntry(i, j) + d);
            }
        }
        return realMatrix;
    }

    public RealMatrix scalarMultiply(double d) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        RealMatrix realMatrix = this.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                realMatrix.setEntry(i, j, this.getEntry(i, j) * d);
            }
        }
        return realMatrix;
    }

    public RealMatrix multiply(RealMatrix realMatrix) {
        MatrixUtils.checkMultiplicationCompatible(this, realMatrix);
        int n = this.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        int n3 = this.getColumnDimension();
        RealMatrix realMatrix2 = this.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = 0.0;
                for (int k = 0; k < n3; ++k) {
                    d += this.getEntry(i, k) * realMatrix.getEntry(k, j);
                }
                realMatrix2.setEntry(i, j, d);
            }
        }
        return realMatrix2;
    }

    public RealMatrix preMultiply(RealMatrix realMatrix) {
        return realMatrix.multiply(this);
    }

    public RealMatrix power(int n) {
        int n2;
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_EXPONENT, n);
        }
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        if (n == 0) {
            return MatrixUtils.createRealIdentityMatrix(this.getRowDimension());
        }
        if (n == 1) {
            return this.copy();
        }
        int n3 = n - 1;
        char[] cArray = Integer.toBinaryString(n3).toCharArray();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = -1;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '1') continue;
            n2 = cArray.length - i - 1;
            arrayList.add(n2);
            if (n4 != -1) continue;
            n4 = n2;
        }
        RealMatrix[] realMatrixArray = new RealMatrix[n4 + 1];
        realMatrixArray[0] = this.copy();
        for (n2 = 1; n2 <= n4; ++n2) {
            realMatrixArray[n2] = realMatrixArray[n2 - 1].multiply(realMatrixArray[n2 - 1]);
        }
        RealMatrix realMatrix = this.copy();
        for (Integer n5 : arrayList) {
            realMatrix = realMatrix.multiply(realMatrixArray[n5]);
        }
        return realMatrix;
    }

    public double[][] getData() {
        double[][] dArray = new double[this.getRowDimension()][this.getColumnDimension()];
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < dArray2.length; ++j) {
                dArray2[j] = this.getEntry(i, j);
            }
        }
        return dArray;
    }

    public double getNorm() {
        return this.walkInColumnOrder(new RealMatrixPreservingVisitor(){
            private double endRow;
            private double columnSum;
            private double maxColSum;

            public void start(int n, int n2, int n3, int n4, int n5, int n6) {
                this.endRow = n4;
                this.columnSum = 0.0;
                this.maxColSum = 0.0;
            }

            public void visit(int n, int n2, double d) {
                this.columnSum += FastMath.abs(d);
                if ((double)n == this.endRow) {
                    this.maxColSum = FastMath.max(this.maxColSum, this.columnSum);
                    this.columnSum = 0.0;
                }
            }

            public double end() {
                return this.maxColSum;
            }
        });
    }

    public double getFrobeniusNorm() {
        return this.walkInOptimizedOrder(new RealMatrixPreservingVisitor(){
            private double sum;

            public void start(int n, int n2, int n3, int n4, int n5, int n6) {
                this.sum = 0.0;
            }

            public void visit(int n, int n2, double d) {
                this.sum += d * d;
            }

            public double end() {
                return FastMath.sqrt(this.sum);
            }
        });
    }

    public RealMatrix getSubMatrix(int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        RealMatrix realMatrix = this.createMatrix(n2 - n + 1, n4 - n3 + 1);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                realMatrix.setEntry(i - n, j - n3, this.getEntry(i, j));
            }
        }
        return realMatrix;
    }

    public RealMatrix getSubMatrix(final int[] nArray, final int[] nArray2) {
        MatrixUtils.checkSubMatrixIndex(this, nArray, nArray2);
        RealMatrix realMatrix = this.createMatrix(nArray.length, nArray2.length);
        realMatrix.walkInOptimizedOrder(new DefaultRealMatrixChangingVisitor(){

            public double visit(int n, int n2, double d) {
                return AbstractRealMatrix.this.getEntry(nArray[n], nArray2[n2]);
            }
        });
        return realMatrix;
    }

    public void copySubMatrix(int n, int n2, int n3, int n4, final double[][] dArray) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        int n5 = n2 + 1 - n;
        int n6 = n4 + 1 - n3;
        if (dArray.length < n5 || dArray[0].length < n6) {
            throw new MatrixDimensionMismatchException(dArray.length, dArray[0].length, n5, n6);
        }
        for (int i = 1; i < n5; ++i) {
            if (dArray[i].length >= n6) continue;
            throw new MatrixDimensionMismatchException(dArray.length, dArray[i].length, n5, n6);
        }
        this.walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){
            private int startRow;
            private int startColumn;

            public void start(int n, int n2, int n3, int n4, int n5, int n6) {
                this.startRow = n3;
                this.startColumn = n5;
            }

            public void visit(int n, int n2, double d) {
                dArray[n - this.startRow][n2 - this.startColumn] = d;
            }
        }, n, n2, n3, n4);
    }

    public void copySubMatrix(int[] nArray, int[] nArray2, double[][] dArray) {
        MatrixUtils.checkSubMatrixIndex(this, nArray, nArray2);
        int n = nArray2.length;
        if (dArray.length < nArray.length || dArray[0].length < n) {
            throw new MatrixDimensionMismatchException(dArray.length, dArray[0].length, nArray.length, nArray2.length);
        }
        for (int i = 0; i < nArray.length; ++i) {
            double[] dArray2 = dArray[i];
            if (dArray2.length < n) {
                throw new MatrixDimensionMismatchException(dArray.length, dArray2.length, nArray.length, nArray2.length);
            }
            for (int j = 0; j < nArray2.length; ++j) {
                dArray2[j] = this.getEntry(nArray[i], nArray2[j]);
            }
        }
    }

    public void setSubMatrix(double[][] dArray, int n, int n2) {
        int n3;
        MathUtils.checkNotNull(dArray);
        int n4 = dArray.length;
        if (n4 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        int n5 = dArray[0].length;
        if (n5 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        for (n3 = 1; n3 < n4; ++n3) {
            if (dArray[n3].length == n5) continue;
            throw new DimensionMismatchException(n5, dArray[n3].length);
        }
        MatrixUtils.checkRowIndex(this, n);
        MatrixUtils.checkColumnIndex(this, n2);
        MatrixUtils.checkRowIndex(this, n4 + n - 1);
        MatrixUtils.checkColumnIndex(this, n5 + n2 - 1);
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i = 0; i < n5; ++i) {
                this.setEntry(n + n3, n2 + i, dArray[n3][i]);
            }
        }
    }

    public RealMatrix getRowMatrix(int n) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = this.getColumnDimension();
        RealMatrix realMatrix = this.createMatrix(1, n2);
        for (int i = 0; i < n2; ++i) {
            realMatrix.setEntry(0, i, this.getEntry(n, i));
        }
        return realMatrix;
    }

    public void setRowMatrix(int n, RealMatrix realMatrix) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = this.getColumnDimension();
        if (realMatrix.getRowDimension() != 1 || realMatrix.getColumnDimension() != n2) {
            throw new MatrixDimensionMismatchException(realMatrix.getRowDimension(), realMatrix.getColumnDimension(), 1, n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(n, i, realMatrix.getEntry(0, i));
        }
    }

    public RealMatrix getColumnMatrix(int n) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = this.getRowDimension();
        RealMatrix realMatrix = this.createMatrix(n2, 1);
        for (int i = 0; i < n2; ++i) {
            realMatrix.setEntry(i, 0, this.getEntry(i, n));
        }
        return realMatrix;
    }

    public void setColumnMatrix(int n, RealMatrix realMatrix) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = this.getRowDimension();
        if (realMatrix.getRowDimension() != n2 || realMatrix.getColumnDimension() != 1) {
            throw new MatrixDimensionMismatchException(realMatrix.getRowDimension(), realMatrix.getColumnDimension(), n2, 1);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(i, n, realMatrix.getEntry(i, 0));
        }
    }

    public RealVector getRowVector(int n) {
        return new ArrayRealVector(this.getRow(n), false);
    }

    public void setRowVector(int n, RealVector realVector) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = this.getColumnDimension();
        if (realVector.getDimension() != n2) {
            throw new MatrixDimensionMismatchException(1, realVector.getDimension(), 1, n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(n, i, realVector.getEntry(i));
        }
    }

    public RealVector getColumnVector(int n) {
        return new ArrayRealVector(this.getColumn(n), false);
    }

    public void setColumnVector(int n, RealVector realVector) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = this.getRowDimension();
        if (realVector.getDimension() != n2) {
            throw new MatrixDimensionMismatchException(realVector.getDimension(), 1, n2, 1);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(i, n, realVector.getEntry(i));
        }
    }

    public double[] getRow(int n) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = this.getColumnDimension();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = this.getEntry(n, i);
        }
        return dArray;
    }

    public void setRow(int n, double[] dArray) {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = this.getColumnDimension();
        if (dArray.length != n2) {
            throw new MatrixDimensionMismatchException(1, dArray.length, 1, n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(n, i, dArray[i]);
        }
    }

    public double[] getColumn(int n) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = this.getRowDimension();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = this.getEntry(i, n);
        }
        return dArray;
    }

    public void setColumn(int n, double[] dArray) {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = this.getRowDimension();
        if (dArray.length != n2) {
            throw new MatrixDimensionMismatchException(dArray.length, 1, n2, 1);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(i, n, dArray[i]);
        }
    }

    public void addToEntry(int n, int n2, double d) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        this.setEntry(n, n2, this.getEntry(n, n2) + d);
    }

    public void multiplyEntry(int n, int n2, double d) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        this.setEntry(n, n2, this.getEntry(n, n2) * d);
    }

    public RealMatrix transpose() {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        final RealMatrix realMatrix = this.createMatrix(n2, n);
        this.walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){

            public void visit(int n, int n2, double d) {
                realMatrix.setEntry(n2, n, d);
            }
        });
        return realMatrix;
    }

    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    public abstract int getRowDimension();

    public abstract int getColumnDimension();

    public double getTrace() {
        int n;
        int n2 = this.getRowDimension();
        if (n2 != (n = this.getColumnDimension())) {
            throw new NonSquareMatrixException(n2, n);
        }
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            d += this.getEntry(i, i);
        }
        return d;
    }

    public double[] operate(double[] dArray) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (dArray.length != n2) {
            throw new DimensionMismatchException(dArray.length, n2);
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                d += this.getEntry(i, j) * dArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    public RealVector operate(RealVector realVector) {
        try {
            return new ArrayRealVector(this.operate(((ArrayRealVector)realVector).getDataRef()), false);
        }
        catch (ClassCastException classCastException) {
            int n = this.getRowDimension();
            int n2 = this.getColumnDimension();
            if (realVector.getDimension() != n2) {
                throw new DimensionMismatchException(realVector.getDimension(), n2);
            }
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                double d = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d += this.getEntry(i, j) * realVector.getEntry(j);
                }
                dArray[i] = d;
            }
            return new ArrayRealVector(dArray, false);
        }
    }

    public double[] preMultiply(double[] dArray) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (dArray.length != n) {
            throw new DimensionMismatchException(dArray.length, n);
        }
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += this.getEntry(j, i) * dArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    public RealVector preMultiply(RealVector realVector) {
        try {
            return new ArrayRealVector(this.preMultiply(((ArrayRealVector)realVector).getDataRef()), false);
        }
        catch (ClassCastException classCastException) {
            int n = this.getRowDimension();
            int n2 = this.getColumnDimension();
            if (realVector.getDimension() != n) {
                throw new DimensionMismatchException(realVector.getDimension(), n);
            }
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                double d = 0.0;
                for (int j = 0; j < n; ++j) {
                    d += this.getEntry(j, i) * realVector.getEntry(j);
                }
                dArray[i] = d;
            }
            return new ArrayRealVector(dArray, false);
        }
    }

    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        realMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = this.getEntry(i, j);
                double d2 = realMatrixChangingVisitor.visit(i, j, d);
                this.setEntry(i, j, d2);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        realMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                realMatrixPreservingVisitor.visit(i, j, this.getEntry(i, j));
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                double d = this.getEntry(i, j);
                double d2 = realMatrixChangingVisitor.visit(i, j, d);
                this.setEntry(i, j, d2);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                realMatrixPreservingVisitor.visit(i, j, this.getEntry(i, j));
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        realMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = this.getEntry(j, i);
                double d2 = realMatrixChangingVisitor.visit(j, i, d);
                this.setEntry(j, i, d2);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        realMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                realMatrixPreservingVisitor.visit(j, i, this.getEntry(j, i));
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                double d = this.getEntry(j, i);
                double d2 = realMatrixChangingVisitor.visit(j, i, d);
                this.setEntry(j, i, d2);
            }
        }
        return realMatrixChangingVisitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                realMatrixPreservingVisitor.visit(j, i, this.getEntry(j, i));
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    public double walkInOptimizedOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        return this.walkInRowOrder(realMatrixChangingVisitor);
    }

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        return this.walkInRowOrder(realMatrixPreservingVisitor);
    }

    public double walkInOptimizedOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        return this.walkInRowOrder(realMatrixChangingVisitor, n, n2, n3, n4);
    }

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        return this.walkInRowOrder(realMatrixPreservingVisitor, n, n2, n3, n4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        stringBuilder.append(string2);
        stringBuilder.append(DEFAULT_FORMAT.format(this));
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RealMatrix)) {
            return false;
        }
        RealMatrix realMatrix = (RealMatrix)object;
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (realMatrix.getColumnDimension() != n2 || realMatrix.getRowDimension() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (this.getEntry(i, j) == realMatrix.getEntry(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 7;
        int n2 = this.getRowDimension();
        int n3 = this.getColumnDimension();
        n = n * 31 + n2;
        n = n * 31 + n3;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                n = n * 31 + (11 * (i + 1) + 17 * (j + 1)) * MathUtils.hash(this.getEntry(i, j));
            }
        }
        return n;
    }

    public abstract RealMatrix createMatrix(int var1, int var2);

    public abstract RealMatrix copy();

    public abstract double getEntry(int var1, int var2);

    public abstract void setEntry(int var1, int var2, double var3);

    static {
        DEFAULT_FORMAT.getFormat().setMinimumFractionDigits(1);
    }
}

