/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.AbstractFieldMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.FieldVector;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    public static final int BLOCK_SIZE = 36;
    private static final long serialVersionUID = -4602336630143123183L;
    private final T[][] blocks;
    private final int rows;
    private final int columns;
    private final int blockRows;
    private final int blockColumns;

    public BlockFieldMatrix(Field<T> field, int n, int n2) {
        super(field, n, n2);
        this.rows = n;
        this.columns = n2;
        this.blockRows = (n + 36 - 1) / 36;
        this.blockColumns = (n2 + 36 - 1) / 36;
        this.blocks = BlockFieldMatrix.createBlocksLayout(field, (int)n, (int)n2);
    }

    public BlockFieldMatrix(T[][] TArray) {
        this(TArray.length, TArray[0].length, BlockFieldMatrix.toBlocksLayout(TArray), false);
    }

    public BlockFieldMatrix(int n, int n2, T[][] TArray, boolean bl) {
        super(BlockFieldMatrix.extractField(TArray), n, n2);
        this.rows = n;
        this.columns = n2;
        this.blockRows = (n + 36 - 1) / 36;
        this.blockColumns = (n2 + 36 - 1) / 36;
        this.blocks = bl ? (FieldElement[][])MathArrays.buildArray(this.getField(), this.blockRows * this.blockColumns, -1) : TArray;
        int n3 = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n4 = this.blockHeight(i);
            int n5 = 0;
            while (n5 < this.blockColumns) {
                if (TArray[n3].length != n4 * this.blockWidth(n5)) {
                    throw new DimensionMismatchException(TArray[n3].length, n4 * this.blockWidth(n5));
                }
                if (bl) {
                    this.blocks[n3] = (FieldElement[])TArray[n3].clone();
                }
                ++n5;
                ++n3;
            }
        }
    }

    public static <T extends FieldElement<T>> T[][] toBlocksLayout(T[][] TArray) {
        int n = TArray.length;
        int n2 = TArray[0].length;
        int n3 = (n + 36 - 1) / 36;
        int n4 = (n2 + 36 - 1) / 36;
        for (int i = 0; i < TArray.length; ++i) {
            int n5 = TArray[i].length;
            if (n5 == n2) continue;
            throw new DimensionMismatchException(n2, n5);
        }
        Field field = BlockFieldMatrix.extractField(TArray);
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(field, n3 * n4, -1);
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7 = i * 36;
            int n8 = FastMath.min(n7 + 36, n);
            int n9 = n8 - n7;
            for (int j = 0; j < n4; ++j) {
                int n10 = j * 36;
                int n11 = FastMath.min(n10 + 36, n2);
                int n12 = n11 - n10;
                FieldElement[] fieldElementArray2 = (FieldElement[])MathArrays.buildArray(field, n9 * n12);
                fieldElementArray[n6] = fieldElementArray2;
                int n13 = 0;
                for (int k = n7; k < n8; ++k) {
                    System.arraycopy(TArray[k], n10, fieldElementArray2, n13, n12);
                    n13 += n12;
                }
                ++n6;
            }
        }
        return fieldElementArray;
    }

    public static <T extends FieldElement<T>> T[][] createBlocksLayout(Field<T> field, int n, int n2) {
        int n3 = (n + 36 - 1) / 36;
        int n4 = (n2 + 36 - 1) / 36;
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(field, n3 * n4, -1);
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            int n6 = i * 36;
            int n7 = FastMath.min(n6 + 36, n);
            int n8 = n7 - n6;
            for (int j = 0; j < n4; ++j) {
                int n9 = j * 36;
                int n10 = FastMath.min(n9 + 36, n2);
                int n11 = n10 - n9;
                fieldElementArray[n5] = (FieldElement[])MathArrays.buildArray(field, n8 * n11);
                ++n5;
            }
        }
        return fieldElementArray;
    }

    @Override
    public FieldMatrix<T> createMatrix(int n, int n2) {
        return new BlockFieldMatrix(this.getField(), n, n2);
    }

    @Override
    public FieldMatrix<T> copy() {
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
        for (int i = 0; i < this.blocks.length; ++i) {
            System.arraycopy(this.blocks[i], 0, blockFieldMatrix.blocks[i], 0, this.blocks[i].length);
        }
        return blockFieldMatrix;
    }

    @Override
    public FieldMatrix<T> add(FieldMatrix<T> fieldMatrix) {
        try {
            return this.add((BlockFieldMatrix)fieldMatrix);
        }
        catch (ClassCastException classCastException) {
            this.checkAdditionCompatible(fieldMatrix);
            BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
            int n = 0;
            for (int i = 0; i < blockFieldMatrix.blockRows; ++i) {
                for (int j = 0; j < blockFieldMatrix.blockColumns; ++j) {
                    T[] TArray = blockFieldMatrix.blocks[n];
                    T[] TArray2 = this.blocks[n];
                    int n2 = i * 36;
                    int n3 = FastMath.min(n2 + 36, this.rows);
                    int n4 = j * 36;
                    int n5 = FastMath.min(n4 + 36, this.columns);
                    int n6 = 0;
                    for (int k = n2; k < n3; ++k) {
                        for (int i2 = n4; i2 < n5; ++i2) {
                            TArray[n6] = (FieldElement)TArray2[n6].add(fieldMatrix.getEntry(k, i2));
                            ++n6;
                        }
                    }
                    ++n;
                }
            }
            return blockFieldMatrix;
        }
    }

    @Override
    public BlockFieldMatrix<T> add(BlockFieldMatrix<T> blockFieldMatrix) {
        this.checkAdditionCompatible(blockFieldMatrix);
        BlockFieldMatrix blockFieldMatrix2 = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
        for (int i = 0; i < blockFieldMatrix2.blocks.length; ++i) {
            T[] TArray = blockFieldMatrix2.blocks[i];
            T[] TArray2 = this.blocks[i];
            T[] TArray3 = blockFieldMatrix.blocks[i];
            for (int j = 0; j < TArray.length; ++j) {
                TArray[j] = (FieldElement)TArray2[j].add(TArray3[j]);
            }
        }
        return blockFieldMatrix2;
    }

    @Override
    public FieldMatrix<T> subtract(FieldMatrix<T> fieldMatrix) {
        try {
            return this.subtract((BlockFieldMatrix)fieldMatrix);
        }
        catch (ClassCastException classCastException) {
            this.checkSubtractionCompatible(fieldMatrix);
            BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
            int n = 0;
            for (int i = 0; i < blockFieldMatrix.blockRows; ++i) {
                for (int j = 0; j < blockFieldMatrix.blockColumns; ++j) {
                    T[] TArray = blockFieldMatrix.blocks[n];
                    T[] TArray2 = this.blocks[n];
                    int n2 = i * 36;
                    int n3 = FastMath.min(n2 + 36, this.rows);
                    int n4 = j * 36;
                    int n5 = FastMath.min(n4 + 36, this.columns);
                    int n6 = 0;
                    for (int k = n2; k < n3; ++k) {
                        for (int i2 = n4; i2 < n5; ++i2) {
                            TArray[n6] = (FieldElement)TArray2[n6].subtract(fieldMatrix.getEntry(k, i2));
                            ++n6;
                        }
                    }
                    ++n;
                }
            }
            return blockFieldMatrix;
        }
    }

    @Override
    public BlockFieldMatrix<T> subtract(BlockFieldMatrix<T> blockFieldMatrix) {
        this.checkSubtractionCompatible(blockFieldMatrix);
        BlockFieldMatrix blockFieldMatrix2 = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
        for (int i = 0; i < blockFieldMatrix2.blocks.length; ++i) {
            T[] TArray = blockFieldMatrix2.blocks[i];
            T[] TArray2 = this.blocks[i];
            T[] TArray3 = blockFieldMatrix.blocks[i];
            for (int j = 0; j < TArray.length; ++j) {
                TArray[j] = (FieldElement)TArray2[j].subtract(TArray3[j]);
            }
        }
        return blockFieldMatrix2;
    }

    @Override
    public FieldMatrix<T> scalarAdd(T t) {
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
        for (int i = 0; i < blockFieldMatrix.blocks.length; ++i) {
            T[] TArray = blockFieldMatrix.blocks[i];
            T[] TArray2 = this.blocks[i];
            for (int j = 0; j < TArray.length; ++j) {
                TArray[j] = (FieldElement)TArray2[j].add(t);
            }
        }
        return blockFieldMatrix;
    }

    @Override
    public FieldMatrix<T> scalarMultiply(T t) {
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, this.columns);
        for (int i = 0; i < blockFieldMatrix.blocks.length; ++i) {
            T[] TArray = blockFieldMatrix.blocks[i];
            T[] TArray2 = this.blocks[i];
            for (int j = 0; j < TArray.length; ++j) {
                TArray[j] = (FieldElement)TArray2[j].multiply(t);
            }
        }
        return blockFieldMatrix;
    }

    @Override
    public FieldMatrix<T> multiply(FieldMatrix<T> fieldMatrix) {
        try {
            return this.multiply((BlockFieldMatrix)fieldMatrix);
        }
        catch (ClassCastException classCastException) {
            this.checkMultiplicationCompatible(fieldMatrix);
            BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, fieldMatrix.getColumnDimension());
            FieldElement fieldElement = (FieldElement)this.getField().getZero();
            int n = 0;
            for (int i = 0; i < blockFieldMatrix.blockRows; ++i) {
                int n2 = i * 36;
                int n3 = FastMath.min(n2 + 36, this.rows);
                for (int j = 0; j < blockFieldMatrix.blockColumns; ++j) {
                    int n4 = j * 36;
                    int n5 = FastMath.min(n4 + 36, fieldMatrix.getColumnDimension());
                    T[] TArray = blockFieldMatrix.blocks[n];
                    for (int k = 0; k < this.blockColumns; ++k) {
                        int n6 = this.blockWidth(k);
                        T[] TArray2 = this.blocks[i * this.blockColumns + k];
                        int n7 = k * 36;
                        int n8 = 0;
                        for (int i2 = n2; i2 < n3; ++i2) {
                            int n9 = (i2 - n2) * n6;
                            int n10 = n9 + n6;
                            for (int i3 = n4; i3 < n5; ++i3) {
                                FieldElement fieldElement2 = fieldElement;
                                int n11 = n7;
                                for (int i4 = n9; i4 < n10; ++i4) {
                                    fieldElement2 = (FieldElement)fieldElement2.add(TArray2[i4].multiply(fieldMatrix.getEntry(n11, i3)));
                                    ++n11;
                                }
                                TArray[n8] = TArray[n8].add((FieldElement)fieldElement2);
                                ++n8;
                            }
                        }
                    }
                    ++n;
                }
            }
            return blockFieldMatrix;
        }
    }

    @Override
    public BlockFieldMatrix<T> multiply(BlockFieldMatrix<T> blockFieldMatrix) {
        this.checkMultiplicationCompatible(blockFieldMatrix);
        BlockFieldMatrix blockFieldMatrix2 = new BlockFieldMatrix(this.getField(), this.rows, blockFieldMatrix.columns);
        FieldElement fieldElement = (FieldElement)this.getField().getZero();
        int n = 0;
        for (int i = 0; i < blockFieldMatrix2.blockRows; ++i) {
            int n2 = i * 36;
            int n3 = FastMath.min(n2 + 36, this.rows);
            for (int j = 0; j < blockFieldMatrix2.blockColumns; ++j) {
                int n4 = super.blockWidth(j);
                int n5 = n4 + n4;
                int n6 = n5 + n4;
                int n7 = n6 + n4;
                T[] TArray = blockFieldMatrix2.blocks[n];
                for (int k = 0; k < this.blockColumns; ++k) {
                    int n8 = this.blockWidth(k);
                    T[] TArray2 = this.blocks[i * this.blockColumns + k];
                    T[] TArray3 = blockFieldMatrix.blocks[k * blockFieldMatrix.blockColumns + j];
                    int n9 = 0;
                    for (int i2 = n2; i2 < n3; ++i2) {
                        int n10 = (i2 - n2) * n8;
                        int n11 = n10 + n8;
                        for (int i3 = 0; i3 < n4; ++i3) {
                            FieldElement fieldElement2 = fieldElement;
                            int n12 = n10;
                            int n13 = i3;
                            while (n12 < n11 - 3) {
                                fieldElement2 = (FieldElement)((FieldElement)((FieldElement)((FieldElement)fieldElement2.add(TArray2[n12].multiply(TArray3[n13]))).add(TArray2[n12 + 1].multiply(TArray3[n13 + n4]))).add(TArray2[n12 + 2].multiply(TArray3[n13 + n5]))).add(TArray2[n12 + 3].multiply(TArray3[n13 + n6]));
                                n12 += 4;
                                n13 += n7;
                            }
                            while (n12 < n11) {
                                fieldElement2 = (FieldElement)fieldElement2.add(TArray2[n12++].multiply(TArray3[n13]));
                                n13 += n4;
                            }
                            TArray[n9] = TArray[n9].add((FieldElement)fieldElement2);
                            ++n9;
                        }
                    }
                }
                ++n;
            }
        }
        return blockFieldMatrix2;
    }

    @Override
    public T[][] getData() {
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.getField(), this.getRowDimension(), this.getColumnDimension());
        int n = this.columns - (this.blockColumns - 1) * 36;
        for (int i = 0; i < this.blockRows; ++i) {
            int n2 = i * 36;
            int n3 = FastMath.min(n2 + 36, this.rows);
            int n4 = 0;
            int n5 = 0;
            for (int j = n2; j < n3; ++j) {
                FieldElement[] fieldElementArray2 = fieldElementArray[j];
                int n6 = i * this.blockColumns;
                int n7 = 0;
                for (int k = 0; k < this.blockColumns - 1; ++k) {
                    System.arraycopy(this.blocks[n6++], n4, fieldElementArray2, n7, 36);
                    n7 += 36;
                }
                System.arraycopy(this.blocks[n6], n5, fieldElementArray2, n7, n);
                n4 += 36;
                n5 += n;
            }
        }
        return fieldElementArray;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), n2 - n + 1, n4 - n3 + 1);
        int n5 = n / 36;
        int n6 = n % 36;
        int n7 = n3 / 36;
        int n8 = n3 % 36;
        int n9 = n5;
        for (int i = 0; i < blockFieldMatrix.blockRows; ++i) {
            int n10 = super.blockHeight(i);
            int n11 = n7;
            for (int j = 0; j < blockFieldMatrix.blockColumns; ++j) {
                int n12;
                int n13 = super.blockWidth(j);
                int n14 = i * blockFieldMatrix.blockColumns + j;
                T[] TArray = blockFieldMatrix.blocks[n14];
                int n15 = n9 * this.blockColumns + n11;
                int n16 = this.blockWidth(n11);
                int n17 = n10 + n6 - 36;
                int n18 = n13 + n8 - 36;
                if (n17 > 0) {
                    if (n18 > 0) {
                        n12 = this.blockWidth(n11 + 1);
                        this.copyBlockPart((FieldElement[])this.blocks[n15], n16, n6, 36, n8, 36, (FieldElement[])TArray, n13, 0, 0);
                        this.copyBlockPart((FieldElement[])this.blocks[n15 + 1], n12, n6, 36, 0, n18, (FieldElement[])TArray, n13, 0, n13 - n18);
                        this.copyBlockPart((FieldElement[])this.blocks[n15 + this.blockColumns], n16, 0, n17, n8, 36, (FieldElement[])TArray, n13, n10 - n17, 0);
                        this.copyBlockPart((FieldElement[])this.blocks[n15 + this.blockColumns + 1], n12, 0, n17, 0, n18, (FieldElement[])TArray, n13, n10 - n17, n13 - n18);
                    } else {
                        this.copyBlockPart((FieldElement[])this.blocks[n15], n16, n6, 36, n8, n13 + n8, (FieldElement[])TArray, n13, 0, 0);
                        this.copyBlockPart((FieldElement[])this.blocks[n15 + this.blockColumns], n16, 0, n17, n8, n13 + n8, (FieldElement[])TArray, n13, n10 - n17, 0);
                    }
                } else if (n18 > 0) {
                    n12 = this.blockWidth(n11 + 1);
                    this.copyBlockPart((FieldElement[])this.blocks[n15], n16, n6, n10 + n6, n8, 36, (FieldElement[])TArray, n13, 0, 0);
                    this.copyBlockPart((FieldElement[])this.blocks[n15 + 1], n12, n6, n10 + n6, 0, n18, (FieldElement[])TArray, n13, 0, n13 - n18);
                } else {
                    this.copyBlockPart((FieldElement[])this.blocks[n15], n16, n6, n10 + n6, n8, n13 + n8, (FieldElement[])TArray, n13, 0, 0);
                }
                ++n11;
            }
            ++n9;
        }
        return blockFieldMatrix;
    }

    private void copyBlockPart(T[] TArray, int n, int n2, int n3, int n4, int n5, T[] TArray2, int n6, int n7, int n8) {
        int n9 = n5 - n4;
        int n10 = n2 * n + n4;
        int n11 = n7 * n6 + n8;
        for (int i = n2; i < n3; ++i) {
            System.arraycopy(TArray, n10, TArray2, n11, n9);
            n10 += n;
            n11 += n6;
        }
    }

    @Override
    public void setSubMatrix(T[][] TArray, int n, int n2) {
        MathUtils.checkNotNull(TArray);
        int n3 = TArray[0].length;
        if (n3 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        int n4 = n + TArray.length - 1;
        int n5 = n2 + n3 - 1;
        this.checkSubMatrixIndex(n, n4, n2, n5);
        for (T[] TArray2 : TArray) {
            if (TArray2.length == n3) continue;
            throw new DimensionMismatchException(n3, TArray2.length);
        }
        int n6 = n / 36;
        int n7 = (n4 + 36) / 36;
        int n8 = n2 / 36;
        int n9 = (n5 + 36) / 36;
        for (int i = n6; i < n7; ++i) {
            int n10 = this.blockHeight(i);
            int n11 = i * 36;
            int n12 = FastMath.max(n, n11);
            int n13 = FastMath.min(n4 + 1, n11 + n10);
            for (int j = n8; j < n9; ++j) {
                int n14 = this.blockWidth(j);
                int n15 = j * 36;
                int n16 = FastMath.max(n2, n15);
                int n17 = FastMath.min(n5 + 1, n15 + n14);
                int n18 = n17 - n16;
                T[] TArray3 = this.blocks[i * this.blockColumns + j];
                for (int k = n12; k < n13; ++k) {
                    System.arraycopy(TArray[k - n], n16 - n2, TArray3, (k - n11) * n14 + (n16 - n15), n18);
                }
            }
        }
    }

    @Override
    public FieldMatrix<T> getRowMatrix(int n) {
        this.checkRowIndex(n);
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), 1, this.columns);
        int n2 = n / 36;
        int n3 = n - n2 * 36;
        int n4 = 0;
        int n5 = 0;
        T[] TArray = blockFieldMatrix.blocks[n4];
        for (int i = 0; i < this.blockColumns; ++i) {
            int n6 = this.blockWidth(i);
            T[] TArray2 = this.blocks[n2 * this.blockColumns + i];
            int n7 = TArray.length - n5;
            if (n6 > n7) {
                System.arraycopy(TArray2, n3 * n6, TArray, n5, n7);
                TArray = blockFieldMatrix.blocks[++n4];
                System.arraycopy(TArray2, n3 * n6, TArray, 0, n6 - n7);
                n5 = n6 - n7;
                continue;
            }
            System.arraycopy(TArray2, n3 * n6, TArray, n5, n6);
            n5 += n6;
        }
        return blockFieldMatrix;
    }

    @Override
    public void setRowMatrix(int n, FieldMatrix<T> fieldMatrix) {
        try {
            this.setRowMatrix(n, (BlockFieldMatrix)fieldMatrix);
        }
        catch (ClassCastException classCastException) {
            super.setRowMatrix(n, fieldMatrix);
        }
    }

    @Override
    public void setRowMatrix(int n, BlockFieldMatrix<T> blockFieldMatrix) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        if (blockFieldMatrix.getRowDimension() != 1 || blockFieldMatrix.getColumnDimension() != n2) {
            throw new MatrixDimensionMismatchException(blockFieldMatrix.getRowDimension(), blockFieldMatrix.getColumnDimension(), 1, n2);
        }
        int n3 = n / 36;
        int n4 = n - n3 * 36;
        int n5 = 0;
        int n6 = 0;
        T[] TArray = blockFieldMatrix.blocks[n5];
        for (int i = 0; i < this.blockColumns; ++i) {
            int n7 = this.blockWidth(i);
            T[] TArray2 = this.blocks[n3 * this.blockColumns + i];
            int n8 = TArray.length - n6;
            if (n7 > n8) {
                System.arraycopy(TArray, n6, TArray2, n4 * n7, n8);
                TArray = blockFieldMatrix.blocks[++n5];
                System.arraycopy(TArray, 0, TArray2, n4 * n7, n7 - n8);
                n6 = n7 - n8;
                continue;
            }
            System.arraycopy(TArray, n6, TArray2, n4 * n7, n7);
            n6 += n7;
        }
    }

    @Override
    public FieldMatrix<T> getColumnMatrix(int n) {
        this.checkColumnIndex(n);
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), this.rows, 1);
        int n2 = n / 36;
        int n3 = n - n2 * 36;
        int n4 = this.blockWidth(n2);
        int n5 = 0;
        int n6 = 0;
        T[] TArray = blockFieldMatrix.blocks[n5];
        for (int i = 0; i < this.blockRows; ++i) {
            int n7 = this.blockHeight(i);
            T[] TArray2 = this.blocks[i * this.blockColumns + n2];
            for (int j = 0; j < n7; ++j) {
                if (n6 >= TArray.length) {
                    TArray = blockFieldMatrix.blocks[++n5];
                    n6 = 0;
                }
                TArray[n6++] = TArray2[j * n4 + n3];
            }
        }
        return blockFieldMatrix;
    }

    @Override
    public void setColumnMatrix(int n, FieldMatrix<T> fieldMatrix) {
        try {
            this.setColumnMatrix(n, (BlockFieldMatrix)fieldMatrix);
        }
        catch (ClassCastException classCastException) {
            super.setColumnMatrix(n, fieldMatrix);
        }
    }

    @Override
    void setColumnMatrix(int n, BlockFieldMatrix<T> blockFieldMatrix) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        if (blockFieldMatrix.getRowDimension() != n2 || blockFieldMatrix.getColumnDimension() != 1) {
            throw new MatrixDimensionMismatchException(blockFieldMatrix.getRowDimension(), blockFieldMatrix.getColumnDimension(), n2, 1);
        }
        int n3 = n / 36;
        int n4 = n - n3 * 36;
        int n5 = this.blockWidth(n3);
        int n6 = 0;
        int n7 = 0;
        T[] TArray = blockFieldMatrix.blocks[n6];
        for (int i = 0; i < this.blockRows; ++i) {
            int n8 = this.blockHeight(i);
            T[] TArray2 = this.blocks[i * this.blockColumns + n3];
            for (int j = 0; j < n8; ++j) {
                if (n7 >= TArray.length) {
                    TArray = blockFieldMatrix.blocks[++n6];
                    n7 = 0;
                }
                TArray2[j * n5 + n4] = TArray[n7++];
            }
        }
    }

    @Override
    public FieldVector<T> getRowVector(int n) {
        this.checkRowIndex(n);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.columns);
        int n2 = n / 36;
        int n3 = n - n2 * 36;
        int n4 = 0;
        for (int i = 0; i < this.blockColumns; ++i) {
            int n5 = this.blockWidth(i);
            T[] TArray = this.blocks[n2 * this.blockColumns + i];
            System.arraycopy(TArray, n3 * n5, fieldElementArray, n4, n5);
            n4 += n5;
        }
        return new ArrayFieldVector(this.getField(), fieldElementArray, false);
    }

    @Override
    public void setRowVector(int n, FieldVector<T> fieldVector) {
        try {
            this.setRow(n, ((ArrayFieldVector)fieldVector).getDataRef());
        }
        catch (ClassCastException classCastException) {
            super.setRowVector(n, fieldVector);
        }
    }

    @Override
    public FieldVector<T> getColumnVector(int n) {
        this.checkColumnIndex(n);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.rows);
        int n2 = n / 36;
        int n3 = n - n2 * 36;
        int n4 = this.blockWidth(n2);
        int n5 = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n6 = this.blockHeight(i);
            T[] TArray = this.blocks[i * this.blockColumns + n2];
            for (int j = 0; j < n6; ++j) {
                fieldElementArray[n5++] = TArray[j * n4 + n3];
            }
        }
        return new ArrayFieldVector(this.getField(), fieldElementArray, false);
    }

    @Override
    public void setColumnVector(int n, FieldVector<T> fieldVector) {
        try {
            this.setColumn(n, ((ArrayFieldVector)fieldVector).getDataRef());
        }
        catch (ClassCastException classCastException) {
            super.setColumnVector(n, fieldVector);
        }
    }

    @Override
    public T[] getRow(int n) {
        this.checkRowIndex(n);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.columns);
        int n2 = n / 36;
        int n3 = n - n2 * 36;
        int n4 = 0;
        for (int i = 0; i < this.blockColumns; ++i) {
            int n5 = this.blockWidth(i);
            T[] TArray = this.blocks[n2 * this.blockColumns + i];
            System.arraycopy(TArray, n3 * n5, fieldElementArray, n4, n5);
            n4 += n5;
        }
        return fieldElementArray;
    }

    @Override
    public void setRow(int n, T[] TArray) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        if (TArray.length != n2) {
            throw new MatrixDimensionMismatchException(1, TArray.length, 1, n2);
        }
        int n3 = n / 36;
        int n4 = n - n3 * 36;
        int n5 = 0;
        for (int i = 0; i < this.blockColumns; ++i) {
            int n6 = this.blockWidth(i);
            T[] TArray2 = this.blocks[n3 * this.blockColumns + i];
            System.arraycopy(TArray, n5, TArray2, n4 * n6, n6);
            n5 += n6;
        }
    }

    @Override
    public T[] getColumn(int n) {
        this.checkColumnIndex(n);
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.rows);
        int n2 = n / 36;
        int n3 = n - n2 * 36;
        int n4 = this.blockWidth(n2);
        int n5 = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n6 = this.blockHeight(i);
            T[] TArray = this.blocks[i * this.blockColumns + n2];
            for (int j = 0; j < n6; ++j) {
                fieldElementArray[n5++] = TArray[j * n4 + n3];
            }
        }
        return fieldElementArray;
    }

    @Override
    public void setColumn(int n, T[] TArray) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        if (TArray.length != n2) {
            throw new MatrixDimensionMismatchException(TArray.length, 1, n2, 1);
        }
        int n3 = n / 36;
        int n4 = n - n3 * 36;
        int n5 = this.blockWidth(n3);
        int n6 = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n7 = this.blockHeight(i);
            T[] TArray2 = this.blocks[i * this.blockColumns + n3];
            for (int j = 0; j < n7; ++j) {
                TArray2[j * n5 + n4] = TArray[n6++];
            }
        }
    }

    @Override
    public T getEntry(int n, int n2) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        int n3 = n / 36;
        int n4 = n2 / 36;
        int n5 = (n - n3 * 36) * this.blockWidth(n4) + (n2 - n4 * 36);
        return this.blocks[n3 * this.blockColumns + n4][n5];
    }

    @Override
    public void setEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        int n3 = n / 36;
        int n4 = n2 / 36;
        int n5 = (n - n3 * 36) * this.blockWidth(n4) + (n2 - n4 * 36);
        this.blocks[n3 * this.blockColumns + n4][n5] = t;
    }

    @Override
    public void addToEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        int n3 = n / 36;
        int n4 = n2 / 36;
        int n5 = (n - n3 * 36) * this.blockWidth(n4) + (n2 - n4 * 36);
        T[] TArray = this.blocks[n3 * this.blockColumns + n4];
        TArray[n5] = (FieldElement)TArray[n5].add(t);
    }

    @Override
    public void multiplyEntry(int n, int n2, T t) {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        int n3 = n / 36;
        int n4 = n2 / 36;
        int n5 = (n - n3 * 36) * this.blockWidth(n4) + (n2 - n4 * 36);
        T[] TArray = this.blocks[n3 * this.blockColumns + n4];
        TArray[n5] = (FieldElement)TArray[n5].multiply(t);
    }

    @Override
    public FieldMatrix<T> transpose() {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        BlockFieldMatrix blockFieldMatrix = new BlockFieldMatrix(this.getField(), n2, n);
        int n3 = 0;
        for (int i = 0; i < this.blockColumns; ++i) {
            for (int j = 0; j < this.blockRows; ++j) {
                T[] TArray = blockFieldMatrix.blocks[n3];
                T[] TArray2 = this.blocks[j * this.blockColumns + i];
                int n4 = i * 36;
                int n5 = FastMath.min(n4 + 36, this.columns);
                int n6 = j * 36;
                int n7 = FastMath.min(n6 + 36, this.rows);
                int n8 = 0;
                for (int k = n4; k < n5; ++k) {
                    int n9 = n5 - n4;
                    int n10 = k - n4;
                    for (int i2 = n6; i2 < n7; ++i2) {
                        TArray[n8] = TArray2[n10];
                        ++n8;
                        n10 += n9;
                    }
                }
                ++n3;
            }
        }
        return blockFieldMatrix;
    }

    @Override
    public int getRowDimension() {
        return this.rows;
    }

    @Override
    public int getColumnDimension() {
        return this.columns;
    }

    @Override
    public T[] operate(T[] TArray) {
        if (TArray.length != this.columns) {
            throw new DimensionMismatchException(TArray.length, this.columns);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.rows);
        FieldElement fieldElement = (FieldElement)this.getField().getZero();
        for (int i = 0; i < this.blockRows; ++i) {
            int n = i * 36;
            int n2 = FastMath.min(n + 36, this.rows);
            for (int j = 0; j < this.blockColumns; ++j) {
                T[] TArray2 = this.blocks[i * this.blockColumns + j];
                int n3 = j * 36;
                int n4 = FastMath.min(n3 + 36, this.columns);
                int n5 = 0;
                for (int k = n; k < n2; ++k) {
                    int n6;
                    FieldElement fieldElement2 = fieldElement;
                    for (n6 = n3; n6 < n4 - 3; n6 += 4) {
                        fieldElement2 = (FieldElement)((FieldElement)((FieldElement)((FieldElement)fieldElement2.add(TArray2[n5].multiply(TArray[n6]))).add(TArray2[n5 + 1].multiply(TArray[n6 + 1]))).add(TArray2[n5 + 2].multiply(TArray[n6 + 2]))).add(TArray2[n5 + 3].multiply(TArray[n6 + 3]));
                        n5 += 4;
                    }
                    while (n6 < n4) {
                        fieldElement2 = (FieldElement)fieldElement2.add(TArray2[n5++].multiply(TArray[n6++]));
                    }
                    fieldElementArray[k] = fieldElementArray[k].add(fieldElement2);
                }
            }
        }
        return fieldElementArray;
    }

    @Override
    public T[] preMultiply(T[] TArray) {
        if (TArray.length != this.rows) {
            throw new DimensionMismatchException(TArray.length, this.rows);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), this.columns);
        FieldElement fieldElement = (FieldElement)this.getField().getZero();
        for (int i = 0; i < this.blockColumns; ++i) {
            int n = this.blockWidth(i);
            int n2 = n + n;
            int n3 = n2 + n;
            int n4 = n3 + n;
            int n5 = i * 36;
            int n6 = FastMath.min(n5 + 36, this.columns);
            for (int j = 0; j < this.blockRows; ++j) {
                T[] TArray2 = this.blocks[j * this.blockColumns + i];
                int n7 = j * 36;
                int n8 = FastMath.min(n7 + 36, this.rows);
                for (int k = n5; k < n6; ++k) {
                    int n9;
                    int n10 = k - n5;
                    FieldElement fieldElement2 = fieldElement;
                    for (n9 = n7; n9 < n8 - 3; n9 += 4) {
                        fieldElement2 = (FieldElement)((FieldElement)((FieldElement)((FieldElement)fieldElement2.add(TArray2[n10].multiply(TArray[n9]))).add(TArray2[n10 + n].multiply(TArray[n9 + 1]))).add(TArray2[n10 + n2].multiply(TArray[n9 + 2]))).add(TArray2[n10 + n3].multiply(TArray[n9 + 3]));
                        n10 += n4;
                    }
                    while (n9 < n8) {
                        fieldElement2 = (FieldElement)fieldElement2.add(TArray2[n10].multiply(TArray[n9++]));
                        n10 += n;
                    }
                    fieldElementArray[k] = fieldElementArray[k].add(fieldElement2);
                }
            }
        }
        return fieldElementArray;
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        fieldMatrixChangingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        for (int i = 0; i < this.blockRows; ++i) {
            int n = i * 36;
            int n2 = FastMath.min(n + 36, this.rows);
            for (int j = n; j < n2; ++j) {
                for (int k = 0; k < this.blockColumns; ++k) {
                    int n3 = this.blockWidth(k);
                    int n4 = k * 36;
                    int n5 = FastMath.min(n4 + 36, this.columns);
                    T[] TArray = this.blocks[i * this.blockColumns + k];
                    int n6 = (j - n) * n3;
                    for (int i2 = n4; i2 < n5; ++i2) {
                        TArray[n6] = fieldMatrixChangingVisitor.visit(j, i2, TArray[n6]);
                        ++n6;
                    }
                }
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        fieldMatrixPreservingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        for (int i = 0; i < this.blockRows; ++i) {
            int n = i * 36;
            int n2 = FastMath.min(n + 36, this.rows);
            for (int j = n; j < n2; ++j) {
                for (int k = 0; k < this.blockColumns; ++k) {
                    int n3 = this.blockWidth(k);
                    int n4 = k * 36;
                    int n5 = FastMath.min(n4 + 36, this.columns);
                    T[] TArray = this.blocks[i * this.blockColumns + k];
                    int n6 = (j - n) * n3;
                    for (int i2 = n4; i2 < n5; ++i2) {
                        fieldMatrixPreservingVisitor.visit(j, i2, TArray[n6]);
                        ++n6;
                    }
                }
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i = n / 36; i < 1 + n2 / 36; ++i) {
            int n5 = i * 36;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i + 1) * 36, 1 + n2);
            for (int j = n6; j < n7; ++j) {
                for (int k = n3 / 36; k < 1 + n4 / 36; ++k) {
                    int n8 = this.blockWidth(k);
                    int n9 = k * 36;
                    int n10 = FastMath.max(n3, n9);
                    int n11 = FastMath.min((k + 1) * 36, 1 + n4);
                    T[] TArray = this.blocks[i * this.blockColumns + k];
                    int n12 = (j - n5) * n8 + n10 - n9;
                    for (int i2 = n10; i2 < n11; ++i2) {
                        TArray[n12] = fieldMatrixChangingVisitor.visit(j, i2, TArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i = n / 36; i < 1 + n2 / 36; ++i) {
            int n5 = i * 36;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i + 1) * 36, 1 + n2);
            for (int j = n6; j < n7; ++j) {
                for (int k = n3 / 36; k < 1 + n4 / 36; ++k) {
                    int n8 = this.blockWidth(k);
                    int n9 = k * 36;
                    int n10 = FastMath.max(n3, n9);
                    int n11 = FastMath.min((k + 1) * 36, 1 + n4);
                    T[] TArray = this.blocks[i * this.blockColumns + k];
                    int n12 = (j - n5) * n8 + n10 - n9;
                    for (int i2 = n10; i2 < n11; ++i2) {
                        fieldMatrixPreservingVisitor.visit(j, i2, TArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        fieldMatrixChangingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        int n = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n2 = i * 36;
            int n3 = FastMath.min(n2 + 36, this.rows);
            for (int j = 0; j < this.blockColumns; ++j) {
                int n4 = j * 36;
                int n5 = FastMath.min(n4 + 36, this.columns);
                T[] TArray = this.blocks[n];
                int n6 = 0;
                for (int k = n2; k < n3; ++k) {
                    for (int i2 = n4; i2 < n5; ++i2) {
                        TArray[n6] = fieldMatrixChangingVisitor.visit(k, i2, TArray[n6]);
                        ++n6;
                    }
                }
                ++n;
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        fieldMatrixPreservingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        int n = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n2 = i * 36;
            int n3 = FastMath.min(n2 + 36, this.rows);
            for (int j = 0; j < this.blockColumns; ++j) {
                int n4 = j * 36;
                int n5 = FastMath.min(n4 + 36, this.columns);
                T[] TArray = this.blocks[n];
                int n6 = 0;
                for (int k = n2; k < n3; ++k) {
                    for (int i2 = n4; i2 < n5; ++i2) {
                        fieldMatrixPreservingVisitor.visit(k, i2, TArray[n6]);
                        ++n6;
                    }
                }
                ++n;
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i = n / 36; i < 1 + n2 / 36; ++i) {
            int n5 = i * 36;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i + 1) * 36, 1 + n2);
            for (int j = n3 / 36; j < 1 + n4 / 36; ++j) {
                int n8 = this.blockWidth(j);
                int n9 = j * 36;
                int n10 = FastMath.max(n3, n9);
                int n11 = FastMath.min((j + 1) * 36, 1 + n4);
                T[] TArray = this.blocks[i * this.blockColumns + j];
                for (int k = n6; k < n7; ++k) {
                    int n12 = (k - n5) * n8 + n10 - n9;
                    for (int i2 = n10; i2 < n11; ++i2) {
                        TArray[n12] = fieldMatrixChangingVisitor.visit(k, i2, TArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i = n / 36; i < 1 + n2 / 36; ++i) {
            int n5 = i * 36;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i + 1) * 36, 1 + n2);
            for (int j = n3 / 36; j < 1 + n4 / 36; ++j) {
                int n8 = this.blockWidth(j);
                int n9 = j * 36;
                int n10 = FastMath.max(n3, n9);
                int n11 = FastMath.min((j + 1) * 36, 1 + n4);
                T[] TArray = this.blocks[i * this.blockColumns + j];
                for (int k = n6; k < n7; ++k) {
                    int n12 = (k - n5) * n8 + n10 - n9;
                    for (int i2 = n10; i2 < n11; ++i2) {
                        fieldMatrixPreservingVisitor.visit(k, i2, TArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    private int blockHeight(int n) {
        return n == this.blockRows - 1 ? this.rows - n * 36 : 36;
    }

    private int blockWidth(int n) {
        return n == this.blockColumns - 1 ? this.columns - n * 36 : 36;
    }
}

