/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.NonSymmetricMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;

public class CholeskyDecomposition {
    public static final double DEFAULT_RELATIVE_SYMMETRY_THRESHOLD = 1.0E-15;
    public static final double DEFAULT_ABSOLUTE_POSITIVITY_THRESHOLD = 1.0E-10;
    private double[][] lTData;
    private RealMatrix cachedL;
    private RealMatrix cachedLT;

    public CholeskyDecomposition(RealMatrix realMatrix) {
        this(realMatrix, 1.0E-15, 1.0E-10);
    }

    public CholeskyDecomposition(RealMatrix realMatrix, double d, double d2) {
        double[] dArray;
        int n;
        if (!realMatrix.isSquare()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n2 = realMatrix.getRowDimension();
        this.lTData = realMatrix.getData();
        this.cachedL = null;
        this.cachedLT = null;
        for (n = 0; n < n2; ++n) {
            dArray = this.lTData[n];
            for (int i = n + 1; i < n2; ++i) {
                double[] dArray2 = this.lTData[i];
                double d3 = dArray[i];
                double d4 = dArray2[n];
                double d5 = d * FastMath.max(FastMath.abs(d3), FastMath.abs(d4));
                if (FastMath.abs(d3 - d4) > d5) {
                    throw new NonSymmetricMatrixException(n, i, d);
                }
                dArray2[n] = 0.0;
            }
        }
        for (n = 0; n < n2; ++n) {
            dArray = this.lTData[n];
            if (dArray[n] <= d2) {
                throw new NonPositiveDefiniteMatrixException(dArray[n], n, d2);
            }
            dArray[n] = FastMath.sqrt(dArray[n]);
            double d6 = 1.0 / dArray[n];
            for (int i = n2 - 1; i > n; --i) {
                int n3 = i;
                dArray[n3] = dArray[n3] * d6;
                double[] dArray3 = this.lTData[i];
                for (int j = i; j < n2; ++j) {
                    int n4 = j;
                    dArray3[n4] = dArray3[n4] - dArray[i] * dArray[j];
                }
            }
        }
    }

    public RealMatrix getL() {
        if (this.cachedL == null) {
            this.cachedL = this.getLT().transpose();
        }
        return this.cachedL;
    }

    public RealMatrix getLT() {
        if (this.cachedLT == null) {
            this.cachedLT = MatrixUtils.createRealMatrix(this.lTData);
        }
        return this.cachedLT;
    }

    public double getDeterminant() {
        double d = 1.0;
        for (int i = 0; i < this.lTData.length; ++i) {
            double d2 = this.lTData[i][i];
            d *= d2 * d2;
        }
        return d;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.lTData);
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[][] lTData;

        private Solver(double[][] dArray) {
            this.lTData = dArray;
        }

        public boolean isNonSingular() {
            return true;
        }

        public RealVector solve(RealVector realVector) {
            int n;
            int n2 = this.lTData.length;
            if (realVector.getDimension() != n2) {
                throw new DimensionMismatchException(realVector.getDimension(), n2);
            }
            double[] dArray = realVector.toArray();
            for (n = 0; n < n2; ++n) {
                double[] dArray2 = this.lTData[n];
                int n3 = n;
                dArray[n3] = dArray[n3] / dArray2[n];
                double d = dArray[n];
                for (int i = n + 1; i < n2; ++i) {
                    int n4 = i;
                    dArray[n4] = dArray[n4] - d * dArray2[i];
                }
            }
            for (n = n2 - 1; n >= 0; --n) {
                int n5 = n;
                dArray[n5] = dArray[n5] / this.lTData[n][n];
                double d = dArray[n];
                for (int i = 0; i < n; ++i) {
                    int n6 = i;
                    dArray[n6] = dArray[n6] - d * this.lTData[i][n];
                }
            }
            return new ArrayRealVector(dArray, false);
        }

        public RealMatrix solve(RealMatrix realMatrix) {
            int n;
            int n2 = this.lTData.length;
            if (realMatrix.getRowDimension() != n2) {
                throw new DimensionMismatchException(realMatrix.getRowDimension(), n2);
            }
            int n3 = realMatrix.getColumnDimension();
            double[][] dArray = realMatrix.getData();
            for (n = 0; n < n2; ++n) {
                double[] dArray2 = this.lTData[n];
                double d = dArray2[n];
                double[] dArray3 = dArray[n];
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = n4++;
                    dArray3[n5] = dArray3[n5] / d;
                }
                for (n4 = n + 1; n4 < n2; ++n4) {
                    double[] dArray4 = dArray[n4];
                    double d2 = dArray2[n4];
                    for (int i = 0; i < n3; ++i) {
                        int n6 = i;
                        dArray4[n6] = dArray4[n6] - dArray3[i] * d2;
                    }
                }
            }
            for (n = n2 - 1; n >= 0; --n) {
                double d = this.lTData[n][n];
                double[] dArray5 = dArray[n];
                int n7 = 0;
                while (n7 < n3) {
                    int n8 = n7++;
                    dArray5[n8] = dArray5[n8] / d;
                }
                for (n7 = 0; n7 < n; ++n7) {
                    double[] dArray6 = dArray[n7];
                    double d3 = this.lTData[n7][n];
                    for (int i = 0; i < n3; ++i) {
                        int n9 = i;
                        dArray6[n9] = dArray6[n9] - dArray5[i] * d3;
                    }
                }
            }
            return new Array2DRowRealMatrix(dArray);
        }

        public RealMatrix getInverse() {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.lTData.length));
        }
    }
}

