/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.linear.IterativeLinearSolverEvent;
import org.apache.commons.math3.linear.RealVector;

public class DefaultIterativeLinearSolverEvent
extends IterativeLinearSolverEvent {
    private static final long serialVersionUID = 20120129L;
    private final RealVector b;
    private final RealVector r;
    private final double rnorm;
    private final RealVector x;

    public DefaultIterativeLinearSolverEvent(Object object, int n, RealVector realVector, RealVector realVector2, RealVector realVector3, double d) {
        super(object, n);
        this.x = realVector;
        this.b = realVector2;
        this.r = realVector3;
        this.rnorm = d;
    }

    public DefaultIterativeLinearSolverEvent(Object object, int n, RealVector realVector, RealVector realVector2, double d) {
        super(object, n);
        this.x = realVector;
        this.b = realVector2;
        this.r = null;
        this.rnorm = d;
    }

    public double getNormOfResidual() {
        return this.rnorm;
    }

    public RealVector getResidual() {
        if (this.r != null) {
            return this.r;
        }
        throw new MathUnsupportedOperationException();
    }

    public RealVector getRightHandSideVector() {
        return this.b;
    }

    public RealVector getSolution() {
        return this.x;
    }

    public boolean providesResidual() {
        return this.r != null;
    }
}

