/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.analysis.function.Sqrt;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.NonSquareOperatorException;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.MathArrays;

public class JacobiPreconditioner
extends RealLinearOperator {
    private final ArrayRealVector diag;

    public JacobiPreconditioner(double[] dArray, boolean bl) {
        this.diag = new ArrayRealVector(dArray, bl);
    }

    public static JacobiPreconditioner create(RealLinearOperator realLinearOperator) {
        int n = realLinearOperator.getColumnDimension();
        if (realLinearOperator.getRowDimension() != n) {
            throw new NonSquareOperatorException(realLinearOperator.getRowDimension(), n);
        }
        double[] dArray = new double[n];
        if (realLinearOperator instanceof AbstractRealMatrix) {
            AbstractRealMatrix abstractRealMatrix = (AbstractRealMatrix)realLinearOperator;
            for (int i = 0; i < n; ++i) {
                dArray[i] = abstractRealMatrix.getEntry(i, i);
            }
        } else {
            ArrayRealVector arrayRealVector = new ArrayRealVector(n);
            for (int i = 0; i < n; ++i) {
                arrayRealVector.set(0.0);
                arrayRealVector.setEntry(i, 1.0);
                dArray[i] = realLinearOperator.operate(arrayRealVector).getEntry(i);
            }
        }
        return new JacobiPreconditioner(dArray, false);
    }

    public int getColumnDimension() {
        return this.diag.getDimension();
    }

    public int getRowDimension() {
        return this.diag.getDimension();
    }

    public RealVector operate(RealVector realVector) {
        return new ArrayRealVector(MathArrays.ebeDivide(realVector.toArray(), this.diag.toArray()), false);
    }

    public RealLinearOperator sqrt() {
        final ArrayRealVector arrayRealVector = this.diag.map(new Sqrt());
        return new RealLinearOperator(){

            public RealVector operate(RealVector realVector) {
                return new ArrayRealVector(MathArrays.ebeDivide(realVector.toArray(), arrayRealVector.toArray()), false);
            }

            public int getRowDimension() {
                return arrayRealVector.getDimension();
            }

            public int getColumnDimension() {
                return arrayRealVector.getDimension();
            }
        };
    }
}

