/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.Fraction;
import org.apache.commons.math3.linear.AnyMatrix;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.BlockFieldMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.DefaultFieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldVector;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.NonSymmetricMatrixException;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixFormat;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixUtils {
    public static final RealMatrixFormat DEFAULT_FORMAT = RealMatrixFormat.getInstance();
    public static final RealMatrixFormat OCTAVE_FORMAT = new RealMatrixFormat("[", "]", "", "", "; ", ", ");

    private MatrixUtils() {
    }

    public static RealMatrix createRealMatrix(int n, int n2) {
        return n * n2 <= 4096 ? new Array2DRowRealMatrix(n, n2) : new BlockRealMatrix(n, n2);
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldMatrix(Field<T> field, int n, int n2) {
        return n * n2 <= 4096 ? new Array2DRowFieldMatrix<T>(field, n, n2) : new BlockFieldMatrix<T>(field, n, n2);
    }

    public static RealMatrix createRealMatrix(double[][] dArray) {
        if (dArray == null || dArray[0] == null) {
            throw new NullArgumentException();
        }
        return dArray.length * dArray[0].length <= 4096 ? new Array2DRowRealMatrix(dArray) : new BlockRealMatrix(dArray);
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldMatrix(T[][] TArray) {
        if (TArray == null || TArray[0] == null) {
            throw new NullArgumentException();
        }
        return TArray.length * TArray[0].length <= 4096 ? new Array2DRowFieldMatrix(TArray) : new BlockFieldMatrix(TArray);
    }

    public static RealMatrix createRealIdentityMatrix(int n) {
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            realMatrix.setEntry(i, i, 1.0);
        }
        return realMatrix;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldIdentityMatrix(Field<T> field, int n) {
        FieldElement fieldElement = (FieldElement)field.getZero();
        FieldElement fieldElement2 = (FieldElement)field.getOne();
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(field, n, n);
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = fieldElementArray[i];
            Arrays.fill(objectArray, fieldElement);
            objectArray[i] = fieldElement2;
        }
        return new Array2DRowFieldMatrix(field, fieldElementArray, false);
    }

    public static RealMatrix createRealDiagonalMatrix(double[] dArray) {
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(dArray.length, dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            realMatrix.setEntry(i, i, dArray[i]);
        }
        return realMatrix;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldDiagonalMatrix(T[] TArray) {
        FieldMatrix<T> fieldMatrix = MatrixUtils.createFieldMatrix(TArray[0].getField(), TArray.length, TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            fieldMatrix.setEntry(i, i, TArray[i]);
        }
        return fieldMatrix;
    }

    public static RealVector createRealVector(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        return new ArrayRealVector(dArray, true);
    }

    public static <T extends FieldElement<T>> FieldVector<T> createFieldVector(T[] TArray) {
        if (TArray == null) {
            throw new NullArgumentException();
        }
        if (TArray.length == 0) {
            throw new ZeroException((Localizable)LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        return new ArrayFieldVector(TArray[0].getField(), TArray, true);
    }

    public static RealMatrix createRowRealMatrix(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        int n = dArray.length;
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(1, n);
        for (int i = 0; i < n; ++i) {
            realMatrix.setEntry(0, i, dArray[i]);
        }
        return realMatrix;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createRowFieldMatrix(T[] TArray) {
        if (TArray == null) {
            throw new NullArgumentException();
        }
        int n = TArray.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        FieldMatrix<T> fieldMatrix = MatrixUtils.createFieldMatrix(TArray[0].getField(), 1, n);
        for (int i = 0; i < n; ++i) {
            fieldMatrix.setEntry(0, i, TArray[i]);
        }
        return fieldMatrix;
    }

    public static RealMatrix createColumnRealMatrix(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        int n = dArray.length;
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(n, 1);
        for (int i = 0; i < n; ++i) {
            realMatrix.setEntry(i, 0, dArray[i]);
        }
        return realMatrix;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createColumnFieldMatrix(T[] TArray) {
        if (TArray == null) {
            throw new NullArgumentException();
        }
        int n = TArray.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        FieldMatrix<T> fieldMatrix = MatrixUtils.createFieldMatrix(TArray[0].getField(), n, 1);
        for (int i = 0; i < n; ++i) {
            fieldMatrix.setEntry(i, 0, TArray[i]);
        }
        return fieldMatrix;
    }

    private static boolean isSymmetricInternal(RealMatrix realMatrix, double d, boolean bl) {
        int n = realMatrix.getRowDimension();
        if (n != realMatrix.getColumnDimension()) {
            if (bl) {
                throw new NonSquareMatrixException(n, realMatrix.getColumnDimension());
            }
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d2;
                double d3 = realMatrix.getEntry(i, j);
                if (!(FastMath.abs(d3 - (d2 = realMatrix.getEntry(j, i))) > FastMath.max(FastMath.abs(d3), FastMath.abs(d2)) * d)) continue;
                if (bl) {
                    throw new NonSymmetricMatrixException(i, j, d);
                }
                return false;
            }
        }
        return true;
    }

    public static void checkSymmetric(RealMatrix realMatrix, double d) {
        MatrixUtils.isSymmetricInternal(realMatrix, d, true);
    }

    public static boolean isSymmetric(RealMatrix realMatrix, double d) {
        return MatrixUtils.isSymmetricInternal(realMatrix, d, false);
    }

    public static void checkMatrixIndex(AnyMatrix anyMatrix, int n, int n2) {
        MatrixUtils.checkRowIndex(anyMatrix, n);
        MatrixUtils.checkColumnIndex(anyMatrix, n2);
    }

    public static void checkRowIndex(AnyMatrix anyMatrix, int n) {
        if (n < 0 || n >= anyMatrix.getRowDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.ROW_INDEX, (Number)n, 0, anyMatrix.getRowDimension() - 1);
        }
    }

    public static void checkColumnIndex(AnyMatrix anyMatrix, int n) {
        if (n < 0 || n >= anyMatrix.getColumnDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.COLUMN_INDEX, (Number)n, 0, anyMatrix.getColumnDimension() - 1);
        }
    }

    public static void checkSubMatrixIndex(AnyMatrix anyMatrix, int n, int n2, int n3, int n4) {
        MatrixUtils.checkRowIndex(anyMatrix, n);
        MatrixUtils.checkRowIndex(anyMatrix, n2);
        if (n2 < n) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)n2, n, false);
        }
        MatrixUtils.checkColumnIndex(anyMatrix, n3);
        MatrixUtils.checkColumnIndex(anyMatrix, n4);
        if (n4 < n3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, (Number)n4, n3, false);
        }
    }

    public static void checkSubMatrixIndex(AnyMatrix anyMatrix, int[] nArray, int[] nArray2) {
        if (nArray == null) {
            throw new NullArgumentException();
        }
        if (nArray2 == null) {
            throw new NullArgumentException();
        }
        if (nArray.length == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_SELECTED_ROW_INDEX_ARRAY);
        }
        if (nArray2.length == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_SELECTED_COLUMN_INDEX_ARRAY);
        }
        for (int n : nArray) {
            MatrixUtils.checkRowIndex(anyMatrix, n);
        }
        for (int n : nArray2) {
            MatrixUtils.checkColumnIndex(anyMatrix, n);
        }
    }

    public static void checkAdditionCompatible(AnyMatrix anyMatrix, AnyMatrix anyMatrix2) {
        if (anyMatrix.getRowDimension() != anyMatrix2.getRowDimension() || anyMatrix.getColumnDimension() != anyMatrix2.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(anyMatrix.getRowDimension(), anyMatrix.getColumnDimension(), anyMatrix2.getRowDimension(), anyMatrix2.getColumnDimension());
        }
    }

    public static void checkSubtractionCompatible(AnyMatrix anyMatrix, AnyMatrix anyMatrix2) {
        if (anyMatrix.getRowDimension() != anyMatrix2.getRowDimension() || anyMatrix.getColumnDimension() != anyMatrix2.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(anyMatrix.getRowDimension(), anyMatrix.getColumnDimension(), anyMatrix2.getRowDimension(), anyMatrix2.getColumnDimension());
        }
    }

    public static void checkMultiplicationCompatible(AnyMatrix anyMatrix, AnyMatrix anyMatrix2) {
        if (anyMatrix.getColumnDimension() != anyMatrix2.getRowDimension()) {
            throw new DimensionMismatchException(anyMatrix.getColumnDimension(), anyMatrix2.getRowDimension());
        }
    }

    public static Array2DRowRealMatrix fractionMatrixToRealMatrix(FieldMatrix<Fraction> fieldMatrix) {
        FractionMatrixConverter fractionMatrixConverter = new FractionMatrixConverter();
        fieldMatrix.walkInOptimizedOrder(fractionMatrixConverter);
        return fractionMatrixConverter.getConvertedMatrix();
    }

    public static Array2DRowRealMatrix bigFractionMatrixToRealMatrix(FieldMatrix<BigFraction> fieldMatrix) {
        BigFractionMatrixConverter bigFractionMatrixConverter = new BigFractionMatrixConverter();
        fieldMatrix.walkInOptimizedOrder(bigFractionMatrixConverter);
        return bigFractionMatrixConverter.getConvertedMatrix();
    }

    public static void serializeRealVector(RealVector realVector, ObjectOutputStream objectOutputStream) {
        int n = realVector.getDimension();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeDouble(realVector.getEntry(i));
        }
    }

    public static void deserializeRealVector(Object object, String string, ObjectInputStream objectInputStream) {
        try {
            int n = objectInputStream.readInt();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = objectInputStream.readDouble();
            }
            ArrayRealVector arrayRealVector = new ArrayRealVector(dArray, false);
            java.lang.reflect.Field field = object.getClass().getDeclaredField(string);
            field.setAccessible(true);
            field.set(object, arrayRealVector);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            IOException iOException = new IOException();
            iOException.initCause(noSuchFieldException);
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            IOException iOException = new IOException();
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
    }

    public static void serializeRealMatrix(RealMatrix realMatrix, ObjectOutputStream objectOutputStream) {
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                objectOutputStream.writeDouble(realMatrix.getEntry(i, j));
            }
        }
    }

    public static void deserializeRealMatrix(Object object, String string, ObjectInputStream objectInputStream) {
        try {
            Object object2;
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            double[][] dArray = new double[n][n2];
            for (int i = 0; i < n; ++i) {
                object2 = dArray[i];
                for (int j = 0; j < n2; ++j) {
                    object2[j] = objectInputStream.readDouble();
                }
            }
            Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(dArray, false);
            object2 = object.getClass().getDeclaredField(string);
            ((java.lang.reflect.Field)object2).setAccessible(true);
            ((java.lang.reflect.Field)object2).set(object, array2DRowRealMatrix);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            IOException iOException = new IOException();
            iOException.initCause(noSuchFieldException);
            throw iOException;
        }
        catch (IllegalAccessException illegalAccessException) {
            IOException iOException = new IOException();
            iOException.initCause(illegalAccessException);
            throw iOException;
        }
    }

    public static void solveLowerTriangularSystem(RealMatrix realMatrix, RealVector realVector) {
        if (realMatrix == null || realVector == null || realMatrix.getRowDimension() != realVector.getDimension()) {
            throw new DimensionMismatchException(realMatrix == null ? 0 : realMatrix.getRowDimension(), realVector == null ? 0 : realVector.getDimension());
        }
        if (realMatrix.getColumnDimension() != realMatrix.getRowDimension()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n = realMatrix.getRowDimension();
        for (int i = 0; i < n; ++i) {
            double d = realMatrix.getEntry(i, i);
            if (FastMath.abs(d) < Precision.SAFE_MIN) {
                throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
            }
            double d2 = realVector.getEntry(i) / d;
            realVector.setEntry(i, d2);
            for (int j = i + 1; j < n; ++j) {
                realVector.setEntry(j, realVector.getEntry(j) - d2 * realMatrix.getEntry(j, i));
            }
        }
    }

    public static void solveUpperTriangularSystem(RealMatrix realMatrix, RealVector realVector) {
        if (realMatrix == null || realVector == null || realMatrix.getRowDimension() != realVector.getDimension()) {
            throw new DimensionMismatchException(realMatrix == null ? 0 : realMatrix.getRowDimension(), realVector == null ? 0 : realVector.getDimension());
        }
        if (realMatrix.getColumnDimension() != realMatrix.getRowDimension()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n = realMatrix.getRowDimension();
        for (int i = n - 1; i > -1; --i) {
            double d = realMatrix.getEntry(i, i);
            if (FastMath.abs(d) < Precision.SAFE_MIN) {
                throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
            }
            double d2 = realVector.getEntry(i) / d;
            realVector.setEntry(i, d2);
            for (int j = i - 1; j > -1; --j) {
                realVector.setEntry(j, realVector.getEntry(j) - d2 * realMatrix.getEntry(j, i));
            }
        }
    }

    public static RealMatrix blockInverse(RealMatrix realMatrix, int n) {
        int n2 = realMatrix.getRowDimension();
        if (realMatrix.getColumnDimension() != n2) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n3 = n + 1;
        RealMatrix realMatrix2 = realMatrix.getSubMatrix(0, n, 0, n);
        RealMatrix realMatrix3 = realMatrix.getSubMatrix(0, n, n3, n2 - 1);
        RealMatrix realMatrix4 = realMatrix.getSubMatrix(n3, n2 - 1, 0, n);
        RealMatrix realMatrix5 = realMatrix.getSubMatrix(n3, n2 - 1, n3, n2 - 1);
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(realMatrix2);
        DecompositionSolver decompositionSolver = singularValueDecomposition.getSolver();
        if (!decompositionSolver.isNonSingular()) {
            throw new SingularMatrixException();
        }
        RealMatrix realMatrix6 = decompositionSolver.getInverse();
        SingularValueDecomposition singularValueDecomposition2 = new SingularValueDecomposition(realMatrix5);
        DecompositionSolver decompositionSolver2 = singularValueDecomposition2.getSolver();
        if (!decompositionSolver2.isNonSingular()) {
            throw new SingularMatrixException();
        }
        RealMatrix realMatrix7 = decompositionSolver2.getInverse();
        RealMatrix realMatrix8 = realMatrix2.subtract(realMatrix3.multiply(realMatrix7).multiply(realMatrix4));
        SingularValueDecomposition singularValueDecomposition3 = new SingularValueDecomposition(realMatrix8);
        DecompositionSolver decompositionSolver3 = singularValueDecomposition3.getSolver();
        if (!decompositionSolver3.isNonSingular()) {
            throw new SingularMatrixException();
        }
        RealMatrix realMatrix9 = decompositionSolver3.getInverse();
        RealMatrix realMatrix10 = realMatrix5.subtract(realMatrix4.multiply(realMatrix6).multiply(realMatrix3));
        SingularValueDecomposition singularValueDecomposition4 = new SingularValueDecomposition(realMatrix10);
        DecompositionSolver decompositionSolver4 = singularValueDecomposition4.getSolver();
        if (!decompositionSolver4.isNonSingular()) {
            throw new SingularMatrixException();
        }
        RealMatrix realMatrix11 = decompositionSolver4.getInverse();
        RealMatrix realMatrix12 = realMatrix6.multiply(realMatrix3).multiply(realMatrix11).scalarMultiply(-1.0);
        RealMatrix realMatrix13 = realMatrix7.multiply(realMatrix4).multiply(realMatrix9).scalarMultiply(-1.0);
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n2, n2);
        array2DRowRealMatrix.setSubMatrix(realMatrix9.getData(), 0, 0);
        array2DRowRealMatrix.setSubMatrix(realMatrix12.getData(), 0, n3);
        array2DRowRealMatrix.setSubMatrix(realMatrix13.getData(), n3, 0);
        array2DRowRealMatrix.setSubMatrix(realMatrix11.getData(), n3, n3);
        return array2DRowRealMatrix;
    }

    public static RealMatrix inverse(RealMatrix realMatrix) {
        return MatrixUtils.inverse(realMatrix, 0.0);
    }

    public static RealMatrix inverse(RealMatrix realMatrix, double d) {
        MathUtils.checkNotNull(realMatrix);
        if (!realMatrix.isSquare()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        if (realMatrix instanceof DiagonalMatrix) {
            return ((DiagonalMatrix)realMatrix).inverse(d);
        }
        QRDecomposition qRDecomposition = new QRDecomposition(realMatrix, d);
        return qRDecomposition.getSolver().getInverse();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigFractionMatrixConverter
    extends DefaultFieldMatrixPreservingVisitor<BigFraction> {
        private double[][] data;

        BigFractionMatrixConverter() {
            super(BigFraction.ZERO);
        }

        @Override
        public void start(int n, int n2, int n3, int n4, int n5, int n6) {
            this.data = new double[n][n2];
        }

        @Override
        public void visit(int n, int n2, BigFraction bigFraction) {
            this.data[n][n2] = bigFraction.doubleValue();
        }

        Array2DRowRealMatrix getConvertedMatrix() {
            return new Array2DRowRealMatrix(this.data, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FractionMatrixConverter
    extends DefaultFieldMatrixPreservingVisitor<Fraction> {
        private double[][] data;

        FractionMatrixConverter() {
            super(Fraction.ZERO);
        }

        @Override
        public void start(int n, int n2, int n3, int n4, int n5, int n6) {
            this.data = new double[n][n2];
        }

        @Override
        public void visit(int n, int n2, Fraction fraction) {
            this.data[n][n2] = fraction.doubleValue();
        }

        Array2DRowRealMatrix getConvertedMatrix() {
            return new Array2DRowRealMatrix(this.data, false);
        }
    }
}

