/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.IterativeLinearSolver;
import org.apache.commons.math3.linear.NonSquareOperatorException;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.IterationManager;
import org.apache.commons.math3.util.MathUtils;

public abstract class PreconditionedIterativeLinearSolver
extends IterativeLinearSolver {
    public PreconditionedIterativeLinearSolver(int n) {
        super(n);
    }

    public PreconditionedIterativeLinearSolver(IterationManager iterationManager) {
        super(iterationManager);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2) {
        MathUtils.checkNotNull(realVector2);
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, realVector2.copy());
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealVector realVector) {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        ((RealVector)arrayRealVector).set(0.0);
        return this.solveInPlace(realLinearOperator, null, realVector, arrayRealVector);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealVector realVector, RealVector realVector2) {
        MathUtils.checkNotNull(realVector2);
        return this.solveInPlace(realLinearOperator, null, realVector, realVector2.copy());
    }

    protected static void checkParameters(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2) {
        PreconditionedIterativeLinearSolver.checkParameters(realLinearOperator, realVector, realVector2);
        if (realLinearOperator2 != null) {
            if (realLinearOperator2.getColumnDimension() != realLinearOperator2.getRowDimension()) {
                throw new NonSquareOperatorException(realLinearOperator2.getColumnDimension(), realLinearOperator2.getRowDimension());
            }
            if (realLinearOperator2.getRowDimension() != realLinearOperator.getRowDimension()) {
                throw new DimensionMismatchException(realLinearOperator2.getRowDimension(), realLinearOperator.getRowDimension());
            }
        }
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector) {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, arrayRealVector);
    }

    public abstract RealVector solveInPlace(RealLinearOperator var1, RealLinearOperator var2, RealVector var3, RealVector var4);

    public RealVector solveInPlace(RealLinearOperator realLinearOperator, RealVector realVector, RealVector realVector2) {
        return this.solveInPlace(realLinearOperator, null, realVector, realVector2);
    }
}

