/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.Arrays;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;

public class QRDecomposition {
    private double[][] qrt;
    private double[] rDiag;
    private RealMatrix cachedQ;
    private RealMatrix cachedQT;
    private RealMatrix cachedR;
    private RealMatrix cachedH;
    private final double threshold;

    public QRDecomposition(RealMatrix realMatrix) {
        this(realMatrix, 0.0);
    }

    public QRDecomposition(RealMatrix realMatrix, double d) {
        this.threshold = d;
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        this.qrt = realMatrix.transpose().getData();
        this.rDiag = new double[FastMath.min(n, n2)];
        this.cachedQ = null;
        this.cachedQT = null;
        this.cachedR = null;
        this.cachedH = null;
        this.decompose(this.qrt);
    }

    protected void decompose(double[][] dArray) {
        for (int i = 0; i < FastMath.min(dArray.length, dArray[0].length); ++i) {
            this.performHouseholderReflection(i, dArray);
        }
    }

    protected void performHouseholderReflection(int n, double[][] dArray) {
        double d;
        double[] dArray2 = dArray[n];
        double d2 = 0.0;
        for (int i = n; i < dArray2.length; ++i) {
            double d3 = dArray2[i];
            d2 += d3 * d3;
        }
        this.rDiag[n] = d = dArray2[n] > 0.0 ? -FastMath.sqrt(d2) : FastMath.sqrt(d2);
        if (d != 0.0) {
            int n2 = n;
            dArray2[n2] = dArray2[n2] - d;
            for (int i = n + 1; i < dArray.length; ++i) {
                int n3;
                double[] dArray3 = dArray[i];
                double d4 = 0.0;
                for (n3 = n; n3 < dArray3.length; ++n3) {
                    d4 -= dArray3[n3] * dArray2[n3];
                }
                d4 /= d * dArray2[n];
                for (n3 = n; n3 < dArray3.length; ++n3) {
                    int n4 = n3;
                    dArray3[n4] = dArray3[n4] - d4 * dArray2[n3];
                }
            }
        }
    }

    public RealMatrix getR() {
        if (this.cachedR == null) {
            int n = this.qrt.length;
            int n2 = this.qrt[0].length;
            double[][] dArray = new double[n2][n];
            for (int i = FastMath.min(n2, n) - 1; i >= 0; --i) {
                dArray[i][i] = this.rDiag[i];
                for (int j = i + 1; j < n; ++j) {
                    dArray[i][j] = this.qrt[j][i];
                }
            }
            this.cachedR = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedR;
    }

    public RealMatrix getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public RealMatrix getQT() {
        if (this.cachedQT == null) {
            int n;
            int n2 = this.qrt.length;
            int n3 = this.qrt[0].length;
            double[][] dArray = new double[n3][n3];
            for (n = n3 - 1; n >= FastMath.min(n3, n2); --n) {
                dArray[n][n] = 1.0;
            }
            for (n = FastMath.min(n3, n2) - 1; n >= 0; --n) {
                double[] dArray2 = this.qrt[n];
                dArray[n][n] = 1.0;
                if (dArray2[n] == 0.0) continue;
                for (int i = n; i < n3; ++i) {
                    int n4;
                    double d = 0.0;
                    for (n4 = n; n4 < n3; ++n4) {
                        d -= dArray[i][n4] * dArray2[n4];
                    }
                    d /= this.rDiag[n] * dArray2[n];
                    for (n4 = n; n4 < n3; ++n4) {
                        double[] dArray3 = dArray[i];
                        int n5 = n4;
                        dArray3[n5] = dArray3[n5] + -d * dArray2[n4];
                    }
                }
            }
            this.cachedQT = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedQT;
    }

    public RealMatrix getH() {
        if (this.cachedH == null) {
            int n = this.qrt.length;
            int n2 = this.qrt[0].length;
            double[][] dArray = new double[n2][n];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < FastMath.min(i + 1, n); ++j) {
                    dArray[i][j] = this.qrt[j][i] / -this.rDiag[j];
                }
            }
            this.cachedH = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedH;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.qrt, this.rDiag, this.threshold);
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[][] qrt;
        private final double[] rDiag;
        private final double threshold;

        private Solver(double[][] dArray, double[] dArray2, double d) {
            this.qrt = dArray;
            this.rDiag = dArray2;
            this.threshold = d;
        }

        public boolean isNonSingular() {
            for (double d : this.rDiag) {
                if (!(FastMath.abs(d) <= this.threshold)) continue;
                return false;
            }
            return true;
        }

        public RealVector solve(RealVector realVector) {
            int n;
            int n2;
            int n3 = this.qrt.length;
            int n4 = this.qrt[0].length;
            if (realVector.getDimension() != n4) {
                throw new DimensionMismatchException(realVector.getDimension(), n4);
            }
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            double[] dArray = new double[n3];
            double[] dArray2 = realVector.toArray();
            for (n2 = 0; n2 < FastMath.min(n4, n3); ++n2) {
                double[] dArray3 = this.qrt[n2];
                double d = 0.0;
                for (n = n2; n < n4; ++n) {
                    d += dArray2[n] * dArray3[n];
                }
                d /= this.rDiag[n2] * dArray3[n2];
                for (n = n2; n < n4; ++n) {
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] + d * dArray3[n];
                }
            }
            for (n2 = this.rDiag.length - 1; n2 >= 0; --n2) {
                int n6 = n2;
                dArray2[n6] = dArray2[n6] / this.rDiag[n2];
                double d = dArray2[n2];
                double[] dArray4 = this.qrt[n2];
                dArray[n2] = d;
                for (n = 0; n < n2; ++n) {
                    int n7 = n;
                    dArray2[n7] = dArray2[n7] - d * dArray4[n];
                }
            }
            return new ArrayRealVector(dArray, false);
        }

        public RealMatrix solve(RealMatrix realMatrix) {
            int n = this.qrt.length;
            int n2 = this.qrt[0].length;
            if (realMatrix.getRowDimension() != n2) {
                throw new DimensionMismatchException(realMatrix.getRowDimension(), n2);
            }
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int n3 = realMatrix.getColumnDimension();
            int n4 = 52;
            int n5 = (n3 + 52 - 1) / 52;
            double[][] dArray = BlockRealMatrix.createBlocksLayout(n, n3);
            double[][] dArray2 = new double[realMatrix.getRowDimension()][52];
            double[] dArray3 = new double[52];
            for (int i = 0; i < n5; ++i) {
                int n6;
                int n7 = i * 52;
                int n8 = FastMath.min(n7 + 52, n3);
                int n9 = n8 - n7;
                realMatrix.copySubMatrix(0, n2 - 1, n7, n8 - 1, dArray2);
                for (n6 = 0; n6 < FastMath.min(n2, n); ++n6) {
                    int n10;
                    double[] dArray4;
                    double d;
                    int n11;
                    double[] dArray5 = this.qrt[n6];
                    double d2 = 1.0 / (this.rDiag[n6] * dArray5[n6]);
                    Arrays.fill(dArray3, 0, n9, 0.0);
                    for (n11 = n6; n11 < n2; ++n11) {
                        d = dArray5[n11];
                        dArray4 = dArray2[n11];
                        for (n10 = 0; n10 < n9; ++n10) {
                            int n12 = n10;
                            dArray3[n12] = dArray3[n12] + d * dArray4[n10];
                        }
                    }
                    n11 = 0;
                    while (n11 < n9) {
                        int n13 = n11++;
                        dArray3[n13] = dArray3[n13] * d2;
                    }
                    for (n11 = n6; n11 < n2; ++n11) {
                        d = dArray5[n11];
                        dArray4 = dArray2[n11];
                        for (n10 = 0; n10 < n9; ++n10) {
                            int n14 = n10;
                            dArray4[n14] = dArray4[n14] + dArray3[n10] * d;
                        }
                    }
                }
                for (n6 = this.rDiag.length - 1; n6 >= 0; --n6) {
                    int n15 = n6 / 52;
                    int n16 = n15 * 52;
                    double d = 1.0 / this.rDiag[n6];
                    double[] dArray6 = dArray2[n6];
                    double[] dArray7 = dArray[n15 * n5 + i];
                    int n17 = (n6 - n16) * n9;
                    for (int j = 0; j < n9; ++j) {
                        int n18 = j;
                        dArray6[n18] = dArray6[n18] * d;
                        dArray7[n17++] = dArray6[j];
                    }
                    double[] dArray8 = this.qrt[n6];
                    for (int j = 0; j < n6; ++j) {
                        double d3 = dArray8[j];
                        double[] dArray9 = dArray2[j];
                        for (int k = 0; k < n9; ++k) {
                            int n19 = k;
                            dArray9[n19] = dArray9[n19] - dArray6[k] * d3;
                        }
                    }
                }
            }
            return new BlockRealMatrix(n, n3, dArray, false);
        }

        public RealMatrix getInverse() {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.qrt[0].length));
        }
    }
}

