/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.HessenbergTransformer;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

class SchurTransformer {
    private static final int MAX_ITERATIONS = 100;
    private final double[][] matrixP;
    private final double[][] matrixT;
    private RealMatrix cachedP;
    private RealMatrix cachedT;
    private RealMatrix cachedPt;
    private final double epsilon = Precision.EPSILON;

    SchurTransformer(RealMatrix realMatrix) {
        if (!realMatrix.isSquare()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        HessenbergTransformer hessenbergTransformer = new HessenbergTransformer(realMatrix);
        this.matrixT = hessenbergTransformer.getH().getData();
        this.matrixP = hessenbergTransformer.getP().getData();
        this.cachedT = null;
        this.cachedP = null;
        this.cachedPt = null;
        this.transform();
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            this.cachedP = MatrixUtils.createRealMatrix(this.matrixP);
        }
        return this.cachedP;
    }

    public RealMatrix getPT() {
        if (this.cachedPt == null) {
            this.cachedPt = this.getP().transpose();
        }
        return this.cachedPt;
    }

    public RealMatrix getT() {
        if (this.cachedT == null) {
            this.cachedT = MatrixUtils.createRealMatrix(this.matrixT);
        }
        return this.cachedT;
    }

    private void transform() {
        int n = this.matrixT.length;
        double d = this.getNorm();
        ShiftInfo shiftInfo = new ShiftInfo();
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            int n4 = this.findSmallSubDiagonalElement(n3, d);
            if (n4 == n3) {
                double[] dArray = this.matrixT[n3];
                int n5 = n3--;
                dArray[n5] = dArray[n5] + shiftInfo.exShift;
                n2 = 0;
                continue;
            }
            if (n4 == n3 - 1) {
                double d2 = (this.matrixT[n3 - 1][n3 - 1] - this.matrixT[n3][n3]) / 2.0;
                double d3 = d2 * d2 + this.matrixT[n3][n3 - 1] * this.matrixT[n3 - 1][n3];
                double[] dArray = this.matrixT[n3];
                int n6 = n3;
                dArray[n6] = dArray[n6] + shiftInfo.exShift;
                double[] dArray2 = this.matrixT[n3 - 1];
                int n7 = n3 - 1;
                dArray2[n7] = dArray2[n7] + shiftInfo.exShift;
                if (d3 >= 0.0) {
                    int n8;
                    double d4 = FastMath.sqrt(FastMath.abs(d3));
                    d4 = d2 >= 0.0 ? d2 + d4 : d2 - d4;
                    double d5 = this.matrixT[n3][n3 - 1];
                    double d6 = FastMath.abs(d5) + FastMath.abs(d4);
                    d2 = d5 / d6;
                    d3 = d4 / d6;
                    double d7 = FastMath.sqrt(d2 * d2 + d3 * d3);
                    d2 /= d7;
                    d3 /= d7;
                    for (n8 = n3 - 1; n8 < n; ++n8) {
                        d4 = this.matrixT[n3 - 1][n8];
                        this.matrixT[n3 - 1][n8] = d3 * d4 + d2 * this.matrixT[n3][n8];
                        this.matrixT[n3][n8] = d3 * this.matrixT[n3][n8] - d2 * d4;
                    }
                    for (n8 = 0; n8 <= n3; ++n8) {
                        d4 = this.matrixT[n8][n3 - 1];
                        this.matrixT[n8][n3 - 1] = d3 * d4 + d2 * this.matrixT[n8][n3];
                        this.matrixT[n8][n3] = d3 * this.matrixT[n8][n3] - d2 * d4;
                    }
                    for (n8 = 0; n8 <= n - 1; ++n8) {
                        d4 = this.matrixP[n8][n3 - 1];
                        this.matrixP[n8][n3 - 1] = d3 * d4 + d2 * this.matrixP[n8][n3];
                        this.matrixP[n8][n3] = d3 * this.matrixP[n8][n3] - d2 * d4;
                    }
                }
                n3 -= 2;
                n2 = 0;
                continue;
            }
            this.computeShift(n4, n3, n2, shiftInfo);
            if (++n2 > 100) {
                throw new MaxCountExceededException((Localizable)LocalizedFormats.CONVERGENCE_FAILED, 100, new Object[0]);
            }
            double[] dArray = new double[3];
            int n9 = this.initQRStep(n4, n3, shiftInfo, dArray);
            this.performDoubleQRStep(n4, n9, n3, shiftInfo, dArray);
        }
    }

    private double getNorm() {
        double d = 0.0;
        for (int i = 0; i < this.matrixT.length; ++i) {
            for (int j = FastMath.max(i - 1, 0); j < this.matrixT.length; ++j) {
                d += FastMath.abs(this.matrixT[i][j]);
            }
        }
        return d;
    }

    private int findSmallSubDiagonalElement(int n, double d) {
        int n2;
        for (n2 = n; n2 > 0; --n2) {
            double d2 = FastMath.abs(this.matrixT[n2 - 1][n2 - 1]) + FastMath.abs(this.matrixT[n2][n2]);
            if (d2 == 0.0) {
                d2 = d;
            }
            if (FastMath.abs(this.matrixT[n2][n2 - 1]) < this.epsilon * d2) break;
        }
        return n2;
    }

    private void computeShift(int n, int n2, int n3, ShiftInfo shiftInfo) {
        double d;
        shiftInfo.x = this.matrixT[n2][n2];
        shiftInfo.w = 0.0;
        shiftInfo.y = 0.0;
        if (n < n2) {
            shiftInfo.y = this.matrixT[n2 - 1][n2 - 1];
            shiftInfo.w = this.matrixT[n2][n2 - 1] * this.matrixT[n2 - 1][n2];
        }
        if (n3 == 10) {
            shiftInfo.exShift += shiftInfo.x;
            int n4 = 0;
            while (n4 <= n2) {
                double[] dArray = this.matrixT[n4];
                int n5 = n4++;
                dArray[n5] = dArray[n5] - shiftInfo.x;
            }
            d = FastMath.abs(this.matrixT[n2][n2 - 1]) + FastMath.abs(this.matrixT[n2 - 1][n2 - 2]);
            shiftInfo.x = 0.75 * d;
            shiftInfo.y = 0.75 * d;
            shiftInfo.w = -0.4375 * d * d;
        }
        if (n3 == 30) {
            d = (shiftInfo.y - shiftInfo.x) / 2.0;
            if ((d = d * d + shiftInfo.w) > 0.0) {
                d = FastMath.sqrt(d);
                if (shiftInfo.y < shiftInfo.x) {
                    d = -d;
                }
                d = shiftInfo.x - shiftInfo.w / ((shiftInfo.y - shiftInfo.x) / 2.0 + d);
                int n6 = 0;
                while (n6 <= n2) {
                    double[] dArray = this.matrixT[n6];
                    int n7 = n6++;
                    dArray[n7] = dArray[n7] - d;
                }
                shiftInfo.exShift += d;
                shiftInfo.w = 0.964;
                shiftInfo.y = 0.964;
                shiftInfo.x = 0.964;
            }
        }
    }

    private int initQRStep(int n, int n2, ShiftInfo shiftInfo, double[] dArray) {
        int n3;
        for (n3 = n2 - 2; n3 >= n; --n3) {
            double d;
            double d2;
            double d3 = this.matrixT[n3][n3];
            double d4 = shiftInfo.x - d3;
            double d5 = shiftInfo.y - d3;
            dArray[0] = (d4 * d5 - shiftInfo.w) / this.matrixT[n3 + 1][n3] + this.matrixT[n3][n3 + 1];
            dArray[1] = this.matrixT[n3 + 1][n3 + 1] - d3 - d4 - d5;
            dArray[2] = this.matrixT[n3 + 2][n3 + 1];
            if (n3 == n || (d2 = FastMath.abs(this.matrixT[n3][n3 - 1]) * (FastMath.abs(dArray[1]) + FastMath.abs(dArray[2]))) < this.epsilon * (d = FastMath.abs(dArray[0]) * (FastMath.abs(this.matrixT[n3 - 1][n3 - 1]) + FastMath.abs(d3) + FastMath.abs(this.matrixT[n3 + 1][n3 + 1])))) break;
        }
        return n3;
    }

    private void performDoubleQRStep(int n, int n2, int n3, ShiftInfo shiftInfo, double[] dArray) {
        int n4;
        int n5 = this.matrixT.length;
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        for (n4 = n2; n4 <= n3 - 1; ++n4) {
            boolean bl;
            boolean bl2 = bl = n4 != n3 - 1;
            if (n4 != n2) {
                d = this.matrixT[n4][n4 - 1];
                d2 = this.matrixT[n4 + 1][n4 - 1];
                d3 = bl ? this.matrixT[n4 + 2][n4 - 1] : 0.0;
                shiftInfo.x = FastMath.abs(d) + FastMath.abs(d2) + FastMath.abs(d3);
                if (Precision.equals(shiftInfo.x, 0.0, this.epsilon)) continue;
                d /= shiftInfo.x;
                d2 /= shiftInfo.x;
                d3 /= shiftInfo.x;
            }
            double d4 = FastMath.sqrt(d * d + d2 * d2 + d3 * d3);
            if (d < 0.0) {
                d4 = -d4;
            }
            if (d4 == 0.0) continue;
            if (n4 != n2) {
                this.matrixT[n4][n4 - 1] = -d4 * shiftInfo.x;
            } else if (n != n2) {
                this.matrixT[n4][n4 - 1] = -this.matrixT[n4][n4 - 1];
            }
            shiftInfo.x = (d += d4) / d4;
            shiftInfo.y = d2 / d4;
            double d5 = d3 / d4;
            d2 /= d;
            d3 /= d;
            int n6 = n4;
            while (n6 < n5) {
                d = this.matrixT[n4][n6] + d2 * this.matrixT[n4 + 1][n6];
                if (bl) {
                    double[] dArray2 = this.matrixT[n4 + 2];
                    int n7 = n6;
                    dArray2[n7] = dArray2[n7] - (d += d3 * this.matrixT[n4 + 2][n6]) * d5;
                }
                double[] dArray3 = this.matrixT[n4];
                int n8 = n6;
                dArray3[n8] = dArray3[n8] - d * shiftInfo.x;
                double[] dArray4 = this.matrixT[n4 + 1];
                int n9 = n6++;
                dArray4[n9] = dArray4[n9] - d * shiftInfo.y;
            }
            for (n6 = 0; n6 <= FastMath.min(n3, n4 + 3); ++n6) {
                d = shiftInfo.x * this.matrixT[n6][n4] + shiftInfo.y * this.matrixT[n6][n4 + 1];
                if (bl) {
                    double[] dArray5 = this.matrixT[n6];
                    int n10 = n4 + 2;
                    dArray5[n10] = dArray5[n10] - (d += d5 * this.matrixT[n6][n4 + 2]) * d3;
                }
                double[] dArray6 = this.matrixT[n6];
                int n11 = n4;
                dArray6[n11] = dArray6[n11] - d;
                double[] dArray7 = this.matrixT[n6];
                int n12 = n4 + 1;
                dArray7[n12] = dArray7[n12] - d * d2;
            }
            n6 = this.matrixT.length - 1;
            for (int i = 0; i <= n6; ++i) {
                d = shiftInfo.x * this.matrixP[i][n4] + shiftInfo.y * this.matrixP[i][n4 + 1];
                if (bl) {
                    double[] dArray8 = this.matrixP[i];
                    int n13 = n4 + 2;
                    dArray8[n13] = dArray8[n13] - (d += d5 * this.matrixP[i][n4 + 2]) * d3;
                }
                double[] dArray9 = this.matrixP[i];
                int n14 = n4;
                dArray9[n14] = dArray9[n14] - d;
                double[] dArray10 = this.matrixP[i];
                int n15 = n4 + 1;
                dArray10[n15] = dArray10[n15] - d * d2;
            }
        }
        for (n4 = n2 + 2; n4 <= n3; ++n4) {
            this.matrixT[n4][n4 - 2] = 0.0;
            if (n4 <= n2 + 2) continue;
            this.matrixT[n4][n4 - 3] = 0.0;
        }
    }

    private static class ShiftInfo {
        double x;
        double y;
        double w;
        double exShift;

        private ShiftInfo() {
        }
    }
}

