/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.Clusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSCANClusterer<T extends Clusterable>
extends Clusterer<T> {
    private final double eps;
    private final int minPts;

    public DBSCANClusterer(double d, int n) {
        this(d, n, new EuclideanDistance());
    }

    public DBSCANClusterer(double d, int n, DistanceMeasure distanceMeasure) {
        super(distanceMeasure);
        if (d < 0.0) {
            throw new NotPositiveException(d);
        }
        if (n < 0) {
            throw new NotPositiveException(n);
        }
        this.eps = d;
        this.minPts = n;
    }

    public double getEps() {
        return this.eps;
    }

    public int getMinPts() {
        return this.minPts;
    }

    @Override
    public List<Cluster<T>> cluster(Collection<T> collection) {
        MathUtils.checkNotNull(collection);
        ArrayList<Cluster<T>> arrayList = new ArrayList<Cluster<T>>();
        HashMap<Clusterable, PointStatus> hashMap = new HashMap<Clusterable, PointStatus>();
        for (Clusterable clusterable : collection) {
            if (hashMap.get(clusterable) != null) continue;
            List<Clusterable> list = this.getNeighbors(clusterable, collection);
            if (list.size() >= this.minPts) {
                Cluster cluster = new Cluster();
                arrayList.add(this.expandCluster(cluster, clusterable, list, collection, hashMap));
                continue;
            }
            hashMap.put(clusterable, PointStatus.NOISE);
        }
        return arrayList;
    }

    private Cluster<T> expandCluster(Cluster<T> cluster, T t, List<T> list, Collection<T> collection, Map<Clusterable, PointStatus> map) {
        cluster.addPoint((Clusterable)t);
        map.put((Clusterable)t, PointStatus.PART_OF_CLUSTER);
        List<Object> list2 = new ArrayList<T>(list);
        for (int i = 0; i < list2.size(); ++i) {
            List<Clusterable> list3;
            Clusterable clusterable = (Clusterable)list2.get(i);
            PointStatus pointStatus = map.get(clusterable);
            if (pointStatus == null && (list3 = this.getNeighbors(clusterable, collection)).size() >= this.minPts) {
                list2 = this.merge(list2, list3);
            }
            if (pointStatus == PointStatus.PART_OF_CLUSTER) continue;
            map.put(clusterable, PointStatus.PART_OF_CLUSTER);
            cluster.addPoint(clusterable);
        }
        return cluster;
    }

    private List<T> getNeighbors(T t, Collection<T> collection) {
        ArrayList<Clusterable> arrayList = new ArrayList<Clusterable>();
        for (Clusterable clusterable : collection) {
            if (t == clusterable || !(this.distance(clusterable, (Clusterable)t) <= this.eps)) continue;
            arrayList.add(clusterable);
        }
        return arrayList;
    }

    private List<T> merge(List<T> list, List<T> list2) {
        HashSet<T> hashSet = new HashSet<T>(list);
        for (Clusterable clusterable : list2) {
            if (hashSet.contains(clusterable)) continue;
            list.add(clusterable);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PointStatus {
        NOISE,
        PART_OF_CLUSTER;

    }
}

