/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.clustering;

import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.Clusterer;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.clustering.evaluation.ClusterEvaluator;
import org.apache.commons.math3.ml.clustering.evaluation.SumOfClusterVariances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiKMeansPlusPlusClusterer<T extends Clusterable>
extends Clusterer<T> {
    private final KMeansPlusPlusClusterer<T> clusterer;
    private final int numTrials;
    private final ClusterEvaluator<T> evaluator;

    public MultiKMeansPlusPlusClusterer(KMeansPlusPlusClusterer<T> kMeansPlusPlusClusterer, int n) {
        this(kMeansPlusPlusClusterer, n, new SumOfClusterVariances(kMeansPlusPlusClusterer.getDistanceMeasure()));
    }

    public MultiKMeansPlusPlusClusterer(KMeansPlusPlusClusterer<T> kMeansPlusPlusClusterer, int n, ClusterEvaluator<T> clusterEvaluator) {
        super(kMeansPlusPlusClusterer.getDistanceMeasure());
        this.clusterer = kMeansPlusPlusClusterer;
        this.numTrials = n;
        this.evaluator = clusterEvaluator;
    }

    public KMeansPlusPlusClusterer<T> getClusterer() {
        return this.clusterer;
    }

    public int getNumTrials() {
        return this.numTrials;
    }

    public ClusterEvaluator<T> getClusterEvaluator() {
        return this.evaluator;
    }

    @Override
    public List<CentroidCluster<T>> cluster(Collection<T> collection) {
        List<CentroidCluster<T>> list = null;
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.numTrials; ++i) {
            List<CentroidCluster<T>> list2 = this.clusterer.cluster(collection);
            double d2 = this.evaluator.score(list2);
            if (!this.evaluator.isBetterScore(d2, d)) continue;
            list = list2;
            d = d2;
        }
        return list;
    }
}

