/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.distance;

import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class CanberraDistance
implements DistanceMeasure {
    private static final long serialVersionUID = -6972277381587032228L;

    public double compute(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = FastMath.abs(dArray[i] - dArray2[i]);
            double d3 = FastMath.abs(dArray[i]) + FastMath.abs(dArray2[i]);
            d += d2 == 0.0 && d3 == 0.0 ? 0.0 : d2 / d3;
        }
        return d;
    }
}

