/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.ml.neuralnet.Neuron;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Network
implements Iterable<Neuron>,
Serializable {
    private static final long serialVersionUID = 20130207L;
    private final ConcurrentHashMap<Long, Neuron> neuronMap = new ConcurrentHashMap();
    private final AtomicLong nextId;
    private final int featureSize;
    private final ConcurrentHashMap<Long, Set<Long>> linkMap = new ConcurrentHashMap();

    Network(long l, int n, Neuron[] neuronArray, long[][] lArray) {
        int n2;
        int n3 = neuronArray.length;
        if (n3 != lArray.length) {
            throw new MathIllegalStateException();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Neuron neuron = neuronArray[n2];
            long l2 = neuron.getIdentifier();
            if (l2 >= l) {
                throw new MathIllegalStateException();
            }
            this.neuronMap.put(l2, neuron);
            this.linkMap.put(l2, new HashSet());
        }
        for (n2 = 0; n2 < n3; ++n2) {
            long l3 = neuronArray[n2].getIdentifier();
            Set<Long> set = this.linkMap.get(l3);
            long[] lArray2 = lArray[n2];
            int n4 = lArray2.length;
            for (int i = 0; i < n4; ++i) {
                Long l4 = lArray2[i];
                if (this.neuronMap.get(l4) == null) {
                    throw new MathIllegalStateException();
                }
                this.addLinkToLinkSet(set, l4);
            }
        }
        this.nextId = new AtomicLong(l);
        this.featureSize = n;
    }

    public Network(long l, int n) {
        this.nextId = new AtomicLong(l);
        this.featureSize = n;
    }

    public synchronized Network copy() {
        Network network = new Network(this.nextId.get(), this.featureSize);
        for (Map.Entry<Long, Neuron> entry : this.neuronMap.entrySet()) {
            network.neuronMap.put(entry.getKey(), entry.getValue().copy());
        }
        for (Map.Entry<Long, Object> entry : this.linkMap.entrySet()) {
            network.linkMap.put(entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        return network;
    }

    @Override
    public Iterator<Neuron> iterator() {
        return this.neuronMap.values().iterator();
    }

    public Collection<Neuron> getNeurons(Comparator<Neuron> comparator) {
        ArrayList<Neuron> arrayList = new ArrayList<Neuron>();
        arrayList.addAll(this.neuronMap.values());
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public long createNeuron(double[] dArray) {
        if (dArray.length != this.featureSize) {
            throw new DimensionMismatchException(dArray.length, this.featureSize);
        }
        long l = this.createNextId();
        this.neuronMap.put(l, new Neuron(l, dArray));
        this.linkMap.put(l, new HashSet());
        return l;
    }

    public void deleteNeuron(Neuron neuron) {
        Collection<Neuron> collection = this.getNeighbours(neuron);
        for (Neuron neuron2 : collection) {
            this.deleteLink(neuron2, neuron);
        }
        this.neuronMap.remove(neuron.getIdentifier());
    }

    public int getFeaturesSize() {
        return this.featureSize;
    }

    public void addLink(Neuron neuron, Neuron neuron2) {
        long l = neuron.getIdentifier();
        long l2 = neuron2.getIdentifier();
        if (neuron != this.getNeuron(l)) {
            throw new NoSuchElementException(Long.toString(l));
        }
        if (neuron2 != this.getNeuron(l2)) {
            throw new NoSuchElementException(Long.toString(l2));
        }
        this.addLinkToLinkSet(this.linkMap.get(l), l2);
    }

    private void addLinkToLinkSet(Set<Long> set, long l) {
        set.add(l);
    }

    public void deleteLink(Neuron neuron, Neuron neuron2) {
        long l = neuron.getIdentifier();
        long l2 = neuron2.getIdentifier();
        if (neuron != this.getNeuron(l)) {
            throw new NoSuchElementException(Long.toString(l));
        }
        if (neuron2 != this.getNeuron(l2)) {
            throw new NoSuchElementException(Long.toString(l2));
        }
        this.deleteLinkFromLinkSet(this.linkMap.get(l), l2);
    }

    private void deleteLinkFromLinkSet(Set<Long> set, long l) {
        set.remove(l);
    }

    public Neuron getNeuron(long l) {
        Neuron neuron = this.neuronMap.get(l);
        if (neuron == null) {
            throw new NoSuchElementException(Long.toString(l));
        }
        return neuron;
    }

    public Collection<Neuron> getNeighbours(Iterable<Neuron> iterable) {
        return this.getNeighbours(iterable, null);
    }

    public Collection<Neuron> getNeighbours(Iterable<Neuron> iterable, Iterable<Neuron> iterable2) {
        HashSet hashSet = new HashSet();
        for (Neuron object : iterable) {
            hashSet.addAll(this.linkMap.get(object.getIdentifier()));
        }
        if (iterable2 != null) {
            for (Neuron neuron : iterable2) {
                hashSet.remove(neuron.getIdentifier());
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Long l : hashSet) {
            arrayList.add(this.getNeuron(l));
        }
        return arrayList;
    }

    public Collection<Neuron> getNeighbours(Neuron neuron) {
        return this.getNeighbours(neuron, null);
    }

    public Collection<Neuron> getNeighbours(Neuron neuron, Iterable<Neuron> iterable) {
        Set<Long> set = this.linkMap.get(neuron.getIdentifier());
        if (iterable != null) {
            for (Neuron object : iterable) {
                set.remove(object.getIdentifier());
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Long l : set) {
            arrayList.add(this.getNeuron(l));
        }
        return arrayList;
    }

    private Long createNextId() {
        return this.nextId.getAndIncrement();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new IllegalStateException();
    }

    private Object writeReplace() {
        Neuron[] neuronArray = this.neuronMap.values().toArray(new Neuron[0]);
        long[][] lArrayArray = new long[neuronArray.length][];
        for (int i = 0; i < neuronArray.length; ++i) {
            Collection<Neuron> collection = this.getNeighbours(neuronArray[i]);
            long[] lArray = new long[collection.size()];
            int n = 0;
            for (Neuron neuron : collection) {
                lArray[n] = neuron.getIdentifier();
                ++n;
            }
            lArrayArray[i] = lArray;
        }
        return new SerializationProxy(this.nextId.get(), this.featureSize, neuronArray, lArrayArray);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 20130207L;
        private final long nextId;
        private final int featureSize;
        private final Neuron[] neuronList;
        private final long[][] neighbourIdList;

        SerializationProxy(long l, int n, Neuron[] neuronArray, long[][] lArray) {
            this.nextId = l;
            this.featureSize = n;
            this.neuronList = neuronArray;
            this.neighbourIdList = lArray;
        }

        private Object readResolve() {
            return new Network(this.nextId, this.featureSize, this.neuronList, this.neighbourIdList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NeuronIdentifierComparator
    implements Comparator<Neuron>,
    Serializable {
        private static final long serialVersionUID = 20130207L;

        @Override
        public int compare(Neuron neuron, Neuron neuron2) {
            long l;
            long l2 = neuron.getIdentifier();
            return l2 < (l = neuron2.getIdentifier()) ? -1 : (l2 > l ? 1 : 0);
        }
    }
}

