/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.util.Precision;

public class Neuron
implements Serializable {
    private static final long serialVersionUID = 20130207L;
    private final long identifier;
    private final int size;
    private final AtomicReference<double[]> features;
    private final AtomicLong numberOfAttemptedUpdates = new AtomicLong(0L);
    private final AtomicLong numberOfSuccessfulUpdates = new AtomicLong(0L);

    Neuron(long l, double[] dArray) {
        this.identifier = l;
        this.size = dArray.length;
        this.features = new AtomicReference<Object>(dArray.clone());
    }

    public synchronized Neuron copy() {
        Neuron neuron = new Neuron(this.getIdentifier(), this.getFeatures());
        neuron.numberOfAttemptedUpdates.set(this.numberOfAttemptedUpdates.get());
        neuron.numberOfSuccessfulUpdates.set(this.numberOfSuccessfulUpdates.get());
        return neuron;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public int getSize() {
        return this.size;
    }

    public double[] getFeatures() {
        return (double[])this.features.get().clone();
    }

    public boolean compareAndSetFeatures(double[] dArray, double[] dArray2) {
        if (dArray2.length != this.size) {
            throw new DimensionMismatchException(dArray2.length, this.size);
        }
        double[] dArray3 = this.features.get();
        if (!this.containSameValues(dArray3, dArray)) {
            return false;
        }
        this.numberOfAttemptedUpdates.incrementAndGet();
        if (this.features.compareAndSet(dArray3, (double[])dArray2.clone())) {
            this.numberOfSuccessfulUpdates.incrementAndGet();
            return true;
        }
        return false;
    }

    public long getNumberOfAttemptedUpdates() {
        return this.numberOfAttemptedUpdates.get();
    }

    public long getNumberOfSuccessfulUpdates() {
        return this.numberOfSuccessfulUpdates.get();
    }

    private boolean containSameValues(double[] dArray, double[] dArray2) {
        if (dArray2.length != this.size) {
            throw new DimensionMismatchException(dArray2.length, this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            if (Precision.equals(dArray[i], dArray2[i])) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new IllegalStateException();
    }

    private Object writeReplace() {
        return new SerializationProxy(this.identifier, this.features.get());
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 20130207L;
        private final double[] features;
        private final long identifier;

        SerializationProxy(long l, double[] dArray) {
            this.identifier = l;
            this.features = dArray;
        }

        private Object readResolve() {
            return new Neuron(this.identifier, this.features);
        }
    }
}

