/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.sofm;

import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.ml.neuralnet.sofm.LearningFactorFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.util.ExponentialDecayFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.util.QuasiSigmoidDecayFunction;

public class LearningFactorFunctionFactory {
    private LearningFactorFunctionFactory() {
    }

    public static LearningFactorFunction exponentialDecay(final double d, final double d2, final long l) {
        if (d <= 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        return new LearningFactorFunction(){
            private final ExponentialDecayFunction decay;
            {
                this.decay = new ExponentialDecayFunction(d, d2, l);
            }

            public double value(long l2) {
                return this.decay.value(l2);
            }
        };
    }

    public static LearningFactorFunction quasiSigmoidDecay(final double d, final double d2, final long l) {
        if (d <= 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        return new LearningFactorFunction(){
            private final QuasiSigmoidDecayFunction decay;
            {
                this.decay = new QuasiSigmoidDecayFunction(d, d2, l);
            }

            public double value(long l2) {
                return this.decay.value(l2);
            }
        };
    }
}

