/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.sofm.util;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.FastMath;

public class ExponentialDecayFunction {
    private final double a;
    private final double oneOverB;

    public ExponentialDecayFunction(double d, double d2, long l) {
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException(d);
        }
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException(d2);
        }
        if (d2 >= d) {
            throw new NumberIsTooLargeException(d2, (Number)d, false);
        }
        if (l <= 0L) {
            throw new NotStrictlyPositiveException(l);
        }
        this.a = d;
        this.oneOverB = -FastMath.log(d2 / d) / (double)l;
    }

    public double value(long l) {
        return this.a * FastMath.exp((double)(-l) * this.oneOverB);
    }
}

