/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.neuralnet.MapUtils;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder;
import org.apache.commons.math3.ml.neuralnet.twod.util.MapDataVisualization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothedDataHistogram
implements MapDataVisualization {
    private final int smoothingBins;
    private final DistanceMeasure distance;
    private final double membershipNormalization;

    public SmoothedDataHistogram(int n, DistanceMeasure distanceMeasure) {
        this.smoothingBins = n;
        this.distance = distanceMeasure;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)(n - i);
        }
        this.membershipNormalization = 1.0 / d;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D neuronSquareMesh2D, Iterable<double[]> iterable) {
        int n;
        int n2 = neuronSquareMesh2D.getNumberOfRows();
        int n3 = n2 * (n = neuronSquareMesh2D.getNumberOfColumns());
        if (n3 < this.smoothingBins) {
            throw new NumberIsTooSmallException(n3, (Number)this.smoothingBins, true);
        }
        LocationFinder locationFinder = new LocationFinder(neuronSquareMesh2D);
        double[][] dArray = new double[n2][n];
        for (double[] dArray2 : iterable) {
            Neuron[] neuronArray = MapUtils.sort(dArray2, neuronSquareMesh2D.getNetwork(), this.distance);
            for (int i = 0; i < this.smoothingBins; ++i) {
                LocationFinder.Location location = locationFinder.getLocation(neuronArray[i]);
                int n4 = location.getRow();
                int n5 = location.getColumn();
                double[] dArray3 = dArray[n4];
                int n6 = n5;
                dArray3[n6] = dArray3[n6] + (double)(this.smoothingBins - i) * this.membershipNormalization;
            }
        }
        return dArray;
    }
}

