/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.neuralnet.MapUtils;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder;
import org.apache.commons.math3.ml.neuralnet.twod.util.MapDataVisualization;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopographicErrorHistogram
implements MapDataVisualization {
    private final DistanceMeasure distance;
    private final boolean relativeCount;

    public TopographicErrorHistogram(boolean bl, DistanceMeasure distanceMeasure) {
        this.relativeCount = bl;
        this.distance = distanceMeasure;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D neuronSquareMesh2D, Iterable<double[]> iterable) {
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        Network network = neuronSquareMesh2D.getNetwork();
        LocationFinder locationFinder = new LocationFinder(neuronSquareMesh2D);
        int[][] nArray = new int[n][n2];
        double[][] dArray = new double[n][n2];
        for (double[] dArray2 : iterable) {
            Pair<Neuron, Neuron> pair = MapUtils.findBestAndSecondBest(dArray2, neuronSquareMesh2D, this.distance);
            Neuron neuron = pair.getFirst();
            LocationFinder.Location location = locationFinder.getLocation(neuron);
            int n3 = location.getRow();
            int n4 = location.getColumn();
            int[] nArray2 = nArray[n3];
            int n5 = n4;
            nArray2[n5] = nArray2[n5] + 1;
            if (network.getNeighbours(neuron).contains(pair.getSecond())) continue;
            double[] dArray3 = dArray[n3];
            int n6 = n4;
            dArray3[n6] = dArray3[n6] + 1.0;
        }
        if (this.relativeCount) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double[] dArray4 = dArray[i];
                    int n7 = j;
                    dArray4[n7] = dArray4[n7] / (double)nArray[i][j];
                }
            }
        }
        return dArray;
    }
}

