/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.commons.math3.analysis.solvers.BracketingNthOrderBrentSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.FirstOrderIntegrator;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.events.EventState;
import org.apache.commons.math3.ode.sampling.AbstractStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Incrementor;
import org.apache.commons.math3.util.IntegerSequence;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntegrator
implements FirstOrderIntegrator {
    protected Collection<StepHandler> stepHandlers;
    protected double stepStart;
    protected double stepSize;
    protected boolean isLastStep;
    protected boolean resetOccurred;
    private Collection<EventState> eventsStates;
    private boolean statesInitialized;
    private final String name;
    private IntegerSequence.Incrementor evaluations;
    private transient ExpandableStatefulODE expandable;

    public AbstractIntegrator(String string) {
        this.name = string;
        this.stepHandlers = new ArrayList<StepHandler>();
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
        this.eventsStates = new ArrayList<EventState>();
        this.statesInitialized = false;
        this.evaluations = IntegerSequence.Incrementor.create().withMaximalCount(Integer.MAX_VALUE);
    }

    protected AbstractIntegrator() {
        this(null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addStepHandler(StepHandler stepHandler) {
        this.stepHandlers.add(stepHandler);
    }

    @Override
    public Collection<StepHandler> getStepHandlers() {
        return Collections.unmodifiableCollection(this.stepHandlers);
    }

    @Override
    public void clearStepHandlers() {
        this.stepHandlers.clear();
    }

    @Override
    public void addEventHandler(EventHandler eventHandler, double d, double d2, int n) {
        this.addEventHandler(eventHandler, d, d2, n, new BracketingNthOrderBrentSolver(d2, 5));
    }

    @Override
    public void addEventHandler(EventHandler eventHandler, double d, double d2, int n, UnivariateSolver univariateSolver) {
        this.eventsStates.add(new EventState(eventHandler, d, d2, n, univariateSolver));
    }

    @Override
    public Collection<EventHandler> getEventHandlers() {
        ArrayList<EventHandler> arrayList = new ArrayList<EventHandler>(this.eventsStates.size());
        for (EventState eventState : this.eventsStates) {
            arrayList.add(eventState.getEventHandler());
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public void clearEventHandlers() {
        this.eventsStates.clear();
    }

    @Override
    public double getCurrentStepStart() {
        return this.stepStart;
    }

    @Override
    public double getCurrentSignedStepsize() {
        return this.stepSize;
    }

    @Override
    public void setMaxEvaluations(int n) {
        this.evaluations = this.evaluations.withMaximalCount(n < 0 ? Integer.MAX_VALUE : n);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    protected void initIntegration(double d, double[] dArray, double d2) {
        this.evaluations = this.evaluations.withStart(0);
        for (EventState object : this.eventsStates) {
            object.setExpandable(this.expandable);
            object.getEventHandler().init(d, dArray, d2);
        }
        for (StepHandler stepHandler : this.stepHandlers) {
            stepHandler.init(d, dArray, d2);
        }
        this.setStateInitialized(false);
    }

    protected void setEquations(ExpandableStatefulODE expandableStatefulODE) {
        this.expandable = expandableStatefulODE;
    }

    protected ExpandableStatefulODE getExpandable() {
        return this.expandable;
    }

    @Deprecated
    protected Incrementor getEvaluationsCounter() {
        return Incrementor.wrap(this.evaluations);
    }

    protected IntegerSequence.Incrementor getCounter() {
        return this.evaluations;
    }

    @Override
    public double integrate(FirstOrderDifferentialEquations firstOrderDifferentialEquations, double d, double[] dArray, double d2, double[] dArray2) {
        if (dArray.length != firstOrderDifferentialEquations.getDimension()) {
            throw new DimensionMismatchException(dArray.length, firstOrderDifferentialEquations.getDimension());
        }
        if (dArray2.length != firstOrderDifferentialEquations.getDimension()) {
            throw new DimensionMismatchException(dArray2.length, firstOrderDifferentialEquations.getDimension());
        }
        ExpandableStatefulODE expandableStatefulODE = new ExpandableStatefulODE(firstOrderDifferentialEquations);
        expandableStatefulODE.setTime(d);
        expandableStatefulODE.setPrimaryState(dArray);
        this.integrate(expandableStatefulODE, d2);
        System.arraycopy(expandableStatefulODE.getPrimaryState(), 0, dArray2, 0, dArray2.length);
        return expandableStatefulODE.getTime();
    }

    public abstract void integrate(ExpandableStatefulODE var1, double var2);

    public void computeDerivatives(double d, double[] dArray, double[] dArray2) {
        this.evaluations.increment();
        this.expandable.computeDerivatives(d, dArray, dArray2);
    }

    protected void setStateInitialized(boolean bl) {
        this.statesInitialized = bl;
    }

    protected double acceptStep(AbstractStepInterpolator abstractStepInterpolator, double[] dArray, double[] dArray2, double d) {
        Object object;
        double d2 = abstractStepInterpolator.getGlobalPreviousTime();
        double d3 = abstractStepInterpolator.getGlobalCurrentTime();
        if (!this.statesInitialized) {
            for (EventState object22 : this.eventsStates) {
                object22.reinitializeBegin(abstractStepInterpolator);
            }
            this.statesInitialized = true;
        }
        final int n = abstractStepInterpolator.isForward() ? 1 : -1;
        TreeSet<EventState> treeSet = new TreeSet<EventState>(new Comparator<EventState>(){

            @Override
            public int compare(EventState eventState, EventState eventState2) {
                return n * Double.compare(eventState.getEventTime(), eventState2.getEventTime());
            }
        });
        for (EventState n3 : this.eventsStates) {
            if (!n3.evaluateStep(abstractStepInterpolator)) continue;
            treeSet.add(n3);
        }
        while (!treeSet.isEmpty()) {
            EventState n3;
            object = treeSet.iterator();
            n3 = object.next();
            object.remove();
            double d4 = n3.getEventTime();
            abstractStepInterpolator.setSoftPreviousTime(d2);
            abstractStepInterpolator.setSoftCurrentTime(d4);
            abstractStepInterpolator.setInterpolatedTime(d4);
            double[] dArray3 = new double[dArray.length];
            this.expandable.getPrimaryMapper().insertEquationData(abstractStepInterpolator.getInterpolatedState(), dArray3);
            int n2 = 0;
            for (EquationsMapper equationsMapper : this.expandable.getSecondaryMappers()) {
                equationsMapper.insertEquationData(abstractStepInterpolator.getInterpolatedSecondaryState(n2++), dArray3);
            }
            for (EventState stepHandler : this.eventsStates) {
                stepHandler.stepAccepted(d4, dArray3);
                this.isLastStep = this.isLastStep || stepHandler.stop();
            }
            for (StepHandler stepHandler : this.stepHandlers) {
                stepHandler.handleStep(abstractStepInterpolator, this.isLastStep);
            }
            if (this.isLastStep) {
                System.arraycopy(dArray3, 0, dArray, 0, dArray.length);
                return d4;
            }
            boolean bl = false;
            this.resetOccurred = false;
            bl = n3.reset(d4, dArray3);
            if (bl) {
                abstractStepInterpolator.setInterpolatedTime(d4);
                System.arraycopy(dArray3, 0, dArray, 0, dArray.length);
                this.computeDerivatives(d4, dArray, dArray2);
                this.resetOccurred = true;
                return d4;
            }
            d2 = d4;
            abstractStepInterpolator.setSoftPreviousTime(d4);
            abstractStepInterpolator.setSoftCurrentTime(d3);
            if (!n3.evaluateStep(abstractStepInterpolator)) continue;
            treeSet.add(n3);
        }
        abstractStepInterpolator.setInterpolatedTime(d3);
        object = new double[dArray.length];
        this.expandable.getPrimaryMapper().insertEquationData(abstractStepInterpolator.getInterpolatedState(), (double[])object);
        int n3 = 0;
        for (EquationsMapper equationsMapper : this.expandable.getSecondaryMappers()) {
            equationsMapper.insertEquationData(abstractStepInterpolator.getInterpolatedSecondaryState(n3++), (double[])object);
        }
        for (EventState stepHandler : this.eventsStates) {
            stepHandler.stepAccepted(d3, (double[])object);
            this.isLastStep = this.isLastStep || stepHandler.stop();
        }
        this.isLastStep = this.isLastStep || Precision.equals(d3, d, 1);
        for (StepHandler stepHandler : this.stepHandlers) {
            stepHandler.handleStep(abstractStepInterpolator, this.isLastStep);
        }
        return d3;
    }

    protected void sanityChecks(ExpandableStatefulODE expandableStatefulODE, double d) {
        double d2 = 1000.0 * FastMath.ulp(FastMath.max(FastMath.abs(expandableStatefulODE.getTime()), FastMath.abs(d)));
        double d3 = FastMath.abs(expandableStatefulODE.getTime() - d);
        if (d3 <= d2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.TOO_SMALL_INTEGRATION_INTERVAL, (Number)d3, d2, false);
        }
    }
}

