/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.ode.Parameterizable;
import org.apache.commons.math3.ode.UnknownParameterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParameterizable
implements Parameterizable {
    private final Collection<String> parametersNames = new ArrayList<String>();

    protected AbstractParameterizable(String ... stringArray) {
        for (String string : stringArray) {
            this.parametersNames.add(string);
        }
    }

    protected AbstractParameterizable(Collection<String> collection) {
        this.parametersNames.addAll(collection);
    }

    @Override
    public Collection<String> getParametersNames() {
        return this.parametersNames;
    }

    @Override
    public boolean isSupported(String string) {
        for (String string2 : this.parametersNames) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void complainIfNotSupported(String string) {
        if (!this.isSupported(string)) {
            throw new UnknownParameterException(string);
        }
    }
}

