/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldSecondaryEquations;
import org.apache.commons.math3.ode.FirstOrderFieldDifferentialEquations;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldExpandableODE<T extends RealFieldElement<T>> {
    private final FirstOrderFieldDifferentialEquations<T> primary;
    private List<FieldSecondaryEquations<T>> components;
    private FieldEquationsMapper<T> mapper;

    public FieldExpandableODE(FirstOrderFieldDifferentialEquations<T> firstOrderFieldDifferentialEquations) {
        this.primary = firstOrderFieldDifferentialEquations;
        this.components = new ArrayList<FieldSecondaryEquations<T>>();
        this.mapper = new FieldEquationsMapper(null, firstOrderFieldDifferentialEquations.getDimension());
    }

    public FieldEquationsMapper<T> getMapper() {
        return this.mapper;
    }

    public int addSecondaryEquations(FieldSecondaryEquations<T> fieldSecondaryEquations) {
        this.components.add(fieldSecondaryEquations);
        this.mapper = new FieldEquationsMapper<T>(this.mapper, fieldSecondaryEquations.getDimension());
        return this.components.size();
    }

    public void init(T t, T[] TArray, T t2) {
        int n = 0;
        RealFieldElement[] realFieldElementArray = this.mapper.extractEquationData(n, (RealFieldElement[])TArray);
        this.primary.init((RealFieldElement)t, realFieldElementArray, (RealFieldElement)t2);
        while (++n < this.mapper.getNumberOfEquations()) {
            RealFieldElement[] realFieldElementArray2 = this.mapper.extractEquationData(n, (RealFieldElement[])TArray);
            this.components.get(n - 1).init((RealFieldElement)t, realFieldElementArray, realFieldElementArray2, (RealFieldElement)t2);
        }
    }

    public T[] computeDerivatives(T t, T[] TArray) {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(t.getField(), this.mapper.getTotalDimension());
        int n = 0;
        RealFieldElement[] realFieldElementArray2 = this.mapper.extractEquationData(n, (RealFieldElement[])TArray);
        RealFieldElement[] realFieldElementArray3 = this.primary.computeDerivatives((RealFieldElement)t, realFieldElementArray2);
        this.mapper.insertEquationData(n, realFieldElementArray3, realFieldElementArray);
        while (++n < this.mapper.getNumberOfEquations()) {
            RealFieldElement[] realFieldElementArray4 = this.mapper.extractEquationData(n, (RealFieldElement[])TArray);
            RealFieldElement[] realFieldElementArray5 = this.components.get(n - 1).computeDerivatives((RealFieldElement)t, realFieldElementArray2, realFieldElementArray3, realFieldElementArray4);
            this.mapper.insertEquationData(n, realFieldElementArray5, realFieldElementArray);
        }
        return realFieldElementArray;
    }
}

