/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldODEState<T extends RealFieldElement<T>> {
    private final T time;
    private final T[] state;
    private final T[][] secondaryState;

    public FieldODEState(T t, T[] TArray) {
        this((RealFieldElement)t, (RealFieldElement[])TArray, null);
    }

    public FieldODEState(T t, T[] TArray, T[][] TArray2) {
        this.time = t;
        this.state = (RealFieldElement[])TArray.clone();
        this.secondaryState = this.copy(t.getField(), (RealFieldElement[][])TArray2);
    }

    protected T[][] copy(Field<T> field, T[][] TArray) {
        if (TArray == null) {
            return null;
        }
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(field, TArray.length, -1);
        for (int i = 0; i < TArray.length; ++i) {
            realFieldElementArray[i] = (RealFieldElement[])TArray[i].clone();
        }
        return realFieldElementArray;
    }

    public T getTime() {
        return this.time;
    }

    public int getStateDimension() {
        return this.state.length;
    }

    public T[] getState() {
        return (RealFieldElement[])this.state.clone();
    }

    public int getNumberOfSecondaryStates() {
        return this.secondaryState == null ? 0 : this.secondaryState.length;
    }

    public int getSecondaryStateDimension(int n) {
        return n == 0 ? this.state.length : this.secondaryState[n - 1].length;
    }

    public T[] getSecondaryState(int n) {
        return n == 0 ? (RealFieldElement[])this.state.clone() : (RealFieldElement[])this.secondaryState[n - 1].clone();
    }
}

