/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.MainStateJacobianProvider;
import org.apache.commons.math3.ode.ParameterConfiguration;
import org.apache.commons.math3.ode.ParameterJacobianProvider;
import org.apache.commons.math3.ode.ParameterJacobianWrapper;
import org.apache.commons.math3.ode.ParameterizedODE;
import org.apache.commons.math3.ode.SecondaryEquations;
import org.apache.commons.math3.ode.UnknownParameterException;

public class JacobianMatrices {
    private ExpandableStatefulODE efode = null;
    private int index = -1;
    private MainStateJacobianProvider jode;
    private ParameterizedODE pode;
    private int stateDim;
    private ParameterConfiguration[] selectedParameters;
    private List<ParameterJacobianProvider> jacobianProviders;
    private int paramDim;
    private boolean dirtyParameter;
    private double[] matricesData;

    public JacobianMatrices(FirstOrderDifferentialEquations firstOrderDifferentialEquations, double[] dArray, String ... stringArray) {
        this(new MainStateJacobianWrapper(firstOrderDifferentialEquations, dArray), stringArray);
    }

    public JacobianMatrices(MainStateJacobianProvider mainStateJacobianProvider, String ... stringArray) {
        int n;
        this.jode = mainStateJacobianProvider;
        this.pode = null;
        this.stateDim = mainStateJacobianProvider.getDimension();
        if (stringArray == null) {
            this.selectedParameters = null;
            this.paramDim = 0;
        } else {
            this.selectedParameters = new ParameterConfiguration[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                this.selectedParameters[n] = new ParameterConfiguration(stringArray[n], Double.NaN);
            }
            this.paramDim = stringArray.length;
        }
        this.dirtyParameter = false;
        this.jacobianProviders = new ArrayList<ParameterJacobianProvider>();
        this.matricesData = new double[(this.stateDim + this.paramDim) * this.stateDim];
        for (n = 0; n < this.stateDim; ++n) {
            this.matricesData[n * (this.stateDim + 1)] = 1.0;
        }
    }

    public void registerVariationalEquations(ExpandableStatefulODE expandableStatefulODE) {
        MainStateJacobianProvider mainStateJacobianProvider;
        FirstOrderDifferentialEquations firstOrderDifferentialEquations = mainStateJacobianProvider = this.jode instanceof MainStateJacobianWrapper ? ((MainStateJacobianWrapper)this.jode).ode : this.jode;
        if (expandableStatefulODE.getPrimary() != mainStateJacobianProvider) {
            throw new MismatchedEquations();
        }
        this.efode = expandableStatefulODE;
        this.index = this.efode.addSecondaryEquations(new JacobiansSecondaryEquations());
        this.efode.setSecondaryState(this.index, this.matricesData);
    }

    public void addParameterJacobianProvider(ParameterJacobianProvider parameterJacobianProvider) {
        this.jacobianProviders.add(parameterJacobianProvider);
    }

    public void setParameterizedODE(ParameterizedODE parameterizedODE) {
        this.pode = parameterizedODE;
        this.dirtyParameter = true;
    }

    public void setParameterStep(String string, double d) {
        for (ParameterConfiguration parameterConfiguration : this.selectedParameters) {
            if (!string.equals(parameterConfiguration.getParameterName())) continue;
            parameterConfiguration.setHP(d);
            this.dirtyParameter = true;
            return;
        }
        throw new UnknownParameterException(string);
    }

    public void setInitialMainStateJacobian(double[][] dArray) {
        this.checkDimension(this.stateDim, dArray);
        this.checkDimension(this.stateDim, dArray[0]);
        int n = 0;
        for (double[] dArray2 : dArray) {
            System.arraycopy(dArray2, 0, this.matricesData, n, this.stateDim);
            n += this.stateDim;
        }
        if (this.efode != null) {
            this.efode.setSecondaryState(this.index, this.matricesData);
        }
    }

    public void setInitialParameterJacobian(String string, double[] dArray) {
        this.checkDimension(this.stateDim, dArray);
        int n = this.stateDim * this.stateDim;
        for (ParameterConfiguration parameterConfiguration : this.selectedParameters) {
            if (string.equals(parameterConfiguration.getParameterName())) {
                System.arraycopy(dArray, 0, this.matricesData, n, this.stateDim);
                if (this.efode != null) {
                    this.efode.setSecondaryState(this.index, this.matricesData);
                }
                return;
            }
            n += this.stateDim;
        }
        throw new UnknownParameterException(string);
    }

    public void getCurrentMainSetJacobian(double[][] dArray) {
        double[] dArray2 = this.efode.getSecondaryState(this.index);
        int n = 0;
        for (int i = 0; i < this.stateDim; ++i) {
            System.arraycopy(dArray2, n, dArray[i], 0, this.stateDim);
            n += this.stateDim;
        }
    }

    public void getCurrentParameterJacobian(String string, double[] dArray) {
        double[] dArray2 = this.efode.getSecondaryState(this.index);
        int n = this.stateDim * this.stateDim;
        for (ParameterConfiguration parameterConfiguration : this.selectedParameters) {
            if (parameterConfiguration.getParameterName().equals(string)) {
                System.arraycopy(dArray2, n, dArray, 0, this.stateDim);
                return;
            }
            n += this.stateDim;
        }
    }

    private void checkDimension(int n, Object object) {
        int n2;
        int n3 = n2 = object == null ? 0 : Array.getLength(object);
        if (n2 != n) {
            throw new DimensionMismatchException(n2, n);
        }
    }

    public static class MismatchedEquations
    extends MathIllegalArgumentException {
        private static final long serialVersionUID = 20120902L;

        public MismatchedEquations() {
            super(LocalizedFormats.UNMATCHED_ODE_IN_EXPANDED_SET, new Object[0]);
        }
    }

    private static class MainStateJacobianWrapper
    implements MainStateJacobianProvider {
        private final FirstOrderDifferentialEquations ode;
        private final double[] hY;

        MainStateJacobianWrapper(FirstOrderDifferentialEquations firstOrderDifferentialEquations, double[] dArray) {
            this.ode = firstOrderDifferentialEquations;
            this.hY = (double[])dArray.clone();
            if (dArray.length != firstOrderDifferentialEquations.getDimension()) {
                throw new DimensionMismatchException(firstOrderDifferentialEquations.getDimension(), dArray.length);
            }
        }

        public int getDimension() {
            return this.ode.getDimension();
        }

        public void computeDerivatives(double d, double[] dArray, double[] dArray2) {
            this.ode.computeDerivatives(d, dArray, dArray2);
        }

        public void computeMainStateJacobian(double d, double[] dArray, double[] dArray2, double[][] dArray3) {
            int n = this.ode.getDimension();
            double[] dArray4 = new double[n];
            for (int i = 0; i < n; ++i) {
                double d2 = dArray[i];
                int n2 = i;
                dArray[n2] = dArray[n2] + this.hY[i];
                this.ode.computeDerivatives(d, dArray, dArray4);
                for (int j = 0; j < n; ++j) {
                    dArray3[j][i] = (dArray4[j] - dArray2[j]) / this.hY[i];
                }
                dArray[i] = d2;
            }
        }
    }

    private class JacobiansSecondaryEquations
    implements SecondaryEquations {
        private JacobiansSecondaryEquations() {
        }

        public int getDimension() {
            return JacobianMatrices.this.stateDim * (JacobianMatrices.this.stateDim + JacobianMatrices.this.paramDim);
        }

        public void computeDerivatives(double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
            int n;
            int n2;
            if (JacobianMatrices.this.dirtyParameter && JacobianMatrices.this.paramDim != 0) {
                JacobianMatrices.this.jacobianProviders.add(new ParameterJacobianWrapper(JacobianMatrices.this.jode, JacobianMatrices.this.pode, JacobianMatrices.this.selectedParameters));
                JacobianMatrices.this.dirtyParameter = false;
            }
            double[][] dArray5 = new double[JacobianMatrices.this.stateDim][JacobianMatrices.this.stateDim];
            JacobianMatrices.this.jode.computeMainStateJacobian(d, dArray, dArray2, dArray5);
            for (int i = 0; i < JacobianMatrices.this.stateDim; ++i) {
                double[] dArray6 = dArray5[i];
                for (int j = 0; j < JacobianMatrices.this.stateDim; ++j) {
                    int n3;
                    double d2 = 0.0;
                    n2 = n3 = j;
                    for (n = 0; n < JacobianMatrices.this.stateDim; ++n) {
                        d2 += dArray6[n] * dArray3[n2];
                        n2 += JacobianMatrices.this.stateDim;
                    }
                    dArray4[n3 + i * ((JacobianMatrices)JacobianMatrices.this).stateDim] = d2;
                }
            }
            if (JacobianMatrices.this.paramDim != 0) {
                double[] dArray7 = new double[JacobianMatrices.this.stateDim];
                int n4 = JacobianMatrices.this.stateDim * JacobianMatrices.this.stateDim;
                for (ParameterConfiguration parameterConfiguration : JacobianMatrices.this.selectedParameters) {
                    n2 = 0;
                    for (n = 0; n2 == 0 && n < JacobianMatrices.this.jacobianProviders.size(); ++n) {
                        ParameterJacobianProvider parameterJacobianProvider = (ParameterJacobianProvider)JacobianMatrices.this.jacobianProviders.get(n);
                        if (!parameterJacobianProvider.isSupported(parameterConfiguration.getParameterName())) continue;
                        parameterJacobianProvider.computeParameterJacobian(d, dArray, dArray2, parameterConfiguration.getParameterName(), dArray7);
                        for (int i = 0; i < JacobianMatrices.this.stateDim; ++i) {
                            double[] dArray8 = dArray5[i];
                            int n5 = n4;
                            double d3 = dArray7[i];
                            for (int j = 0; j < JacobianMatrices.this.stateDim; ++j) {
                                d3 += dArray8[j] * dArray3[n5];
                                ++n5;
                            }
                            dArray4[n4 + i] = d3;
                        }
                        n2 = 1;
                    }
                    if (n2 == 0) {
                        Arrays.fill(dArray4, n4, n4 + JacobianMatrices.this.stateDim, 0.0);
                    }
                    n4 += JacobianMatrices.this.stateDim;
                }
            }
        }
    }
}

