/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.FirstOrderFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.AdaptiveStepsizeFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853FieldIntegrator;
import org.apache.commons.math3.ode.sampling.FieldStepHandler;
import org.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultistepFieldIntegrator<T extends RealFieldElement<T>>
extends AdaptiveStepsizeFieldIntegrator<T> {
    protected T[] scaled;
    protected Array2DRowFieldMatrix<T> nordsieck;
    private FirstOrderFieldIntegrator<T> starter;
    private final int nSteps;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected MultistepFieldIntegrator(Field<T> field, String string, int n, int n2, double d, double d2, double d3, double d4) {
        super(field, string, d, d2, d3, d4);
        if (n < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, (Number)n, 2, true);
        }
        this.starter = new DormandPrince853FieldIntegrator<T>(field, d, d2, d3, d4);
        this.nSteps = n;
        this.exp = -1.0 / (double)n2;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow(2.0, -this.exp));
    }

    protected MultistepFieldIntegrator(Field<T> field, String string, int n, int n2, double d, double d2, double[] dArray, double[] dArray2) {
        super(field, string, d, d2, dArray, dArray2);
        this.starter = new DormandPrince853FieldIntegrator<T>(field, d, d2, dArray, dArray2);
        this.nSteps = n;
        this.exp = -1.0 / (double)n2;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow(2.0, -this.exp));
    }

    public FirstOrderFieldIntegrator<T> getStarterIntegrator() {
        return this.starter;
    }

    public void setStarterIntegrator(FirstOrderFieldIntegrator<T> firstOrderFieldIntegrator) {
        this.starter = firstOrderFieldIntegrator;
    }

    protected void start(FieldExpandableODE<T> fieldExpandableODE, FieldODEState<T> fieldODEState, T t) {
        this.starter.clearEventHandlers();
        this.starter.clearStepHandlers();
        this.starter.addStepHandler(new FieldNordsieckInitializer(fieldExpandableODE.getMapper(), (this.nSteps + 3) / 2));
        try {
            this.starter.integrate(fieldExpandableODE, fieldODEState, t);
            throw new MathIllegalStateException(LocalizedFormats.MULTISTEP_STARTER_STOPPED_EARLY, new Object[0]);
        }
        catch (InitializationCompletedMarkerException initializationCompletedMarkerException) {
            this.getEvaluationsCounter().increment(this.starter.getEvaluations());
            this.starter.clearStepHandlers();
            return;
        }
    }

    protected abstract Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T var1, T[] var2, T[][] var3, T[][] var4);

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double d) {
        this.minReduction = d;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double d) {
        this.maxGrowth = d;
    }

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double d) {
        this.safety = d;
    }

    public int getNSteps() {
        return this.nSteps;
    }

    protected void rescale(T t) {
        RealFieldElement realFieldElement = (RealFieldElement)t.divide(this.getStepSize());
        for (int i = 0; i < this.scaled.length; ++i) {
            this.scaled[i] = this.scaled[i].multiply((RealFieldElement)realFieldElement);
        }
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])this.nordsieck.getDataRef();
        RealFieldElement realFieldElement2 = realFieldElement;
        for (int i = 0; i < realFieldElementArray.length; ++i) {
            realFieldElement2 = realFieldElement2.multiply(realFieldElement);
            RealFieldElement[] realFieldElementArray2 = realFieldElementArray[i];
            for (int j = 0; j < realFieldElementArray2.length; ++j) {
                realFieldElementArray2[j] = realFieldElementArray2[j].multiply(realFieldElement2);
            }
        }
        this.setStepSize(t);
    }

    protected T computeStepGrowShrinkFactor(T d) {
        return (T)MathUtils.min((RealFieldElement)((RealFieldElement)d.getField().getZero()).add(this.maxGrowth), MathUtils.max((RealFieldElement)((RealFieldElement)d.getField().getZero()).add(this.minReduction), (RealFieldElement)((RealFieldElement)d.pow((double)this.exp)).multiply(this.safety)));
    }

    private static class InitializationCompletedMarkerException
    extends RuntimeException {
        private static final long serialVersionUID = -1914085471038046418L;

        InitializationCompletedMarkerException() {
            super((Throwable)null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldNordsieckInitializer
    implements FieldStepHandler<T> {
        private final FieldEquationsMapper<T> mapper;
        private int count;
        private FieldODEStateAndDerivative<T> savedStart;
        private final T[] t;
        private final T[][] y;
        private final T[][] yDot;

        FieldNordsieckInitializer(FieldEquationsMapper<T> fieldEquationsMapper, int n) {
            this.mapper = fieldEquationsMapper;
            this.count = 0;
            this.t = (RealFieldElement[])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), n);
            this.y = (RealFieldElement[][])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), n, -1);
            this.yDot = (RealFieldElement[][])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), n, -1);
        }

        @Override
        public void handleStep(FieldStepInterpolator<T> fieldStepInterpolator, boolean bl) {
            FieldODEStateAndDerivative fieldODEStateAndDerivative;
            if (this.count == 0) {
                fieldODEStateAndDerivative = fieldStepInterpolator.getPreviousState();
                this.savedStart = fieldODEStateAndDerivative;
                this.t[this.count] = fieldODEStateAndDerivative.getTime();
                this.y[this.count] = this.mapper.mapState(fieldODEStateAndDerivative);
                this.yDot[this.count] = this.mapper.mapDerivative(fieldODEStateAndDerivative);
            }
            ++this.count;
            fieldODEStateAndDerivative = fieldStepInterpolator.getCurrentState();
            this.t[this.count] = fieldODEStateAndDerivative.getTime();
            this.y[this.count] = this.mapper.mapState(fieldODEStateAndDerivative);
            this.yDot[this.count] = this.mapper.mapDerivative(fieldODEStateAndDerivative);
            if (this.count == this.t.length - 1) {
                MultistepFieldIntegrator.this.setStepSize((RealFieldElement)((RealFieldElement)this.t[this.t.length - 1].subtract(this.t[0])).divide(this.t.length - 1));
                MultistepFieldIntegrator.this.scaled = (RealFieldElement[])MathArrays.buildArray(MultistepFieldIntegrator.this.getField(), this.yDot[0].length);
                for (int i = 0; i < MultistepFieldIntegrator.this.scaled.length; ++i) {
                    MultistepFieldIntegrator.this.scaled[i] = (RealFieldElement)this.yDot[0][i].multiply(MultistepFieldIntegrator.this.getStepSize());
                }
                MultistepFieldIntegrator.this.nordsieck = MultistepFieldIntegrator.this.initializeHighOrderDerivatives((RealFieldElement)MultistepFieldIntegrator.this.getStepSize(), (RealFieldElement[])this.t, (RealFieldElement[][])this.y, (RealFieldElement[][])this.yDot);
                MultistepFieldIntegrator.this.setStepStart(this.savedStart);
                throw new InitializationCompletedMarkerException();
            }
        }

        @Override
        public void init(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, T t) {
        }
    }
}

